<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getPrivacyCatsResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: error184: De opgegeven privacy categorie code komt meerdere keren voor. | error183: De opgegeven privacy categorie code kan niet worden gevonden. | error182: Als er een privacy categorie code is opgegeven, moet er ook een hoofd
 * privacy categorie worden opgegeven. | error181: De opgegeven hoofd privacy categorie code komt meerdere keren voor. | error180: De opgegeven hoofd privacy categorie code kan niet worden gevonden.
 * @subpackage Structs
 * @date 20240419 package
 */
class GetPrivacyCatsResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The hoofdCats
     * Meta information extracted from the WSDL
     * - documentation: De opgehaalde resultaat privacy hoofd categorieen, met daarbinnen de hierarchie van categorieen en daaronder de sub categorieen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\PrivacyHoofdCatInfo
     */
    public $hoofdCats;
    /**
     * Constructor method for getPrivacyCatsResponse
     * @uses GetPrivacyCatsResponse::setRequestTag()
     * @uses GetPrivacyCatsResponse::setHoofdCats()
     * @param string $requestTag
     * @param \RelatieApiV6\StructType\PrivacyHoofdCatInfo $hoofdCats
     */
    public function __construct($requestTag = null, \RelatieApiV6\StructType\PrivacyHoofdCatInfo $hoofdCats = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setHoofdCats($hoofdCats);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV6\StructType\GetPrivacyCatsResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get hoofdCats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\PrivacyHoofdCatInfo|null
     */
    public function getHoofdCats()
    {
        return isset($this->hoofdCats) ? $this->hoofdCats : null;
    }
    /**
     * Set hoofdCats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\PrivacyHoofdCatInfo $hoofdCats
     * @return \RelatieApiV6\StructType\GetPrivacyCatsResponse
     */
    public function setHoofdCats(\RelatieApiV6\StructType\PrivacyHoofdCatInfo $hoofdCats = null)
    {
        if (is_null($hoofdCats) || (is_array($hoofdCats) && empty($hoofdCats))) {
            unset($this->hoofdCats);
        } else {
            $this->hoofdCats = $hoofdCats;
        }
        return $this;
    }
}
