<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getPostcodeInfoResponse StructType
 * @subpackage Structs
 * @date 20240419 package
 */
class GetPostcodeInfoResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The huisNummerResult
     * Meta information extracted from the WSDL
     * - documentation: Huisnummer.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $huisNummerResult;
    /**
     * The postcodeResult
     * Meta information extracted from the WSDL
     * - documentation: De postcode waarvoor het adres gevonden is.
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $postcodeResult;
    /**
     * The straat
     * Meta information extracted from the WSDL
     * - documentation: De straatnaam behorende bij de postcode en huisnummer.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $straat;
    /**
     * The woonplaats
     * Meta information extracted from the WSDL
     * - documentation: De woonplaats behorende bij de postcode en huisnummer.
     * - base: xsd:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $woonplaats;
    /**
     * Constructor method for getPostcodeInfoResponse
     * @uses GetPostcodeInfoResponse::setRequestTag()
     * @uses GetPostcodeInfoResponse::setHuisNummerResult()
     * @uses GetPostcodeInfoResponse::setPostcodeResult()
     * @uses GetPostcodeInfoResponse::setStraat()
     * @uses GetPostcodeInfoResponse::setWoonplaats()
     * @param string $requestTag
     * @param float $huisNummerResult
     * @param string $postcodeResult
     * @param string $straat
     * @param string $woonplaats
     */
    public function __construct($requestTag = null, $huisNummerResult = null, $postcodeResult = null, $straat = null, $woonplaats = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setHuisNummerResult($huisNummerResult)
            ->setPostcodeResult($postcodeResult)
            ->setStraat($straat)
            ->setWoonplaats($woonplaats);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV6\StructType\GetPostcodeInfoResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get huisNummerResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getHuisNummerResult()
    {
        return isset($this->huisNummerResult) ? $this->huisNummerResult : null;
    }
    /**
     * Set huisNummerResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $huisNummerResult
     * @return \RelatieApiV6\StructType\GetPostcodeInfoResponse
     */
    public function setHuisNummerResult($huisNummerResult = null)
    {
        // validation for constraint: float
        if (!is_null($huisNummerResult) && !(is_float($huisNummerResult) || is_numeric($huisNummerResult))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($huisNummerResult, true), gettype($huisNummerResult)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($huisNummerResult) && mb_strlen(preg_replace('/(\D)/', '', $huisNummerResult)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($huisNummerResult, true), mb_strlen(preg_replace('/(\D)/', '', $huisNummerResult))), __LINE__);
        }
        if (is_null($huisNummerResult) || (is_array($huisNummerResult) && empty($huisNummerResult))) {
            unset($this->huisNummerResult);
        } else {
            $this->huisNummerResult = $huisNummerResult;
        }
        return $this;
    }
    /**
     * Get postcodeResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostcodeResult()
    {
        return isset($this->postcodeResult) ? $this->postcodeResult : null;
    }
    /**
     * Set postcodeResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postcodeResult
     * @return \RelatieApiV6\StructType\GetPostcodeInfoResponse
     */
    public function setPostcodeResult($postcodeResult = null)
    {
        // validation for constraint: string
        if (!is_null($postcodeResult) && !is_string($postcodeResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcodeResult, true), gettype($postcodeResult)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($postcodeResult) && mb_strlen($postcodeResult) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($postcodeResult)), __LINE__);
        }
        if (is_null($postcodeResult) || (is_array($postcodeResult) && empty($postcodeResult))) {
            unset($this->postcodeResult);
        } else {
            $this->postcodeResult = $postcodeResult;
        }
        return $this;
    }
    /**
     * Get straat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStraat()
    {
        return isset($this->straat) ? $this->straat : null;
    }
    /**
     * Set straat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $straat
     * @return \RelatieApiV6\StructType\GetPostcodeInfoResponse
     */
    public function setStraat($straat = null)
    {
        // validation for constraint: string
        if (!is_null($straat) && !is_string($straat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($straat, true), gettype($straat)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($straat) && mb_strlen($straat) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($straat)), __LINE__);
        }
        if (is_null($straat) || (is_array($straat) && empty($straat))) {
            unset($this->straat);
        } else {
            $this->straat = $straat;
        }
        return $this;
    }
    /**
     * Get woonplaats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWoonplaats()
    {
        return isset($this->woonplaats) ? $this->woonplaats : null;
    }
    /**
     * Set woonplaats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $woonplaats
     * @return \RelatieApiV6\StructType\GetPostcodeInfoResponse
     */
    public function setWoonplaats($woonplaats = null)
    {
        // validation for constraint: string
        if (!is_null($woonplaats) && !is_string($woonplaats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($woonplaats, true), gettype($woonplaats)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($woonplaats) && mb_strlen($woonplaats) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($woonplaats)), __LINE__);
        }
        if (is_null($woonplaats) || (is_array($woonplaats) && empty($woonplaats))) {
            unset($this->woonplaats);
        } else {
            $this->woonplaats = $woonplaats;
        }
        return $this;
    }
}
