<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getPostcodeInfoRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Geeft de straat en huisnummer terug die behoort bij de opgegeven postcode en huisnummer combinatie. Deze operatie werkt alleen indien er een postcodetabel van Cendris in Zeno is geimporteerd of gebruik wordt gemaakt van AdresXpress
 * van Cendris of PostcodeApi.nu. <br/> <br/>Indien gebruik wordt gemaakt van PostcodeApi.nu, wordt geen straat- en plaats gevonden voor postbus-adressen omdat PostcodeApi.nu gebruik maakt van de gegevens uit de Basisadministratie Gemeenten (BAG). <br/>
 * <br/><u>Let op:</u> Deze operatie was voorheen onderdeel van de WebApiV4, maar is verplaatst naar de RelatieApiV6 omdat het relatie-gegevens betreft.
 * @subpackage Structs
 * @date 20240419 package
 */
class GetPostcodeInfoRequest extends AbstractStructBase
{
    /**
     * The postcode
     * Meta information extracted from the WSDL
     * - documentation: Postcode in formaat 0000 AA.
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $postcode;
    /**
     * The huisNummer
     * Meta information extracted from the WSDL
     * - documentation: Huisnummer.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 38
     * @var float
     */
    public $huisNummer;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * Constructor method for getPostcodeInfoRequest
     * @uses GetPostcodeInfoRequest::setPostcode()
     * @uses GetPostcodeInfoRequest::setHuisNummer()
     * @uses GetPostcodeInfoRequest::setRequestTag()
     * @param string $postcode
     * @param float $huisNummer
     * @param string $requestTag
     */
    public function __construct($postcode = null, $huisNummer = null, $requestTag = null)
    {
        $this
            ->setPostcode($postcode)
            ->setHuisNummer($huisNummer)
            ->setRequestTag($requestTag);
    }
    /**
     * Get postcode value
     * @return string
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \RelatieApiV6\StructType\GetPostcodeInfoRequest
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($postcode) && mb_strlen($postcode) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($postcode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($postcode) && mb_strlen($postcode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get huisNummer value
     * @return float
     */
    public function getHuisNummer()
    {
        return $this->huisNummer;
    }
    /**
     * Set huisNummer value
     * @param float $huisNummer
     * @return \RelatieApiV6\StructType\GetPostcodeInfoRequest
     */
    public function setHuisNummer($huisNummer = null)
    {
        // validation for constraint: float
        if (!is_null($huisNummer) && !(is_float($huisNummer) || is_numeric($huisNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($huisNummer, true), gettype($huisNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($huisNummer) && mb_strlen(preg_replace('/(\D)/', '', $huisNummer)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($huisNummer, true), mb_strlen(preg_replace('/(\D)/', '', $huisNummer))), __LINE__);
        }
        $this->huisNummer = $huisNummer;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV6\StructType\GetPostcodeInfoRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
}
