<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getPersonenResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: error16: Op basis van het relatienummer is geen relatie gevonden | error15: Er is geen relatienummer opgegeven
 * @subpackage Structs
 * @date 20240419 package
 */
class GetPersonenResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The personen
     * Meta information extracted from the WSDL
     * - documentation: Een lijst met gegevens van de personen
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\Persoontable
     */
    public $personen;
    /**
     * Constructor method for getPersonenResponse
     * @uses GetPersonenResponse::setRequestTag()
     * @uses GetPersonenResponse::setPersonen()
     * @param string $requestTag
     * @param \RelatieApiV6\StructType\Persoontable $personen
     */
    public function __construct($requestTag = null, \RelatieApiV6\StructType\Persoontable $personen = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setPersonen($personen);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV6\StructType\GetPersonenResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get personen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\Persoontable|null
     */
    public function getPersonen()
    {
        return isset($this->personen) ? $this->personen : null;
    }
    /**
     * Set personen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\Persoontable $personen
     * @return \RelatieApiV6\StructType\GetPersonenResponse
     */
    public function setPersonen(\RelatieApiV6\StructType\Persoontable $personen = null)
    {
        if (is_null($personen) || (is_array($personen) && empty($personen))) {
            unset($this->personen);
        } else {
            $this->personen = $personen;
        }
        return $this;
    }
}
