<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getIbanVanBankrekeningRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Geeft van een opgegeven bankrekening, de IBAN en BIC gegevens terug.<br/> Afhankelijk van wat er in Zeno is ingesteld, wordt dit via iban-converteren.nl of via openiban.nl bepaald.
 * @subpackage Structs
 * @date 20240419 package
 */
class GetIbanVanBankrekeningRequest extends AbstractStructBase
{
    /**
     * The bankrekening
     * Meta information extracted from the WSDL
     * - documentation: Het bankrekeningnummer
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $bankrekening;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * Constructor method for getIbanVanBankrekeningRequest
     * @uses GetIbanVanBankrekeningRequest::setBankrekening()
     * @uses GetIbanVanBankrekeningRequest::setRequestTag()
     * @param string $bankrekening
     * @param string $requestTag
     */
    public function __construct($bankrekening = null, $requestTag = null)
    {
        $this
            ->setBankrekening($bankrekening)
            ->setRequestTag($requestTag);
    }
    /**
     * Get bankrekening value
     * @return string
     */
    public function getBankrekening()
    {
        return $this->bankrekening;
    }
    /**
     * Set bankrekening value
     * @param string $bankrekening
     * @return \RelatieApiV6\StructType\GetIbanVanBankrekeningRequest
     */
    public function setBankrekening($bankrekening = null)
    {
        // validation for constraint: string
        if (!is_null($bankrekening) && !is_string($bankrekening)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankrekening, true), gettype($bankrekening)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($bankrekening) && mb_strlen($bankrekening) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($bankrekening)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($bankrekening) && mb_strlen($bankrekening) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($bankrekening)), __LINE__);
        }
        $this->bankrekening = $bankrekening;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV6\StructType\GetIbanVanBankrekeningRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
}
