<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for deleteKlantKenmerkRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Verwijdert een kenmerk bij een klant. Op basis van een kenmerknummer kan een kenmerk bij een relatie weer verwijderd worden. Het kenmerknummer komt terug bij het aanmaken van een kenmerk (createKenmerk), kan opgehaald worden via
 * getKlantKenmerk (voor Ã©Ã©n kenmerk) of kan opgevraagd worden via getKenmerkInfo. <br/> <br/><u>Let op:</u> Deze operatie was voorheen onderdeel van de WebApiV4, maar is verplaatst naar de RelatieApiV6 omdat het relatie-gegevens betreft.
 * @subpackage Structs
 * @date 20240419 package
 */
class DeleteKlantKenmerkRequest extends AbstractStructBase
{
    /**
     * The kenmerkNo
     * Meta information extracted from the WSDL
     * - documentation: Kenmerknummer van het te verwijderen kenmerk.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $kenmerkNo;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * Constructor method for deleteKlantKenmerkRequest
     * @uses DeleteKlantKenmerkRequest::setKenmerkNo()
     * @uses DeleteKlantKenmerkRequest::setRequestTag()
     * @param int $kenmerkNo
     * @param string $requestTag
     */
    public function __construct($kenmerkNo = null, $requestTag = null)
    {
        $this
            ->setKenmerkNo($kenmerkNo)
            ->setRequestTag($requestTag);
    }
    /**
     * Get kenmerkNo value
     * @return int
     */
    public function getKenmerkNo()
    {
        return $this->kenmerkNo;
    }
    /**
     * Set kenmerkNo value
     * @param int $kenmerkNo
     * @return \RelatieApiV6\StructType\DeleteKlantKenmerkRequest
     */
    public function setKenmerkNo($kenmerkNo = null)
    {
        // validation for constraint: int
        if (!is_null($kenmerkNo) && !(is_int($kenmerkNo) || ctype_digit($kenmerkNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kenmerkNo, true), gettype($kenmerkNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($kenmerkNo) && mb_strlen(preg_replace('/(\D)/', '', $kenmerkNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($kenmerkNo, true), mb_strlen(preg_replace('/(\D)/', '', $kenmerkNo))), __LINE__);
        }
        $this->kenmerkNo = $kenmerkNo;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV6\StructType\DeleteKlantKenmerkRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
}
