<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createContactpersoonRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Aanmaken van een nieuw contactpersoon bij een bedrijf <br/> <br/>Indien een nieuw bedrijf aangemaakt wordt, zie voor de foutmeldingen createBedrijf!
 * @subpackage Structs
 * @date 20240419 package
 */
class CreateContactpersoonRequest extends AbstractStructBase
{
    /**
     * The bedrijf
     * Meta information extracted from the WSDL
     * - documentation: Het bedrijf waarbij het contactpersoon aangemaakt moet worden.<br/>Indien in het bedrijf_rec_v6ord een relatiesleutel bedrijf aanwezig is, zal deze gebruikt worden.<br/> Indien deze niet aanwezig is, wordt een nieuw bedrijf
     * aangemaakt.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \RelatieApiV6\StructType\BedrijfRec
     */
    public $bedrijf;
    /**
     * The contactpersoon
     * Meta information extracted from the WSDL
     * - documentation: De gegevens van de contactpersoon
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \RelatieApiV6\StructType\ContactpersoonRec
     */
    public $contactpersoon;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The forceerKandidaat
     * Meta information extracted from the WSDL
     * - documentation: False (default): Geef een foutmelding indien meerdere kandidaten voldoen aan de input.<br/>True: In geval van meerdere kandidaten wordt de beste match (o.b.v. klantspecifieke instelling) geretourneerd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $forceerKandidaat;
    /**
     * Constructor method for createContactpersoonRequest
     * @uses CreateContactpersoonRequest::setBedrijf()
     * @uses CreateContactpersoonRequest::setContactpersoon()
     * @uses CreateContactpersoonRequest::setRequestTag()
     * @uses CreateContactpersoonRequest::setForceerKandidaat()
     * @param \RelatieApiV6\StructType\BedrijfRec $bedrijf
     * @param \RelatieApiV6\StructType\ContactpersoonRec $contactpersoon
     * @param string $requestTag
     * @param bool $forceerKandidaat
     */
    public function __construct(\RelatieApiV6\StructType\BedrijfRec $bedrijf = null, \RelatieApiV6\StructType\ContactpersoonRec $contactpersoon = null, $requestTag = null, $forceerKandidaat = null)
    {
        $this
            ->setBedrijf($bedrijf)
            ->setContactpersoon($contactpersoon)
            ->setRequestTag($requestTag)
            ->setForceerKandidaat($forceerKandidaat);
    }
    /**
     * Get bedrijf value
     * @return \RelatieApiV6\StructType\BedrijfRec
     */
    public function getBedrijf()
    {
        return $this->bedrijf;
    }
    /**
     * Set bedrijf value
     * @param \RelatieApiV6\StructType\BedrijfRec $bedrijf
     * @return \RelatieApiV6\StructType\CreateContactpersoonRequest
     */
    public function setBedrijf(\RelatieApiV6\StructType\BedrijfRec $bedrijf = null)
    {
        $this->bedrijf = $bedrijf;
        return $this;
    }
    /**
     * Get contactpersoon value
     * @return \RelatieApiV6\StructType\ContactpersoonRec
     */
    public function getContactpersoon()
    {
        return $this->contactpersoon;
    }
    /**
     * Set contactpersoon value
     * @param \RelatieApiV6\StructType\ContactpersoonRec $contactpersoon
     * @return \RelatieApiV6\StructType\CreateContactpersoonRequest
     */
    public function setContactpersoon(\RelatieApiV6\StructType\ContactpersoonRec $contactpersoon = null)
    {
        $this->contactpersoon = $contactpersoon;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV6\StructType\CreateContactpersoonRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get forceerKandidaat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getForceerKandidaat()
    {
        return isset($this->forceerKandidaat) ? $this->forceerKandidaat : null;
    }
    /**
     * Set forceerKandidaat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $forceerKandidaat
     * @return \RelatieApiV6\StructType\CreateContactpersoonRequest
     */
    public function setForceerKandidaat($forceerKandidaat = null)
    {
        // validation for constraint: boolean
        if (!is_null($forceerKandidaat) && !is_bool($forceerKandidaat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forceerKandidaat, true), gettype($forceerKandidaat)), __LINE__);
        }
        if (is_null($forceerKandidaat) || (is_array($forceerKandidaat) && empty($forceerKandidaat))) {
            unset($this->forceerKandidaat);
        } else {
            $this->forceerKandidaat = $forceerKandidaat;
        }
        return $this;
    }
}
