<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createAfdelingResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: error100: Op basis van de input bestaan al meerdere relaties | error72: De opgegeven valutacode is niet gevonden | error71: De opgegeven taalcode is niet gevonden | error54: Op basis van de opgegeven waarde voor codeveld 6 is niets
 * gevonden | error53: Op basis van de opgegeven waarde voor codeveld 5 is niets gevonden | error52: Op basis van de opgegeven waarde voor codeveld 4 is niets gevonden | error51: Op basis van de opgegeven waarde voor codeveld 3 is niets gevonden |
 * error50: Op basis van de opgegeven waarde voor codeveld 2 is niets gevonden | error49: Op basis van de opgegeven waarde voor codeveld 1 is niets gevonden | error48: De opgegeven relatie kortinggroepcode is niet gevonden | error46: De opgegeven
 * plaatsnaam komt niet overeen met de plaatsnaam behorende bij de postcode/huisnummer combinatie | error45: De opgegeven straatnaam komt niet overeen met de straatnaam behorende bij de postcode/huisnummer combinatie | error41: Het opgegeven (NL-) IBAN
 * nummer en de BIC code horen niet bij elkaar | error40: De opgegeven bic code is niet geldig | error39: Het opgegeven IBAN nummer voldoet niet aan de eisen | error38: Bij automatische incasso is een iban nummer verplicht | error37: Het opgegeven
 * bankrekeningnummer voldoet niet aan de 11-proef | error36: Bij automatische incasso is een bankrekeningnummer verplicht | error35: De opgegeven betaalwijze is niet geldig | error24: Er is voor de afdeling geen naam opgegeven | error22: Er is geen
 * relatienummer voor het bedrijf opgegeven | error21: Het opgegeven faxnummer is ongeldig | error20: Het e-mail adres (2) is niet valide | error18: De op basis van het relatienummer bedrijf gevonden relatie is geen bedrijf | error17: Op basis van het
 * relatienummer bedrijf is geen relatie gevonden | error9: Het opgegeven telefoonnummer is niet valide | error8: Het e-mail adres (1) is niet valide | error6: Provincie komt niet voor in het opgegeven land | error5: Indien een provincie opgegeven
 * wordt, is een land verplicht | error4: Provincie is niet gevonden | error3: Adres is niet gevonden in de postcodetabel | error2: Adresgegevens zijn niet compleet | error1: Adresgegevens ontbreken | error0: De opgegeven landcode is niet gevonden
 * @subpackage Structs
 * @date 20240419 package
 */
class CreateAfdelingResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The relatienummerAfdeling
     * Meta information extracted from the WSDL
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relatienummerAfdeling;
    /**
     * The relatienummerBedrijfGebruikt
     * Meta information extracted from the WSDL
     * - documentation: Daadwerkelijk gebruikte relatienummer van het bedrijf
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relatienummerBedrijfGebruikt;
    /**
     * The isNieuweRelatie
     * Meta information extracted from the WSDL
     * - documentation: Is dit een nieuwe (true) of een bestaande (false) relatie?
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $isNieuweRelatie;
    /**
     * Constructor method for createAfdelingResponse
     * @uses CreateAfdelingResponse::setRequestTag()
     * @uses CreateAfdelingResponse::setRelatienummerAfdeling()
     * @uses CreateAfdelingResponse::setRelatienummerBedrijfGebruikt()
     * @uses CreateAfdelingResponse::setIsNieuweRelatie()
     * @param string $requestTag
     * @param int $relatienummerAfdeling
     * @param int $relatienummerBedrijfGebruikt
     * @param bool $isNieuweRelatie
     */
    public function __construct($requestTag = null, $relatienummerAfdeling = null, $relatienummerBedrijfGebruikt = null, $isNieuweRelatie = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setRelatienummerAfdeling($relatienummerAfdeling)
            ->setRelatienummerBedrijfGebruikt($relatienummerBedrijfGebruikt)
            ->setIsNieuweRelatie($isNieuweRelatie);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV6\StructType\CreateAfdelingResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get relatienummerAfdeling value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelatienummerAfdeling()
    {
        return isset($this->relatienummerAfdeling) ? $this->relatienummerAfdeling : null;
    }
    /**
     * Set relatienummerAfdeling value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relatienummerAfdeling
     * @return \RelatieApiV6\StructType\CreateAfdelingResponse
     */
    public function setRelatienummerAfdeling($relatienummerAfdeling = null)
    {
        // validation for constraint: int
        if (!is_null($relatienummerAfdeling) && !(is_int($relatienummerAfdeling) || ctype_digit($relatienummerAfdeling))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatienummerAfdeling, true), gettype($relatienummerAfdeling)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatienummerAfdeling) && mb_strlen(preg_replace('/(\D)/', '', $relatienummerAfdeling)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatienummerAfdeling, true), mb_strlen(preg_replace('/(\D)/', '', $relatienummerAfdeling))), __LINE__);
        }
        if (is_null($relatienummerAfdeling) || (is_array($relatienummerAfdeling) && empty($relatienummerAfdeling))) {
            unset($this->relatienummerAfdeling);
        } else {
            $this->relatienummerAfdeling = $relatienummerAfdeling;
        }
        return $this;
    }
    /**
     * Get relatienummerBedrijfGebruikt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelatienummerBedrijfGebruikt()
    {
        return isset($this->relatienummerBedrijfGebruikt) ? $this->relatienummerBedrijfGebruikt : null;
    }
    /**
     * Set relatienummerBedrijfGebruikt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relatienummerBedrijfGebruikt
     * @return \RelatieApiV6\StructType\CreateAfdelingResponse
     */
    public function setRelatienummerBedrijfGebruikt($relatienummerBedrijfGebruikt = null)
    {
        // validation for constraint: int
        if (!is_null($relatienummerBedrijfGebruikt) && !(is_int($relatienummerBedrijfGebruikt) || ctype_digit($relatienummerBedrijfGebruikt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatienummerBedrijfGebruikt, true), gettype($relatienummerBedrijfGebruikt)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatienummerBedrijfGebruikt) && mb_strlen(preg_replace('/(\D)/', '', $relatienummerBedrijfGebruikt)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatienummerBedrijfGebruikt, true), mb_strlen(preg_replace('/(\D)/', '', $relatienummerBedrijfGebruikt))), __LINE__);
        }
        if (is_null($relatienummerBedrijfGebruikt) || (is_array($relatienummerBedrijfGebruikt) && empty($relatienummerBedrijfGebruikt))) {
            unset($this->relatienummerBedrijfGebruikt);
        } else {
            $this->relatienummerBedrijfGebruikt = $relatienummerBedrijfGebruikt;
        }
        return $this;
    }
    /**
     * Get isNieuweRelatie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsNieuweRelatie()
    {
        return isset($this->isNieuweRelatie) ? $this->isNieuweRelatie : null;
    }
    /**
     * Set isNieuweRelatie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isNieuweRelatie
     * @return \RelatieApiV6\StructType\CreateAfdelingResponse
     */
    public function setIsNieuweRelatie($isNieuweRelatie = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNieuweRelatie) && !is_bool($isNieuweRelatie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isNieuweRelatie, true), gettype($isNieuweRelatie)), __LINE__);
        }
        if (is_null($isNieuweRelatie) || (is_array($isNieuweRelatie) && empty($isNieuweRelatie))) {
            unset($this->isNieuweRelatie);
        } else {
            $this->isNieuweRelatie = $isNieuweRelatie;
        }
        return $this;
    }
}
