<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactpersooninfoRec StructType
 * Meta information extracted from the WSDL
 * - documentation: Contactpersoon informatie gegevens
 * @subpackage Structs
 * @date 20240419 package
 */
class ContactpersooninfoRec extends AbstractStructBase
{
    /**
     * The contactpersoon
     * Meta information extracted from the WSDL
     * - documentation: De contactpersoongegevens
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\ContactpersoonRec
     */
    public $contactpersoon;
    /**
     * The leververbod
     * Meta information extracted from the WSDL
     * - documentation: De relatie heeft een leververbod
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $leververbod;
    /**
     * The functies
     * Meta information extracted from the WSDL
     * - documentation: De aan de relatie gekoppelde functies
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\RelatieFunctietable
     */
    public $functies;
    /**
     * The biccodes
     * Meta information extracted from the WSDL
     * - documentation: De aan de relatie gekoppelde biccodes
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\RelatieBiccodetable
     */
    public $biccodes;
    /**
     * The bedrijf
     * Meta information extracted from the WSDL
     * - documentation: Het bedrijf waar de contactpersoon werkzaam is
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\BedrijfRec
     */
    public $bedrijf;
    /**
     * Constructor method for ContactpersooninfoRec
     * @uses ContactpersooninfoRec::setContactpersoon()
     * @uses ContactpersooninfoRec::setLeververbod()
     * @uses ContactpersooninfoRec::setFuncties()
     * @uses ContactpersooninfoRec::setBiccodes()
     * @uses ContactpersooninfoRec::setBedrijf()
     * @param \RelatieApiV6\StructType\ContactpersoonRec $contactpersoon
     * @param bool $leververbod
     * @param \RelatieApiV6\StructType\RelatieFunctietable $functies
     * @param \RelatieApiV6\StructType\RelatieBiccodetable $biccodes
     * @param \RelatieApiV6\StructType\BedrijfRec $bedrijf
     */
    public function __construct(\RelatieApiV6\StructType\ContactpersoonRec $contactpersoon = null, $leververbod = null, \RelatieApiV6\StructType\RelatieFunctietable $functies = null, \RelatieApiV6\StructType\RelatieBiccodetable $biccodes = null, \RelatieApiV6\StructType\BedrijfRec $bedrijf = null)
    {
        $this
            ->setContactpersoon($contactpersoon)
            ->setLeververbod($leververbod)
            ->setFuncties($functies)
            ->setBiccodes($biccodes)
            ->setBedrijf($bedrijf);
    }
    /**
     * Get contactpersoon value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\ContactpersoonRec|null
     */
    public function getContactpersoon()
    {
        return isset($this->contactpersoon) ? $this->contactpersoon : null;
    }
    /**
     * Set contactpersoon value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\ContactpersoonRec $contactpersoon
     * @return \RelatieApiV6\StructType\ContactpersooninfoRec
     */
    public function setContactpersoon(\RelatieApiV6\StructType\ContactpersoonRec $contactpersoon = null)
    {
        if (is_null($contactpersoon) || (is_array($contactpersoon) && empty($contactpersoon))) {
            unset($this->contactpersoon);
        } else {
            $this->contactpersoon = $contactpersoon;
        }
        return $this;
    }
    /**
     * Get leververbod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getLeververbod()
    {
        return isset($this->leververbod) ? $this->leververbod : null;
    }
    /**
     * Set leververbod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $leververbod
     * @return \RelatieApiV6\StructType\ContactpersooninfoRec
     */
    public function setLeververbod($leververbod = null)
    {
        // validation for constraint: boolean
        if (!is_null($leververbod) && !is_bool($leververbod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($leververbod, true), gettype($leververbod)), __LINE__);
        }
        if (is_null($leververbod) || (is_array($leververbod) && empty($leververbod))) {
            unset($this->leververbod);
        } else {
            $this->leververbod = $leververbod;
        }
        return $this;
    }
    /**
     * Get functies value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\RelatieFunctietable|null
     */
    public function getFuncties()
    {
        return isset($this->functies) ? $this->functies : null;
    }
    /**
     * Set functies value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\RelatieFunctietable $functies
     * @return \RelatieApiV6\StructType\ContactpersooninfoRec
     */
    public function setFuncties(\RelatieApiV6\StructType\RelatieFunctietable $functies = null)
    {
        if (is_null($functies) || (is_array($functies) && empty($functies))) {
            unset($this->functies);
        } else {
            $this->functies = $functies;
        }
        return $this;
    }
    /**
     * Get biccodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\RelatieBiccodetable|null
     */
    public function getBiccodes()
    {
        return isset($this->biccodes) ? $this->biccodes : null;
    }
    /**
     * Set biccodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\RelatieBiccodetable $biccodes
     * @return \RelatieApiV6\StructType\ContactpersooninfoRec
     */
    public function setBiccodes(\RelatieApiV6\StructType\RelatieBiccodetable $biccodes = null)
    {
        if (is_null($biccodes) || (is_array($biccodes) && empty($biccodes))) {
            unset($this->biccodes);
        } else {
            $this->biccodes = $biccodes;
        }
        return $this;
    }
    /**
     * Get bedrijf value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\BedrijfRec|null
     */
    public function getBedrijf()
    {
        return isset($this->bedrijf) ? $this->bedrijf : null;
    }
    /**
     * Set bedrijf value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\BedrijfRec $bedrijf
     * @return \RelatieApiV6\StructType\ContactpersooninfoRec
     */
    public function setBedrijf(\RelatieApiV6\StructType\BedrijfRec $bedrijf = null)
    {
        if (is_null($bedrijf) || (is_array($bedrijf) && empty($bedrijf))) {
            unset($this->bedrijf);
        } else {
            $this->bedrijf = $bedrijf;
        }
        return $this;
    }
}
