<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Biccodetable StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met bic codes
 * @subpackage Structs
 * @date 20240419 package
 */
class Biccodetable extends AbstractStructBase
{
    /**
     * The biccode
     * Meta information extracted from the WSDL
     * - documentation: Bic codes
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \RelatieApiV6\StructType\BiccodeRec[]
     */
    public $biccode;
    /**
     * Constructor method for Biccodetable
     * @uses Biccodetable::setBiccode()
     * @param \RelatieApiV6\StructType\BiccodeRec[] $biccode
     */
    public function __construct(array $biccode = array())
    {
        $this
            ->setBiccode($biccode);
    }
    /**
     * Get biccode value
     * @return \RelatieApiV6\StructType\BiccodeRec[]|null
     */
    public function getBiccode()
    {
        return $this->biccode;
    }
    /**
     * This method is responsible for validating the values passed to the setBiccode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBiccode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBiccodeForArrayConstraintsFromSetBiccode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $biccodetableBiccodeItem) {
            // validation for constraint: itemType
            if (!$biccodetableBiccodeItem instanceof \RelatieApiV6\StructType\BiccodeRec) {
                $invalidValues[] = is_object($biccodetableBiccodeItem) ? get_class($biccodetableBiccodeItem) : sprintf('%s(%s)', gettype($biccodetableBiccodeItem), var_export($biccodetableBiccodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The biccode property can only contain items of type \RelatieApiV6\StructType\BiccodeRec, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set biccode value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV6\StructType\BiccodeRec[] $biccode
     * @return \RelatieApiV6\StructType\Biccodetable
     */
    public function setBiccode(array $biccode = array())
    {
        // validation for constraint: array
        if ('' !== ($biccodeArrayErrorMessage = self::validateBiccodeForArrayConstraintsFromSetBiccode($biccode))) {
            throw new \InvalidArgumentException($biccodeArrayErrorMessage, __LINE__);
        }
        $this->biccode = $biccode;
        return $this;
    }
    /**
     * Add item to biccode value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV6\StructType\BiccodeRec $item
     * @return \RelatieApiV6\StructType\Biccodetable
     */
    public function addToBiccode(\RelatieApiV6\StructType\BiccodeRec $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \RelatieApiV6\StructType\BiccodeRec) {
            throw new \InvalidArgumentException(sprintf('The biccode property can only contain items of type \RelatieApiV6\StructType\BiccodeRec, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->biccode[] = $item;
        return $this;
    }
}
