<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BedrijfInclConttable StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met gecombineerde bedrijf en contactpersoon relaties
 * @subpackage Structs
 * @date 20240419 package
 */
class BedrijfInclConttable extends AbstractStructBase
{
    /**
     * The bedrijfInclCont
     * Meta information extracted from the WSDL
     * - documentation: Bedrijf incl contactpersonen
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \RelatieApiV6\StructType\BedrijfInclContinfoRec[]
     */
    public $bedrijfInclCont;
    /**
     * Constructor method for BedrijfInclConttable
     * @uses BedrijfInclConttable::setBedrijfInclCont()
     * @param \RelatieApiV6\StructType\BedrijfInclContinfoRec[] $bedrijfInclCont
     */
    public function __construct(array $bedrijfInclCont = array())
    {
        $this
            ->setBedrijfInclCont($bedrijfInclCont);
    }
    /**
     * Get bedrijfInclCont value
     * @return \RelatieApiV6\StructType\BedrijfInclContinfoRec[]|null
     */
    public function getBedrijfInclCont()
    {
        return $this->bedrijfInclCont;
    }
    /**
     * This method is responsible for validating the values passed to the setBedrijfInclCont method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBedrijfInclCont method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBedrijfInclContForArrayConstraintsFromSetBedrijfInclCont(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bedrijfInclConttableBedrijfInclContItem) {
            // validation for constraint: itemType
            if (!$bedrijfInclConttableBedrijfInclContItem instanceof \RelatieApiV6\StructType\BedrijfInclContinfoRec) {
                $invalidValues[] = is_object($bedrijfInclConttableBedrijfInclContItem) ? get_class($bedrijfInclConttableBedrijfInclContItem) : sprintf('%s(%s)', gettype($bedrijfInclConttableBedrijfInclContItem), var_export($bedrijfInclConttableBedrijfInclContItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The bedrijfInclCont property can only contain items of type \RelatieApiV6\StructType\BedrijfInclContinfoRec, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set bedrijfInclCont value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV6\StructType\BedrijfInclContinfoRec[] $bedrijfInclCont
     * @return \RelatieApiV6\StructType\BedrijfInclConttable
     */
    public function setBedrijfInclCont(array $bedrijfInclCont = array())
    {
        // validation for constraint: array
        if ('' !== ($bedrijfInclContArrayErrorMessage = self::validateBedrijfInclContForArrayConstraintsFromSetBedrijfInclCont($bedrijfInclCont))) {
            throw new \InvalidArgumentException($bedrijfInclContArrayErrorMessage, __LINE__);
        }
        $this->bedrijfInclCont = $bedrijfInclCont;
        return $this;
    }
    /**
     * Add item to bedrijfInclCont value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV6\StructType\BedrijfInclContinfoRec $item
     * @return \RelatieApiV6\StructType\BedrijfInclConttable
     */
    public function addToBedrijfInclCont(\RelatieApiV6\StructType\BedrijfInclContinfoRec $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \RelatieApiV6\StructType\BedrijfInclContinfoRec) {
            throw new \InvalidArgumentException(sprintf('The bedrijfInclCont property can only contain items of type \RelatieApiV6\StructType\BedrijfInclContinfoRec, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->bedrijfInclCont[] = $item;
        return $this;
    }
}
