<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AfdelinginfoRec StructType
 * Meta information extracted from the WSDL
 * - documentation: Afdeling info
 * @subpackage Structs
 * @date 20240419 package
 */
class AfdelinginfoRec extends AbstractStructBase
{
    /**
     * The afdeling
     * Meta information extracted from the WSDL
     * - documentation: De gegevens van de afdeling
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\AfdelingRec
     */
    public $afdeling;
    /**
     * The leververbod
     * Meta information extracted from the WSDL
     * - documentation: De relatie heeft een leververbod
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $leververbod;
    /**
     * The functies
     * Meta information extracted from the WSDL
     * - documentation: De aan de relatie gekoppelde functies
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\RelatieFunctietable
     */
    public $functies;
    /**
     * The biccodes
     * Meta information extracted from the WSDL
     * - documentation: De aan de relatie gekoppelde biccodes
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\RelatieBiccodetable
     */
    public $biccodes;
    /**
     * Constructor method for AfdelinginfoRec
     * @uses AfdelinginfoRec::setAfdeling()
     * @uses AfdelinginfoRec::setLeververbod()
     * @uses AfdelinginfoRec::setFuncties()
     * @uses AfdelinginfoRec::setBiccodes()
     * @param \RelatieApiV6\StructType\AfdelingRec $afdeling
     * @param bool $leververbod
     * @param \RelatieApiV6\StructType\RelatieFunctietable $functies
     * @param \RelatieApiV6\StructType\RelatieBiccodetable $biccodes
     */
    public function __construct(\RelatieApiV6\StructType\AfdelingRec $afdeling = null, $leververbod = null, \RelatieApiV6\StructType\RelatieFunctietable $functies = null, \RelatieApiV6\StructType\RelatieBiccodetable $biccodes = null)
    {
        $this
            ->setAfdeling($afdeling)
            ->setLeververbod($leververbod)
            ->setFuncties($functies)
            ->setBiccodes($biccodes);
    }
    /**
     * Get afdeling value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\AfdelingRec|null
     */
    public function getAfdeling()
    {
        return isset($this->afdeling) ? $this->afdeling : null;
    }
    /**
     * Set afdeling value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\AfdelingRec $afdeling
     * @return \RelatieApiV6\StructType\AfdelinginfoRec
     */
    public function setAfdeling(\RelatieApiV6\StructType\AfdelingRec $afdeling = null)
    {
        if (is_null($afdeling) || (is_array($afdeling) && empty($afdeling))) {
            unset($this->afdeling);
        } else {
            $this->afdeling = $afdeling;
        }
        return $this;
    }
    /**
     * Get leververbod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getLeververbod()
    {
        return isset($this->leververbod) ? $this->leververbod : null;
    }
    /**
     * Set leververbod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $leververbod
     * @return \RelatieApiV6\StructType\AfdelinginfoRec
     */
    public function setLeververbod($leververbod = null)
    {
        // validation for constraint: boolean
        if (!is_null($leververbod) && !is_bool($leververbod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($leververbod, true), gettype($leververbod)), __LINE__);
        }
        if (is_null($leververbod) || (is_array($leververbod) && empty($leververbod))) {
            unset($this->leververbod);
        } else {
            $this->leververbod = $leververbod;
        }
        return $this;
    }
    /**
     * Get functies value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\RelatieFunctietable|null
     */
    public function getFuncties()
    {
        return isset($this->functies) ? $this->functies : null;
    }
    /**
     * Set functies value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\RelatieFunctietable $functies
     * @return \RelatieApiV6\StructType\AfdelinginfoRec
     */
    public function setFuncties(\RelatieApiV6\StructType\RelatieFunctietable $functies = null)
    {
        if (is_null($functies) || (is_array($functies) && empty($functies))) {
            unset($this->functies);
        } else {
            $this->functies = $functies;
        }
        return $this;
    }
    /**
     * Get biccodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\RelatieBiccodetable|null
     */
    public function getBiccodes()
    {
        return isset($this->biccodes) ? $this->biccodes : null;
    }
    /**
     * Set biccodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\RelatieBiccodetable $biccodes
     * @return \RelatieApiV6\StructType\AfdelinginfoRec
     */
    public function setBiccodes(\RelatieApiV6\StructType\RelatieBiccodetable $biccodes = null)
    {
        if (is_null($biccodes) || (is_array($biccodes) && empty($biccodes))) {
            unset($this->biccodes);
        } else {
            $this->biccodes = $biccodes;
        }
        return $this;
    }
}
