<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdresRec StructType
 * Meta information extracted from the WSDL
 * - documentation: Adres
 * @subpackage Structs
 * @date 20240419 package
 */
class AdresRec extends AbstractStructBase
{
    /**
     * The straatnaam
     * Meta information extracted from the WSDL
     * - documentation: De straatnaam van het adres
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $straatnaam;
    /**
     * The huisnummer
     * Meta information extracted from the WSDL
     * - documentation: Het huisnummer van het adres. Standaard is dit verplicht, maar in Zeno is optioneel per land in te stellen dat het huisnummer optioneel is.
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $huisnummer;
    /**
     * The huisnummerToevoeging
     * Meta information extracted from the WSDL
     * - documentation: De huisnummer toevoeging van het adres
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $huisnummerToevoeging;
    /**
     * The postcode
     * Meta information extracted from the WSDL
     * - documentation: De postcode van het adres. Standaard is dit verplicht, maar in Zeno is optioneel per land in te stellen dat de postcode optioneel is.
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $postcode;
    /**
     * The plaatsnaam
     * Meta information extracted from the WSDL
     * - documentation: De plaatsnaam van het adres
     * - base: xsd:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $plaatsnaam;
    /**
     * Constructor method for AdresRec
     * @uses AdresRec::setStraatnaam()
     * @uses AdresRec::setHuisnummer()
     * @uses AdresRec::setHuisnummerToevoeging()
     * @uses AdresRec::setPostcode()
     * @uses AdresRec::setPlaatsnaam()
     * @param string $straatnaam
     * @param string $huisnummer
     * @param string $huisnummerToevoeging
     * @param string $postcode
     * @param string $plaatsnaam
     */
    public function __construct($straatnaam = null, $huisnummer = null, $huisnummerToevoeging = null, $postcode = null, $plaatsnaam = null)
    {
        $this
            ->setStraatnaam($straatnaam)
            ->setHuisnummer($huisnummer)
            ->setHuisnummerToevoeging($huisnummerToevoeging)
            ->setPostcode($postcode)
            ->setPlaatsnaam($plaatsnaam);
    }
    /**
     * Get straatnaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStraatnaam()
    {
        return isset($this->straatnaam) ? $this->straatnaam : null;
    }
    /**
     * Set straatnaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $straatnaam
     * @return \RelatieApiV6\StructType\AdresRec
     */
    public function setStraatnaam($straatnaam = null)
    {
        // validation for constraint: string
        if (!is_null($straatnaam) && !is_string($straatnaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($straatnaam, true), gettype($straatnaam)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($straatnaam) && mb_strlen($straatnaam) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($straatnaam)), __LINE__);
        }
        if (is_null($straatnaam) || (is_array($straatnaam) && empty($straatnaam))) {
            unset($this->straatnaam);
        } else {
            $this->straatnaam = $straatnaam;
        }
        return $this;
    }
    /**
     * Get huisnummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHuisnummer()
    {
        return isset($this->huisnummer) ? $this->huisnummer : null;
    }
    /**
     * Set huisnummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $huisnummer
     * @return \RelatieApiV6\StructType\AdresRec
     */
    public function setHuisnummer($huisnummer = null)
    {
        // validation for constraint: string
        if (!is_null($huisnummer) && !is_string($huisnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($huisnummer, true), gettype($huisnummer)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($huisnummer) && mb_strlen($huisnummer) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($huisnummer)), __LINE__);
        }
        if (is_null($huisnummer) || (is_array($huisnummer) && empty($huisnummer))) {
            unset($this->huisnummer);
        } else {
            $this->huisnummer = $huisnummer;
        }
        return $this;
    }
    /**
     * Get huisnummerToevoeging value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHuisnummerToevoeging()
    {
        return isset($this->huisnummerToevoeging) ? $this->huisnummerToevoeging : null;
    }
    /**
     * Set huisnummerToevoeging value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $huisnummerToevoeging
     * @return \RelatieApiV6\StructType\AdresRec
     */
    public function setHuisnummerToevoeging($huisnummerToevoeging = null)
    {
        // validation for constraint: string
        if (!is_null($huisnummerToevoeging) && !is_string($huisnummerToevoeging)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($huisnummerToevoeging, true), gettype($huisnummerToevoeging)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($huisnummerToevoeging) && mb_strlen($huisnummerToevoeging) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($huisnummerToevoeging)), __LINE__);
        }
        if (is_null($huisnummerToevoeging) || (is_array($huisnummerToevoeging) && empty($huisnummerToevoeging))) {
            unset($this->huisnummerToevoeging);
        } else {
            $this->huisnummerToevoeging = $huisnummerToevoeging;
        }
        return $this;
    }
    /**
     * Get postcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostcode()
    {
        return isset($this->postcode) ? $this->postcode : null;
    }
    /**
     * Set postcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postcode
     * @return \RelatieApiV6\StructType\AdresRec
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($postcode) && mb_strlen($postcode) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($postcode)), __LINE__);
        }
        if (is_null($postcode) || (is_array($postcode) && empty($postcode))) {
            unset($this->postcode);
        } else {
            $this->postcode = $postcode;
        }
        return $this;
    }
    /**
     * Get plaatsnaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlaatsnaam()
    {
        return isset($this->plaatsnaam) ? $this->plaatsnaam : null;
    }
    /**
     * Set plaatsnaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plaatsnaam
     * @return \RelatieApiV6\StructType\AdresRec
     */
    public function setPlaatsnaam($plaatsnaam = null)
    {
        // validation for constraint: string
        if (!is_null($plaatsnaam) && !is_string($plaatsnaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plaatsnaam, true), gettype($plaatsnaam)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($plaatsnaam) && mb_strlen($plaatsnaam) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($plaatsnaam)), __LINE__);
        }
        if (is_null($plaatsnaam) || (is_array($plaatsnaam) && empty($plaatsnaam))) {
            unset($this->plaatsnaam);
        } else {
            $this->plaatsnaam = $plaatsnaam;
        }
        return $this;
    }
}
