<?php

namespace RelatieApiV6\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Generate ServiceType
 * @subpackage Services
 * @date 20240419 package
 */
class Generate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named generatePassword
     * Meta information extracted from the WSDL
     * - documentation: Genereren van een nieuw wachtwoord voor een relatie.error45: Op basis van de inloggegevens is geen relatie gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\GeneratePasswordRequest $request_parameters
     * @return \RelatieApiV6\StructType\GeneratePasswordResponse|bool
     */
    public function generatePassword(\RelatieApiV6\StructType\GeneratePasswordRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generatePassword($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \RelatieApiV6\StructType\GeneratePasswordResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
