<?php

namespace RelatieApiV6\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 * @date 20240419 package
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named addBic
     * Meta information extracted from the WSDL
     * - documentation: Toevoegen van een Bic code aan een bestaande relatie in Zeno op basis van relatienummer en Bic-codeerror15: Er is geen relatienummer opgegevenerror16: Op basis van het opgegeven nummer is geen relatie gevondenerror25: Er is geen
     * Bic-code opgegevenerror26: De opgegeven bic-code is niet gevondenerror31: De opgegeven bic-code is al gekoppeld aan de relatie
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\AddBicRequest $request_parameters
     * @return \RelatieApiV6\StructType\AddBicResponse|bool
     */
    public function addBic(\RelatieApiV6\StructType\AddBicRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->addBic($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named addFunctie
     * Meta information extracted from the WSDL
     * - documentation: Toevoegen van een functie aan een bestaande relatieerror15: Er is geen relatienummer opgegevenerror16: Op basis van het opgegeven nummer is geen relatie gevondenerror29: Er is geen functiecode opgegevenerror30: De opgegeven
     * functiecode is niet gevondenerror32: De opgegeven functiecode is al gekoppeld aan de relatie
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\AddFunctieRequest $request_parameters
     * @return \RelatieApiV6\StructType\AddFunctieResponse|bool
     */
    public function addFunctie(\RelatieApiV6\StructType\AddFunctieRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->addFunctie($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \RelatieApiV6\StructType\AddBicResponse|\RelatieApiV6\StructType\AddFunctieResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
