<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updatePersoonResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: error103: Er zijn ongeldige voorletters opgegeven. | error101: De opgegeven username is niet uniek | error72: De opgegeven valutacode is niet gevonden | error71: De opgegeven taalcode is niet gevonden | error54: Op basis van de
 * opgegeven waarde voor codeveld 6 is niets gevonden | error53: Op basis van de opgegeven waarde voor codeveld 5 is niets gevonden | error52: Op basis van de opgegeven waarde voor codeveld 4 is niets gevonden | error51: Op basis van de opgegeven waarde
 * voor codeveld 3 is niets gevonden | error50: Op basis van de opgegeven waarde voor codeveld 2 is niets gevonden | error49: Op basis van de opgegeven waarde voor codeveld 1 is niets gevonden | error48: De opgegeven relatie kortinggroepcode is niet
 * gevonden | error46: De opgegeven plaatsnaam komt niet overeen met de plaatsnaam behorende bij de postcode/huisnummer combinatie | error45: De opgegeven straatnaam komt niet overeen met de straatnaam behorende bij de postcode/huisnummer combinatie |
 * error41: Het opgegeven (NL-) IBAN nummer en de BIC code horen niet bij elkaar | error40: De opgegeven bic code is niet geldig | error39: Het opgegeven IBAN nummer voldoet niet aan de eisen | error38: Bij automatische incasso is een iban nummer
 * verplicht | error37: Het opgegeven bankrekeningnummer voldoet niet aan de 11-proef | error36: Bij automatische incasso is een bankrekeningnummer verplicht | error35: De opgegeven betaalwijze is niet geldig | error23: Op basis van het relatienummer is
 * een bedrijf gevonden. Wijzigen persoonsgegevens is niet mogelijk | error20: Het e-mail adres (2) is niet valide | error16: Op basis van het relatienummer is geen relatie gevonden | error15: Er is geen relatienummer opgegeven | error13: Het opgegeven
 * geslacht is niet geldig | error12: De opgegeven geboortedatum is niet geldig | error11: De opgegeven titulatuurcode is niet gevonden | error10: Het opgegeven mobiele telefoonnummer is niet geldig | error9: Het opgegeven telefoonnummer is niet valide
 * | error8: Het e-mail adres (1) is niet valide | error7: Er is geen achternaam opgegeven | error6: Provincie komt niet voor in het opgegeven land | error5: Indien een provincie opgegeven wordt, is een land verplicht | error4: Provincie is niet
 * gevonden | error3: Adres is niet gevonden in de postcodetabel | error2: Adresgegevens zijn niet compleet | error1: Adresgegevens ontbreken | error0: De opgegeven landcode is niet gevonden
 * @subpackage Structs
 * @date 20240419 package
 */
class UpdatePersoonResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The relatienummerGebruikt
     * Meta information extracted from the WSDL
     * - documentation: Het daadwerkelijk gebruikte relatienummer
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relatienummerGebruikt;
    /**
     * Constructor method for updatePersoonResponse
     * @uses UpdatePersoonResponse::setRequestTag()
     * @uses UpdatePersoonResponse::setRelatienummerGebruikt()
     * @param string $requestTag
     * @param int $relatienummerGebruikt
     */
    public function __construct($requestTag = null, $relatienummerGebruikt = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setRelatienummerGebruikt($relatienummerGebruikt);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV6\StructType\UpdatePersoonResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get relatienummerGebruikt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelatienummerGebruikt()
    {
        return isset($this->relatienummerGebruikt) ? $this->relatienummerGebruikt : null;
    }
    /**
     * Set relatienummerGebruikt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relatienummerGebruikt
     * @return \RelatieApiV6\StructType\UpdatePersoonResponse
     */
    public function setRelatienummerGebruikt($relatienummerGebruikt = null)
    {
        // validation for constraint: int
        if (!is_null($relatienummerGebruikt) && !(is_int($relatienummerGebruikt) || ctype_digit($relatienummerGebruikt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatienummerGebruikt, true), gettype($relatienummerGebruikt)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatienummerGebruikt) && mb_strlen(preg_replace('/(\D)/', '', $relatienummerGebruikt)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatienummerGebruikt, true), mb_strlen(preg_replace('/(\D)/', '', $relatienummerGebruikt))), __LINE__);
        }
        if (is_null($relatienummerGebruikt) || (is_array($relatienummerGebruikt) && empty($relatienummerGebruikt))) {
            unset($this->relatienummerGebruikt);
        } else {
            $this->relatienummerGebruikt = $relatienummerGebruikt;
        }
        return $this;
    }
}
