<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updatePersoonNrContactRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Koppelt een bestaande prive persoon als contactpersoon aan een bestaand bedrijf.
 * @subpackage Structs
 * @date 20240419 package
 */
class UpdatePersoonNrContactRequest extends AbstractStructBase
{
    /**
     * The relatienummerBedrijf
     * Meta information extracted from the WSDL
     * - documentation: Het relatienummer van het bedrijf.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relatienummerBedrijf;
    /**
     * The relatienummerPersoon
     * Meta information extracted from the WSDL
     * - documentation: Het relatienummer van de prive persoon.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relatienummerPersoon;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The leegPersoonBezoekadres
     * Meta information extracted from the WSDL
     * - documentation: false (Default)= Laat het bezoekadres bij de persoon ongewijzigd<br/>true=Leeg het bezoekadres bij de prive persoon, zodat het bezoekadres bedrijf gebruikt wordt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $leegPersoonBezoekadres;
    /**
     * The leegPersoonCorradres
     * Meta information extracted from the WSDL
     * - documentation: false (Default)= Laat het correspondentie adres bij de persoon ongewijzigd<br/>true=Leeg het correspondentie adres bij de prive persoon, zodat het correspondentieadres bedrijf gebruikt wordt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $leegPersoonCorradres;
    /**
     * The leegPersoonPriveadres
     * Meta information extracted from the WSDL
     * - documentation: false (Default)= Laat het priveadres bij de persoon ongewijzigd<br/>true=Leeg het prive adres bij de prive persoon, zodat het prive adres bedrijf gebruikt wordt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $leegPersoonPriveadres;
    /**
     * Constructor method for updatePersoonNrContactRequest
     * @uses UpdatePersoonNrContactRequest::setRelatienummerBedrijf()
     * @uses UpdatePersoonNrContactRequest::setRelatienummerPersoon()
     * @uses UpdatePersoonNrContactRequest::setRequestTag()
     * @uses UpdatePersoonNrContactRequest::setLeegPersoonBezoekadres()
     * @uses UpdatePersoonNrContactRequest::setLeegPersoonCorradres()
     * @uses UpdatePersoonNrContactRequest::setLeegPersoonPriveadres()
     * @param int $relatienummerBedrijf
     * @param int $relatienummerPersoon
     * @param string $requestTag
     * @param bool $leegPersoonBezoekadres
     * @param bool $leegPersoonCorradres
     * @param bool $leegPersoonPriveadres
     */
    public function __construct($relatienummerBedrijf = null, $relatienummerPersoon = null, $requestTag = null, $leegPersoonBezoekadres = null, $leegPersoonCorradres = null, $leegPersoonPriveadres = null)
    {
        $this
            ->setRelatienummerBedrijf($relatienummerBedrijf)
            ->setRelatienummerPersoon($relatienummerPersoon)
            ->setRequestTag($requestTag)
            ->setLeegPersoonBezoekadres($leegPersoonBezoekadres)
            ->setLeegPersoonCorradres($leegPersoonCorradres)
            ->setLeegPersoonPriveadres($leegPersoonPriveadres);
    }
    /**
     * Get relatienummerBedrijf value
     * @return int
     */
    public function getRelatienummerBedrijf()
    {
        return $this->relatienummerBedrijf;
    }
    /**
     * Set relatienummerBedrijf value
     * @param int $relatienummerBedrijf
     * @return \RelatieApiV6\StructType\UpdatePersoonNrContactRequest
     */
    public function setRelatienummerBedrijf($relatienummerBedrijf = null)
    {
        // validation for constraint: int
        if (!is_null($relatienummerBedrijf) && !(is_int($relatienummerBedrijf) || ctype_digit($relatienummerBedrijf))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatienummerBedrijf, true), gettype($relatienummerBedrijf)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatienummerBedrijf) && mb_strlen(preg_replace('/(\D)/', '', $relatienummerBedrijf)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatienummerBedrijf, true), mb_strlen(preg_replace('/(\D)/', '', $relatienummerBedrijf))), __LINE__);
        }
        $this->relatienummerBedrijf = $relatienummerBedrijf;
        return $this;
    }
    /**
     * Get relatienummerPersoon value
     * @return int
     */
    public function getRelatienummerPersoon()
    {
        return $this->relatienummerPersoon;
    }
    /**
     * Set relatienummerPersoon value
     * @param int $relatienummerPersoon
     * @return \RelatieApiV6\StructType\UpdatePersoonNrContactRequest
     */
    public function setRelatienummerPersoon($relatienummerPersoon = null)
    {
        // validation for constraint: int
        if (!is_null($relatienummerPersoon) && !(is_int($relatienummerPersoon) || ctype_digit($relatienummerPersoon))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatienummerPersoon, true), gettype($relatienummerPersoon)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatienummerPersoon) && mb_strlen(preg_replace('/(\D)/', '', $relatienummerPersoon)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatienummerPersoon, true), mb_strlen(preg_replace('/(\D)/', '', $relatienummerPersoon))), __LINE__);
        }
        $this->relatienummerPersoon = $relatienummerPersoon;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV6\StructType\UpdatePersoonNrContactRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get leegPersoonBezoekadres value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getLeegPersoonBezoekadres()
    {
        return isset($this->leegPersoonBezoekadres) ? $this->leegPersoonBezoekadres : null;
    }
    /**
     * Set leegPersoonBezoekadres value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $leegPersoonBezoekadres
     * @return \RelatieApiV6\StructType\UpdatePersoonNrContactRequest
     */
    public function setLeegPersoonBezoekadres($leegPersoonBezoekadres = null)
    {
        // validation for constraint: boolean
        if (!is_null($leegPersoonBezoekadres) && !is_bool($leegPersoonBezoekadres)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($leegPersoonBezoekadres, true), gettype($leegPersoonBezoekadres)), __LINE__);
        }
        if (is_null($leegPersoonBezoekadres) || (is_array($leegPersoonBezoekadres) && empty($leegPersoonBezoekadres))) {
            unset($this->leegPersoonBezoekadres);
        } else {
            $this->leegPersoonBezoekadres = $leegPersoonBezoekadres;
        }
        return $this;
    }
    /**
     * Get leegPersoonCorradres value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getLeegPersoonCorradres()
    {
        return isset($this->leegPersoonCorradres) ? $this->leegPersoonCorradres : null;
    }
    /**
     * Set leegPersoonCorradres value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $leegPersoonCorradres
     * @return \RelatieApiV6\StructType\UpdatePersoonNrContactRequest
     */
    public function setLeegPersoonCorradres($leegPersoonCorradres = null)
    {
        // validation for constraint: boolean
        if (!is_null($leegPersoonCorradres) && !is_bool($leegPersoonCorradres)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($leegPersoonCorradres, true), gettype($leegPersoonCorradres)), __LINE__);
        }
        if (is_null($leegPersoonCorradres) || (is_array($leegPersoonCorradres) && empty($leegPersoonCorradres))) {
            unset($this->leegPersoonCorradres);
        } else {
            $this->leegPersoonCorradres = $leegPersoonCorradres;
        }
        return $this;
    }
    /**
     * Get leegPersoonPriveadres value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getLeegPersoonPriveadres()
    {
        return isset($this->leegPersoonPriveadres) ? $this->leegPersoonPriveadres : null;
    }
    /**
     * Set leegPersoonPriveadres value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $leegPersoonPriveadres
     * @return \RelatieApiV6\StructType\UpdatePersoonNrContactRequest
     */
    public function setLeegPersoonPriveadres($leegPersoonPriveadres = null)
    {
        // validation for constraint: boolean
        if (!is_null($leegPersoonPriveadres) && !is_bool($leegPersoonPriveadres)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($leegPersoonPriveadres, true), gettype($leegPersoonPriveadres)), __LINE__);
        }
        if (is_null($leegPersoonPriveadres) || (is_array($leegPersoonPriveadres) && empty($leegPersoonPriveadres))) {
            unset($this->leegPersoonPriveadres);
        } else {
            $this->leegPersoonPriveadres = $leegPersoonPriveadres;
        }
        return $this;
    }
}
