<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelatiegroepRec StructType
 * Meta information extracted from the WSDL
 * - documentation: Relatiegroep gegevens van de relatie
 * @subpackage Structs
 * @date 20240419 package
 */
class RelatiegroepRec extends AbstractStructBase
{
    /**
     * The groepCode
     * Meta information extracted from the WSDL
     * - documentation: De code van de relatiegroep
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $groepCode;
    /**
     * The groepNaam
     * Meta information extracted from the WSDL
     * - documentation: De naam van de relatiegroep
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $groepNaam;
    /**
     * The hoofdGroepCode
     * Meta information extracted from the WSDL
     * - documentation: De code van de hoofdgroep
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $hoofdGroepCode;
    /**
     * The hoofdGroepNaam
     * Meta information extracted from the WSDL
     * - documentation: De naam van de hoofdgroep
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $hoofdGroepNaam;
    /**
     * Constructor method for RelatiegroepRec
     * @uses RelatiegroepRec::setGroepCode()
     * @uses RelatiegroepRec::setGroepNaam()
     * @uses RelatiegroepRec::setHoofdGroepCode()
     * @uses RelatiegroepRec::setHoofdGroepNaam()
     * @param string $groepCode
     * @param string $groepNaam
     * @param string $hoofdGroepCode
     * @param string $hoofdGroepNaam
     */
    public function __construct($groepCode = null, $groepNaam = null, $hoofdGroepCode = null, $hoofdGroepNaam = null)
    {
        $this
            ->setGroepCode($groepCode)
            ->setGroepNaam($groepNaam)
            ->setHoofdGroepCode($hoofdGroepCode)
            ->setHoofdGroepNaam($hoofdGroepNaam);
    }
    /**
     * Get groepCode value
     * @return string
     */
    public function getGroepCode()
    {
        return $this->groepCode;
    }
    /**
     * Set groepCode value
     * @param string $groepCode
     * @return \RelatieApiV6\StructType\RelatiegroepRec
     */
    public function setGroepCode($groepCode = null)
    {
        // validation for constraint: string
        if (!is_null($groepCode) && !is_string($groepCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groepCode, true), gettype($groepCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($groepCode) && mb_strlen($groepCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($groepCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($groepCode) && mb_strlen($groepCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($groepCode)), __LINE__);
        }
        $this->groepCode = $groepCode;
        return $this;
    }
    /**
     * Get groepNaam value
     * @return string
     */
    public function getGroepNaam()
    {
        return $this->groepNaam;
    }
    /**
     * Set groepNaam value
     * @param string $groepNaam
     * @return \RelatieApiV6\StructType\RelatiegroepRec
     */
    public function setGroepNaam($groepNaam = null)
    {
        // validation for constraint: string
        if (!is_null($groepNaam) && !is_string($groepNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groepNaam, true), gettype($groepNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($groepNaam) && mb_strlen($groepNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($groepNaam)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($groepNaam) && mb_strlen($groepNaam) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($groepNaam)), __LINE__);
        }
        $this->groepNaam = $groepNaam;
        return $this;
    }
    /**
     * Get hoofdGroepCode value
     * @return string
     */
    public function getHoofdGroepCode()
    {
        return $this->hoofdGroepCode;
    }
    /**
     * Set hoofdGroepCode value
     * @param string $hoofdGroepCode
     * @return \RelatieApiV6\StructType\RelatiegroepRec
     */
    public function setHoofdGroepCode($hoofdGroepCode = null)
    {
        // validation for constraint: string
        if (!is_null($hoofdGroepCode) && !is_string($hoofdGroepCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hoofdGroepCode, true), gettype($hoofdGroepCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($hoofdGroepCode) && mb_strlen($hoofdGroepCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($hoofdGroepCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($hoofdGroepCode) && mb_strlen($hoofdGroepCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($hoofdGroepCode)), __LINE__);
        }
        $this->hoofdGroepCode = $hoofdGroepCode;
        return $this;
    }
    /**
     * Get hoofdGroepNaam value
     * @return string
     */
    public function getHoofdGroepNaam()
    {
        return $this->hoofdGroepNaam;
    }
    /**
     * Set hoofdGroepNaam value
     * @param string $hoofdGroepNaam
     * @return \RelatieApiV6\StructType\RelatiegroepRec
     */
    public function setHoofdGroepNaam($hoofdGroepNaam = null)
    {
        // validation for constraint: string
        if (!is_null($hoofdGroepNaam) && !is_string($hoofdGroepNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hoofdGroepNaam, true), gettype($hoofdGroepNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($hoofdGroepNaam) && mb_strlen($hoofdGroepNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($hoofdGroepNaam)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($hoofdGroepNaam) && mb_strlen($hoofdGroepNaam) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($hoofdGroepNaam)), __LINE__);
        }
        $this->hoofdGroepNaam = $hoofdGroepNaam;
        return $this;
    }
}
