<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelatieKortinggroepRec StructType
 * Meta information extracted from the WSDL
 * - documentation: Relatie kortinggroep
 * @subpackage Structs
 * @date 20240419 package
 */
class RelatieKortinggroepRec extends AbstractStructBase
{
    /**
     * The kortinggroepCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de relatie kortinggroep
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $kortinggroepCode;
    /**
     * The kortinggroepOmschrijving
     * Meta information extracted from the WSDL
     * - documentation: Omschrijving van de relatie kortinggroep
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $kortinggroepOmschrijving;
    /**
     * Constructor method for RelatieKortinggroepRec
     * @uses RelatieKortinggroepRec::setKortinggroepCode()
     * @uses RelatieKortinggroepRec::setKortinggroepOmschrijving()
     * @param string $kortinggroepCode
     * @param string $kortinggroepOmschrijving
     */
    public function __construct($kortinggroepCode = null, $kortinggroepOmschrijving = null)
    {
        $this
            ->setKortinggroepCode($kortinggroepCode)
            ->setKortinggroepOmschrijving($kortinggroepOmschrijving);
    }
    /**
     * Get kortinggroepCode value
     * @return string
     */
    public function getKortinggroepCode()
    {
        return $this->kortinggroepCode;
    }
    /**
     * Set kortinggroepCode value
     * @param string $kortinggroepCode
     * @return \RelatieApiV6\StructType\RelatieKortinggroepRec
     */
    public function setKortinggroepCode($kortinggroepCode = null)
    {
        // validation for constraint: string
        if (!is_null($kortinggroepCode) && !is_string($kortinggroepCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kortinggroepCode, true), gettype($kortinggroepCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($kortinggroepCode) && mb_strlen($kortinggroepCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($kortinggroepCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($kortinggroepCode) && mb_strlen($kortinggroepCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($kortinggroepCode)), __LINE__);
        }
        $this->kortinggroepCode = $kortinggroepCode;
        return $this;
    }
    /**
     * Get kortinggroepOmschrijving value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKortinggroepOmschrijving()
    {
        return isset($this->kortinggroepOmschrijving) ? $this->kortinggroepOmschrijving : null;
    }
    /**
     * Set kortinggroepOmschrijving value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kortinggroepOmschrijving
     * @return \RelatieApiV6\StructType\RelatieKortinggroepRec
     */
    public function setKortinggroepOmschrijving($kortinggroepOmschrijving = null)
    {
        // validation for constraint: string
        if (!is_null($kortinggroepOmschrijving) && !is_string($kortinggroepOmschrijving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kortinggroepOmschrijving, true), gettype($kortinggroepOmschrijving)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($kortinggroepOmschrijving) && mb_strlen($kortinggroepOmschrijving) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($kortinggroepOmschrijving)), __LINE__);
        }
        if (is_null($kortinggroepOmschrijving) || (is_array($kortinggroepOmschrijving) && empty($kortinggroepOmschrijving))) {
            unset($this->kortinggroepOmschrijving);
        } else {
            $this->kortinggroepOmschrijving = $kortinggroepOmschrijving;
        }
        return $this;
    }
}
