<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrivacyHoofdCatInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met gevonden privacy hoofd categorieen.
 * @subpackage Structs
 * @date 20240419 package
 */
class PrivacyHoofdCatInfo extends AbstractStructBase
{
    /**
     * The privacyHoofdCat
     * Meta information extracted from the WSDL
     * - documentation: Lijst met gevonden privacy hoofd categorieen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \RelatieApiV6\StructType\PrivacyHoofdCat[]
     */
    public $privacyHoofdCat;
    /**
     * Constructor method for PrivacyHoofdCatInfo
     * @uses PrivacyHoofdCatInfo::setPrivacyHoofdCat()
     * @param \RelatieApiV6\StructType\PrivacyHoofdCat[] $privacyHoofdCat
     */
    public function __construct(array $privacyHoofdCat = array())
    {
        $this
            ->setPrivacyHoofdCat($privacyHoofdCat);
    }
    /**
     * Get privacyHoofdCat value
     * @return \RelatieApiV6\StructType\PrivacyHoofdCat[]|null
     */
    public function getPrivacyHoofdCat()
    {
        return $this->privacyHoofdCat;
    }
    /**
     * This method is responsible for validating the values passed to the setPrivacyHoofdCat method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrivacyHoofdCat method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePrivacyHoofdCatForArrayConstraintsFromSetPrivacyHoofdCat(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $privacyHoofdCatInfoPrivacyHoofdCatItem) {
            // validation for constraint: itemType
            if (!$privacyHoofdCatInfoPrivacyHoofdCatItem instanceof \RelatieApiV6\StructType\PrivacyHoofdCat) {
                $invalidValues[] = is_object($privacyHoofdCatInfoPrivacyHoofdCatItem) ? get_class($privacyHoofdCatInfoPrivacyHoofdCatItem) : sprintf('%s(%s)', gettype($privacyHoofdCatInfoPrivacyHoofdCatItem), var_export($privacyHoofdCatInfoPrivacyHoofdCatItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The privacyHoofdCat property can only contain items of type \RelatieApiV6\StructType\PrivacyHoofdCat, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set privacyHoofdCat value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV6\StructType\PrivacyHoofdCat[] $privacyHoofdCat
     * @return \RelatieApiV6\StructType\PrivacyHoofdCatInfo
     */
    public function setPrivacyHoofdCat(array $privacyHoofdCat = array())
    {
        // validation for constraint: array
        if ('' !== ($privacyHoofdCatArrayErrorMessage = self::validatePrivacyHoofdCatForArrayConstraintsFromSetPrivacyHoofdCat($privacyHoofdCat))) {
            throw new \InvalidArgumentException($privacyHoofdCatArrayErrorMessage, __LINE__);
        }
        $this->privacyHoofdCat = $privacyHoofdCat;
        return $this;
    }
    /**
     * Add item to privacyHoofdCat value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV6\StructType\PrivacyHoofdCat $item
     * @return \RelatieApiV6\StructType\PrivacyHoofdCatInfo
     */
    public function addToPrivacyHoofdCat(\RelatieApiV6\StructType\PrivacyHoofdCat $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \RelatieApiV6\StructType\PrivacyHoofdCat) {
            throw new \InvalidArgumentException(sprintf('The privacyHoofdCat property can only contain items of type \RelatieApiV6\StructType\PrivacyHoofdCat, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->privacyHoofdCat[] = $item;
        return $this;
    }
}
