<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getPersonenRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Ophalen van een lijst met gegevens van een persoon
 * @subpackage Structs
 * @date 20240419 package
 */
class GetPersonenRequest extends AbstractStructBase
{
    /**
     * The relatienummers
     * Meta information extracted from the WSDL
     * - documentation: Een lijst met relatienummers van de relaties waarvan de gegevens opgehaald worden
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \RelatieApiV6\StructType\Relatienrtable
     */
    public $relatienummers;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The includeFuncties
     * Meta information extracted from the WSDL
     * - documentation: De functies gekoppeld aan de persoon retourneren
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $includeFuncties;
    /**
     * The includeBiccodes
     * Meta information extracted from the WSDL
     * - documentation: Indicatie true= Gekoppelde biccodes retourneren, false= Geen gekoppelde biccodes retourneren
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $includeBiccodes;
    /**
     * Constructor method for getPersonenRequest
     * @uses GetPersonenRequest::setRelatienummers()
     * @uses GetPersonenRequest::setRequestTag()
     * @uses GetPersonenRequest::setIncludeFuncties()
     * @uses GetPersonenRequest::setIncludeBiccodes()
     * @param \RelatieApiV6\StructType\Relatienrtable $relatienummers
     * @param string $requestTag
     * @param bool $includeFuncties
     * @param bool $includeBiccodes
     */
    public function __construct(\RelatieApiV6\StructType\Relatienrtable $relatienummers = null, $requestTag = null, $includeFuncties = null, $includeBiccodes = null)
    {
        $this
            ->setRelatienummers($relatienummers)
            ->setRequestTag($requestTag)
            ->setIncludeFuncties($includeFuncties)
            ->setIncludeBiccodes($includeBiccodes);
    }
    /**
     * Get relatienummers value
     * @return \RelatieApiV6\StructType\Relatienrtable
     */
    public function getRelatienummers()
    {
        return $this->relatienummers;
    }
    /**
     * Set relatienummers value
     * @param \RelatieApiV6\StructType\Relatienrtable $relatienummers
     * @return \RelatieApiV6\StructType\GetPersonenRequest
     */
    public function setRelatienummers(\RelatieApiV6\StructType\Relatienrtable $relatienummers = null)
    {
        $this->relatienummers = $relatienummers;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV6\StructType\GetPersonenRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get includeFuncties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeFuncties()
    {
        return isset($this->includeFuncties) ? $this->includeFuncties : null;
    }
    /**
     * Set includeFuncties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeFuncties
     * @return \RelatieApiV6\StructType\GetPersonenRequest
     */
    public function setIncludeFuncties($includeFuncties = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeFuncties) && !is_bool($includeFuncties)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeFuncties, true), gettype($includeFuncties)), __LINE__);
        }
        if (is_null($includeFuncties) || (is_array($includeFuncties) && empty($includeFuncties))) {
            unset($this->includeFuncties);
        } else {
            $this->includeFuncties = $includeFuncties;
        }
        return $this;
    }
    /**
     * Get includeBiccodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeBiccodes()
    {
        return isset($this->includeBiccodes) ? $this->includeBiccodes : null;
    }
    /**
     * Set includeBiccodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeBiccodes
     * @return \RelatieApiV6\StructType\GetPersonenRequest
     */
    public function setIncludeBiccodes($includeBiccodes = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeBiccodes) && !is_bool($includeBiccodes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeBiccodes, true), gettype($includeBiccodes)), __LINE__);
        }
        if (is_null($includeBiccodes) || (is_array($includeBiccodes) && empty($includeBiccodes))) {
            unset($this->includeBiccodes);
        } else {
            $this->includeBiccodes = $includeBiccodes;
        }
        return $this;
    }
}
