<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getBedrijfInclContResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: error109: De relatie met het opgegeven relatienummer is niet van het type 'Bedrijf inclusief contactpersoon' | error106: Zeno is niet ingesteld om te werken met relatiekaarten met gecombineerde bedrijf en persoons gegevens | error16:
 * Op basis van het relatienummer is geen relatie gevonden | error15: Er is geen relatienummer opgegeven
 * @subpackage Structs
 * @date 20240419 package
 */
class GetBedrijfInclContResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The bedrijfInclCont
     * Meta information extracted from the WSDL
     * - documentation: De gegevens van de relatie
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\BedrijfInclContinfoRec
     */
    public $bedrijfInclCont;
    /**
     * Constructor method for getBedrijfInclContResponse
     * @uses GetBedrijfInclContResponse::setRequestTag()
     * @uses GetBedrijfInclContResponse::setBedrijfInclCont()
     * @param string $requestTag
     * @param \RelatieApiV6\StructType\BedrijfInclContinfoRec $bedrijfInclCont
     */
    public function __construct($requestTag = null, \RelatieApiV6\StructType\BedrijfInclContinfoRec $bedrijfInclCont = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setBedrijfInclCont($bedrijfInclCont);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV6\StructType\GetBedrijfInclContResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get bedrijfInclCont value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\BedrijfInclContinfoRec|null
     */
    public function getBedrijfInclCont()
    {
        return isset($this->bedrijfInclCont) ? $this->bedrijfInclCont : null;
    }
    /**
     * Set bedrijfInclCont value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\BedrijfInclContinfoRec $bedrijfInclCont
     * @return \RelatieApiV6\StructType\GetBedrijfInclContResponse
     */
    public function setBedrijfInclCont(\RelatieApiV6\StructType\BedrijfInclContinfoRec $bedrijfInclCont = null)
    {
        if (is_null($bedrijfInclCont) || (is_array($bedrijfInclCont) && empty($bedrijfInclCont))) {
            unset($this->bedrijfInclCont);
        } else {
            $this->bedrijfInclCont = $bedrijfInclCont;
        }
        return $this;
    }
}
