<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getAdresResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: error60: Het opgegeven adrestype is onbekend | error16: Op basis van het relatienummer is geen relatie gevonden
 * @subpackage Structs
 * @date 20240419 package
 */
class GetAdresResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The adres
     * Meta information extracted from the WSDL
     * - documentation: Het adres
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\AdresRec
     */
    public $adres;
    /**
     * The landCode
     * Meta information extracted from the WSDL
     * - documentation: Landcode voor het adres
     * - base: xsd:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $landCode;
    /**
     * The bedrijf
     * Meta information extracted from the WSDL
     * - documentation: De gegevens van het bijbehorende bedrijf voor wanneer de opgegeven relatie een contactpersoon of afdeling van een bedrijf is
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\BedrijfinfoRec
     */
    public $bedrijf;
    /**
     * The afdeling
     * Meta information extracted from the WSDL
     * - documentation: De afdelingsnaam
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $afdeling;
    /**
     * Constructor method for getAdresResponse
     * @uses GetAdresResponse::setRequestTag()
     * @uses GetAdresResponse::setAdres()
     * @uses GetAdresResponse::setLandCode()
     * @uses GetAdresResponse::setBedrijf()
     * @uses GetAdresResponse::setAfdeling()
     * @param string $requestTag
     * @param \RelatieApiV6\StructType\AdresRec $adres
     * @param string $landCode
     * @param \RelatieApiV6\StructType\BedrijfinfoRec $bedrijf
     * @param string $afdeling
     */
    public function __construct($requestTag = null, \RelatieApiV6\StructType\AdresRec $adres = null, $landCode = null, \RelatieApiV6\StructType\BedrijfinfoRec $bedrijf = null, $afdeling = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setAdres($adres)
            ->setLandCode($landCode)
            ->setBedrijf($bedrijf)
            ->setAfdeling($afdeling);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV6\StructType\GetAdresResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get adres value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\AdresRec|null
     */
    public function getAdres()
    {
        return isset($this->adres) ? $this->adres : null;
    }
    /**
     * Set adres value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\AdresRec $adres
     * @return \RelatieApiV6\StructType\GetAdresResponse
     */
    public function setAdres(\RelatieApiV6\StructType\AdresRec $adres = null)
    {
        if (is_null($adres) || (is_array($adres) && empty($adres))) {
            unset($this->adres);
        } else {
            $this->adres = $adres;
        }
        return $this;
    }
    /**
     * Get landCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLandCode()
    {
        return isset($this->landCode) ? $this->landCode : null;
    }
    /**
     * Set landCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $landCode
     * @return \RelatieApiV6\StructType\GetAdresResponse
     */
    public function setLandCode($landCode = null)
    {
        // validation for constraint: string
        if (!is_null($landCode) && !is_string($landCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($landCode, true), gettype($landCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($landCode) && mb_strlen($landCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($landCode)), __LINE__);
        }
        if (is_null($landCode) || (is_array($landCode) && empty($landCode))) {
            unset($this->landCode);
        } else {
            $this->landCode = $landCode;
        }
        return $this;
    }
    /**
     * Get bedrijf value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\BedrijfinfoRec|null
     */
    public function getBedrijf()
    {
        return isset($this->bedrijf) ? $this->bedrijf : null;
    }
    /**
     * Set bedrijf value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\BedrijfinfoRec $bedrijf
     * @return \RelatieApiV6\StructType\GetAdresResponse
     */
    public function setBedrijf(\RelatieApiV6\StructType\BedrijfinfoRec $bedrijf = null)
    {
        if (is_null($bedrijf) || (is_array($bedrijf) && empty($bedrijf))) {
            unset($this->bedrijf);
        } else {
            $this->bedrijf = $bedrijf;
        }
        return $this;
    }
    /**
     * Get afdeling value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAfdeling()
    {
        return isset($this->afdeling) ? $this->afdeling : null;
    }
    /**
     * Set afdeling value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $afdeling
     * @return \RelatieApiV6\StructType\GetAdresResponse
     */
    public function setAfdeling($afdeling = null)
    {
        // validation for constraint: string
        if (!is_null($afdeling) && !is_string($afdeling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($afdeling, true), gettype($afdeling)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($afdeling) && mb_strlen($afdeling) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($afdeling)), __LINE__);
        }
        if (is_null($afdeling) || (is_array($afdeling) && empty($afdeling))) {
            unset($this->afdeling);
        } else {
            $this->afdeling = $afdeling;
        }
        return $this;
    }
}
