<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getAdresRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Ophalen van het adres voor een relatie. Hierbij wordt gebruik gemaakt van de 'etiket' functionaliteit van Zeno. In geval de relatie een contactpersoon of afdeling van een bedrijf is, en er bij de contactpersoon of afdeling geen adres
 * opgegeven is, wordt het adres van het bedrijf afgehaald. <br/><br/> Ook zal bijvoorbeeld bij opvragen van het correspondentieadres het bezoekadres geretourneerd worden indien alleen een bezoekadres opgegeven is.<br/><br/> N.B. Aangezien het adres
 * mogelijk vanaf een andere relatie (het bedrijf) opgehaald kan worden dan het opgegeven relatienummer dient het geretourneerde adres in geen geval gebruikt te worden voor het bijwerken van de relatie behorende bij het opgegeven relatienummer.
 * @subpackage Structs
 * @date 20240419 package
 */
class GetAdresRequest extends AbstractStructBase
{
    /**
     * The relatienummer
     * Meta information extracted from the WSDL
     * - documentation: Relatienummer van de relatie voor wie het adres opgevraagd wordt.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relatienummer;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The adresType
     * Meta information extracted from the WSDL
     * - documentation: Adrestype. Toegestane waarden zijn C(orrespondentie), B(ezoek) of P(rive). (default 'C').
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $adresType;
    /**
     * Constructor method for getAdresRequest
     * @uses GetAdresRequest::setRelatienummer()
     * @uses GetAdresRequest::setRequestTag()
     * @uses GetAdresRequest::setAdresType()
     * @param int $relatienummer
     * @param string $requestTag
     * @param string $adresType
     */
    public function __construct($relatienummer = null, $requestTag = null, $adresType = null)
    {
        $this
            ->setRelatienummer($relatienummer)
            ->setRequestTag($requestTag)
            ->setAdresType($adresType);
    }
    /**
     * Get relatienummer value
     * @return int
     */
    public function getRelatienummer()
    {
        return $this->relatienummer;
    }
    /**
     * Set relatienummer value
     * @param int $relatienummer
     * @return \RelatieApiV6\StructType\GetAdresRequest
     */
    public function setRelatienummer($relatienummer = null)
    {
        // validation for constraint: int
        if (!is_null($relatienummer) && !(is_int($relatienummer) || ctype_digit($relatienummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatienummer, true), gettype($relatienummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatienummer) && mb_strlen(preg_replace('/(\D)/', '', $relatienummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatienummer, true), mb_strlen(preg_replace('/(\D)/', '', $relatienummer))), __LINE__);
        }
        $this->relatienummer = $relatienummer;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV6\StructType\GetAdresRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get adresType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdresType()
    {
        return isset($this->adresType) ? $this->adresType : null;
    }
    /**
     * Set adresType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adresType
     * @return \RelatieApiV6\StructType\GetAdresRequest
     */
    public function setAdresType($adresType = null)
    {
        // validation for constraint: string
        if (!is_null($adresType) && !is_string($adresType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adresType, true), gettype($adresType)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($adresType) && mb_strlen($adresType) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($adresType)), __LINE__);
        }
        if (is_null($adresType) || (is_array($adresType) && empty($adresType))) {
            unset($this->adresType);
        } else {
            $this->adresType = $adresType;
        }
        return $this;
    }
}
