<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactpersoonRec StructType
 * Meta information extracted from the WSDL
 * - documentation: Contactpersoongegevens
 * @subpackage Structs
 * @date 20240419 package
 */
class ContactpersoonRec extends AbstractStructBase
{
    /**
     * The persoon
     * Meta information extracted from the WSDL
     * - documentation: De gegevens van de contactpersoon
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\PersoonRec
     */
    public $persoon;
    /**
     * The afdeling
     * Meta information extracted from the WSDL
     * - documentation: De afdeling binnen het bedrijf waar de contactpersoon werkzaam is
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $afdeling;
    /**
     * Constructor method for ContactpersoonRec
     * @uses ContactpersoonRec::setPersoon()
     * @uses ContactpersoonRec::setAfdeling()
     * @param \RelatieApiV6\StructType\PersoonRec $persoon
     * @param string $afdeling
     */
    public function __construct(\RelatieApiV6\StructType\PersoonRec $persoon = null, $afdeling = null)
    {
        $this
            ->setPersoon($persoon)
            ->setAfdeling($afdeling);
    }
    /**
     * Get persoon value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\PersoonRec|null
     */
    public function getPersoon()
    {
        return isset($this->persoon) ? $this->persoon : null;
    }
    /**
     * Set persoon value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\PersoonRec $persoon
     * @return \RelatieApiV6\StructType\ContactpersoonRec
     */
    public function setPersoon(\RelatieApiV6\StructType\PersoonRec $persoon = null)
    {
        if (is_null($persoon) || (is_array($persoon) && empty($persoon))) {
            unset($this->persoon);
        } else {
            $this->persoon = $persoon;
        }
        return $this;
    }
    /**
     * Get afdeling value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAfdeling()
    {
        return isset($this->afdeling) ? $this->afdeling : null;
    }
    /**
     * Set afdeling value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $afdeling
     * @return \RelatieApiV6\StructType\ContactpersoonRec
     */
    public function setAfdeling($afdeling = null)
    {
        // validation for constraint: string
        if (!is_null($afdeling) && !is_string($afdeling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($afdeling, true), gettype($afdeling)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($afdeling) && mb_strlen($afdeling) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($afdeling)), __LINE__);
        }
        if (is_null($afdeling) || (is_array($afdeling) && empty($afdeling))) {
            unset($this->afdeling);
        } else {
            $this->afdeling = $afdeling;
        }
        return $this;
    }
}
