<?php

namespace RelatieApiV6\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 * @date 20240419 package
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named setOptInOut
     * Meta information extracted from the WSDL
     * - documentation: Bij een bestaande relatie de indicatie 'uitsluiten voor mailing' of 'recht van beperking' aan- of uitzetten.error275: De waarde QUESTIONNAIRES (Uitsluiten voor enquetes) is niet toegestaan.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\SetOptInOutRequest $request_parameters
     * @return \RelatieApiV6\StructType\SetOptInOutResponse|bool
     */
    public function setOptInOut(\RelatieApiV6\StructType\SetOptInOutRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setOptInOut($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \RelatieApiV6\StructType\SetOptInOutResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
