<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Taalcodetable StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met beschikbare taalcodes
 * @subpackage Structs
 * @date 20240419 package
 */
class Taalcodetable extends AbstractStructBase
{
    /**
     * The taalcode
     * Meta information extracted from the WSDL
     * - documentation: Taalcodes
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \RelatieApiV6\StructType\TaalcodeRec[]
     */
    public $taalcode;
    /**
     * Constructor method for Taalcodetable
     * @uses Taalcodetable::setTaalcode()
     * @param \RelatieApiV6\StructType\TaalcodeRec[] $taalcode
     */
    public function __construct(array $taalcode = array())
    {
        $this
            ->setTaalcode($taalcode);
    }
    /**
     * Get taalcode value
     * @return \RelatieApiV6\StructType\TaalcodeRec[]|null
     */
    public function getTaalcode()
    {
        return $this->taalcode;
    }
    /**
     * This method is responsible for validating the values passed to the setTaalcode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaalcode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaalcodeForArrayConstraintsFromSetTaalcode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taalcodetableTaalcodeItem) {
            // validation for constraint: itemType
            if (!$taalcodetableTaalcodeItem instanceof \RelatieApiV6\StructType\TaalcodeRec) {
                $invalidValues[] = is_object($taalcodetableTaalcodeItem) ? get_class($taalcodetableTaalcodeItem) : sprintf('%s(%s)', gettype($taalcodetableTaalcodeItem), var_export($taalcodetableTaalcodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The taalcode property can only contain items of type \RelatieApiV6\StructType\TaalcodeRec, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set taalcode value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV6\StructType\TaalcodeRec[] $taalcode
     * @return \RelatieApiV6\StructType\Taalcodetable
     */
    public function setTaalcode(array $taalcode = array())
    {
        // validation for constraint: array
        if ('' !== ($taalcodeArrayErrorMessage = self::validateTaalcodeForArrayConstraintsFromSetTaalcode($taalcode))) {
            throw new \InvalidArgumentException($taalcodeArrayErrorMessage, __LINE__);
        }
        $this->taalcode = $taalcode;
        return $this;
    }
    /**
     * Add item to taalcode value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV6\StructType\TaalcodeRec $item
     * @return \RelatieApiV6\StructType\Taalcodetable
     */
    public function addToTaalcode(\RelatieApiV6\StructType\TaalcodeRec $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \RelatieApiV6\StructType\TaalcodeRec) {
            throw new \InvalidArgumentException(sprintf('The taalcode property can only contain items of type \RelatieApiV6\StructType\TaalcodeRec, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->taalcode[] = $item;
        return $this;
    }
}
