<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelatiePrivacyCatInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met gevonden relatie privacy categorieen.
 * @subpackage Structs
 * @date 20240419 package
 */
class RelatiePrivacyCatInfo extends AbstractStructBase
{
    /**
     * The relatiePrivacyCat
     * Meta information extracted from the WSDL
     * - documentation: Lijst met gevonden relatie privacy categorieen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \RelatieApiV6\StructType\RelatiePrivacyCat[]
     */
    public $relatiePrivacyCat;
    /**
     * Constructor method for RelatiePrivacyCatInfo
     * @uses RelatiePrivacyCatInfo::setRelatiePrivacyCat()
     * @param \RelatieApiV6\StructType\RelatiePrivacyCat[] $relatiePrivacyCat
     */
    public function __construct(array $relatiePrivacyCat = array())
    {
        $this
            ->setRelatiePrivacyCat($relatiePrivacyCat);
    }
    /**
     * Get relatiePrivacyCat value
     * @return \RelatieApiV6\StructType\RelatiePrivacyCat[]|null
     */
    public function getRelatiePrivacyCat()
    {
        return $this->relatiePrivacyCat;
    }
    /**
     * This method is responsible for validating the values passed to the setRelatiePrivacyCat method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelatiePrivacyCat method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelatiePrivacyCatForArrayConstraintsFromSetRelatiePrivacyCat(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $relatiePrivacyCatInfoRelatiePrivacyCatItem) {
            // validation for constraint: itemType
            if (!$relatiePrivacyCatInfoRelatiePrivacyCatItem instanceof \RelatieApiV6\StructType\RelatiePrivacyCat) {
                $invalidValues[] = is_object($relatiePrivacyCatInfoRelatiePrivacyCatItem) ? get_class($relatiePrivacyCatInfoRelatiePrivacyCatItem) : sprintf('%s(%s)', gettype($relatiePrivacyCatInfoRelatiePrivacyCatItem), var_export($relatiePrivacyCatInfoRelatiePrivacyCatItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The relatiePrivacyCat property can only contain items of type \RelatieApiV6\StructType\RelatiePrivacyCat, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set relatiePrivacyCat value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV6\StructType\RelatiePrivacyCat[] $relatiePrivacyCat
     * @return \RelatieApiV6\StructType\RelatiePrivacyCatInfo
     */
    public function setRelatiePrivacyCat(array $relatiePrivacyCat = array())
    {
        // validation for constraint: array
        if ('' !== ($relatiePrivacyCatArrayErrorMessage = self::validateRelatiePrivacyCatForArrayConstraintsFromSetRelatiePrivacyCat($relatiePrivacyCat))) {
            throw new \InvalidArgumentException($relatiePrivacyCatArrayErrorMessage, __LINE__);
        }
        $this->relatiePrivacyCat = $relatiePrivacyCat;
        return $this;
    }
    /**
     * Add item to relatiePrivacyCat value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV6\StructType\RelatiePrivacyCat $item
     * @return \RelatieApiV6\StructType\RelatiePrivacyCatInfo
     */
    public function addToRelatiePrivacyCat(\RelatieApiV6\StructType\RelatiePrivacyCat $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \RelatieApiV6\StructType\RelatiePrivacyCat) {
            throw new \InvalidArgumentException(sprintf('The relatiePrivacyCat property can only contain items of type \RelatieApiV6\StructType\RelatiePrivacyCat, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->relatiePrivacyCat[] = $item;
        return $this;
    }
}
