<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrivacySubCatInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met gevonden privacy sub categorieen.
 * @subpackage Structs
 * @date 20240419 package
 */
class PrivacySubCatInfo extends AbstractStructBase
{
    /**
     * The privacySubCat
     * Meta information extracted from the WSDL
     * - documentation: Lijst met gevonden privacy sub categorieen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \RelatieApiV6\StructType\PrivacySubCat[]
     */
    public $privacySubCat;
    /**
     * Constructor method for PrivacySubCatInfo
     * @uses PrivacySubCatInfo::setPrivacySubCat()
     * @param \RelatieApiV6\StructType\PrivacySubCat[] $privacySubCat
     */
    public function __construct(array $privacySubCat = array())
    {
        $this
            ->setPrivacySubCat($privacySubCat);
    }
    /**
     * Get privacySubCat value
     * @return \RelatieApiV6\StructType\PrivacySubCat[]|null
     */
    public function getPrivacySubCat()
    {
        return $this->privacySubCat;
    }
    /**
     * This method is responsible for validating the values passed to the setPrivacySubCat method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrivacySubCat method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePrivacySubCatForArrayConstraintsFromSetPrivacySubCat(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $privacySubCatInfoPrivacySubCatItem) {
            // validation for constraint: itemType
            if (!$privacySubCatInfoPrivacySubCatItem instanceof \RelatieApiV6\StructType\PrivacySubCat) {
                $invalidValues[] = is_object($privacySubCatInfoPrivacySubCatItem) ? get_class($privacySubCatInfoPrivacySubCatItem) : sprintf('%s(%s)', gettype($privacySubCatInfoPrivacySubCatItem), var_export($privacySubCatInfoPrivacySubCatItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The privacySubCat property can only contain items of type \RelatieApiV6\StructType\PrivacySubCat, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set privacySubCat value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV6\StructType\PrivacySubCat[] $privacySubCat
     * @return \RelatieApiV6\StructType\PrivacySubCatInfo
     */
    public function setPrivacySubCat(array $privacySubCat = array())
    {
        // validation for constraint: array
        if ('' !== ($privacySubCatArrayErrorMessage = self::validatePrivacySubCatForArrayConstraintsFromSetPrivacySubCat($privacySubCat))) {
            throw new \InvalidArgumentException($privacySubCatArrayErrorMessage, __LINE__);
        }
        $this->privacySubCat = $privacySubCat;
        return $this;
    }
    /**
     * Add item to privacySubCat value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV6\StructType\PrivacySubCat $item
     * @return \RelatieApiV6\StructType\PrivacySubCatInfo
     */
    public function addToPrivacySubCat(\RelatieApiV6\StructType\PrivacySubCat $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \RelatieApiV6\StructType\PrivacySubCat) {
            throw new \InvalidArgumentException(sprintf('The privacySubCat property can only contain items of type \RelatieApiV6\StructType\PrivacySubCat, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->privacySubCat[] = $item;
        return $this;
    }
}
