<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrivacySubCat StructType
 * Meta information extracted from the WSDL
 * - documentation: Privacy sub categorie object.
 * @subpackage Structs
 * @date 20240419 package
 */
class PrivacySubCat extends AbstractStructBase
{
    /**
     * The privacySubCatCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de privacy sub categorie.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $privacySubCatCode;
    /**
     * The privacySubCatDefault
     * Meta information extracted from the WSDL
     * - documentation: Default status (0=Onbekend, 1=Niet benaderen, 2=Benaderen).
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 1
     * @var int
     */
    public $privacySubCatDefault;
    /**
     * The privacySubCatNaam
     * Meta information extracted from the WSDL
     * - documentation: Naam van de privacy sub categorie.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $privacySubCatNaam;
    /**
     * Constructor method for PrivacySubCat
     * @uses PrivacySubCat::setPrivacySubCatCode()
     * @uses PrivacySubCat::setPrivacySubCatDefault()
     * @uses PrivacySubCat::setPrivacySubCatNaam()
     * @param string $privacySubCatCode
     * @param int $privacySubCatDefault
     * @param string $privacySubCatNaam
     */
    public function __construct($privacySubCatCode = null, $privacySubCatDefault = null, $privacySubCatNaam = null)
    {
        $this
            ->setPrivacySubCatCode($privacySubCatCode)
            ->setPrivacySubCatDefault($privacySubCatDefault)
            ->setPrivacySubCatNaam($privacySubCatNaam);
    }
    /**
     * Get privacySubCatCode value
     * @return string
     */
    public function getPrivacySubCatCode()
    {
        return $this->privacySubCatCode;
    }
    /**
     * Set privacySubCatCode value
     * @param string $privacySubCatCode
     * @return \RelatieApiV6\StructType\PrivacySubCat
     */
    public function setPrivacySubCatCode($privacySubCatCode = null)
    {
        // validation for constraint: string
        if (!is_null($privacySubCatCode) && !is_string($privacySubCatCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($privacySubCatCode, true), gettype($privacySubCatCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($privacySubCatCode) && mb_strlen($privacySubCatCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($privacySubCatCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($privacySubCatCode) && mb_strlen($privacySubCatCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($privacySubCatCode)), __LINE__);
        }
        $this->privacySubCatCode = $privacySubCatCode;
        return $this;
    }
    /**
     * Get privacySubCatDefault value
     * @return int
     */
    public function getPrivacySubCatDefault()
    {
        return $this->privacySubCatDefault;
    }
    /**
     * Set privacySubCatDefault value
     * @param int $privacySubCatDefault
     * @return \RelatieApiV6\StructType\PrivacySubCat
     */
    public function setPrivacySubCatDefault($privacySubCatDefault = null)
    {
        // validation for constraint: int
        if (!is_null($privacySubCatDefault) && !(is_int($privacySubCatDefault) || ctype_digit($privacySubCatDefault))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($privacySubCatDefault, true), gettype($privacySubCatDefault)), __LINE__);
        }
        // validation for constraint: totalDigits(1)
        if (!is_null($privacySubCatDefault) && mb_strlen(preg_replace('/(\D)/', '', $privacySubCatDefault)) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 1 digits, "%d" given', var_export($privacySubCatDefault, true), mb_strlen(preg_replace('/(\D)/', '', $privacySubCatDefault))), __LINE__);
        }
        $this->privacySubCatDefault = $privacySubCatDefault;
        return $this;
    }
    /**
     * Get privacySubCatNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrivacySubCatNaam()
    {
        return isset($this->privacySubCatNaam) ? $this->privacySubCatNaam : null;
    }
    /**
     * Set privacySubCatNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $privacySubCatNaam
     * @return \RelatieApiV6\StructType\PrivacySubCat
     */
    public function setPrivacySubCatNaam($privacySubCatNaam = null)
    {
        // validation for constraint: string
        if (!is_null($privacySubCatNaam) && !is_string($privacySubCatNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($privacySubCatNaam, true), gettype($privacySubCatNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($privacySubCatNaam) && mb_strlen($privacySubCatNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($privacySubCatNaam)), __LINE__);
        }
        if (is_null($privacySubCatNaam) || (is_array($privacySubCatNaam) && empty($privacySubCatNaam))) {
            unset($this->privacySubCatNaam);
        } else {
            $this->privacySubCatNaam = $privacySubCatNaam;
        }
        return $this;
    }
}
