<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrivacyCatInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met gevonden privacy categorieen.
 * @subpackage Structs
 * @date 20240419 package
 */
class PrivacyCatInfo extends AbstractStructBase
{
    /**
     * The privacyCat
     * Meta information extracted from the WSDL
     * - documentation: Lijst met gevonden privacy categorieen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \RelatieApiV6\StructType\PrivacyCat[]
     */
    public $privacyCat;
    /**
     * Constructor method for PrivacyCatInfo
     * @uses PrivacyCatInfo::setPrivacyCat()
     * @param \RelatieApiV6\StructType\PrivacyCat[] $privacyCat
     */
    public function __construct(array $privacyCat = array())
    {
        $this
            ->setPrivacyCat($privacyCat);
    }
    /**
     * Get privacyCat value
     * @return \RelatieApiV6\StructType\PrivacyCat[]|null
     */
    public function getPrivacyCat()
    {
        return $this->privacyCat;
    }
    /**
     * This method is responsible for validating the values passed to the setPrivacyCat method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrivacyCat method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePrivacyCatForArrayConstraintsFromSetPrivacyCat(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $privacyCatInfoPrivacyCatItem) {
            // validation for constraint: itemType
            if (!$privacyCatInfoPrivacyCatItem instanceof \RelatieApiV6\StructType\PrivacyCat) {
                $invalidValues[] = is_object($privacyCatInfoPrivacyCatItem) ? get_class($privacyCatInfoPrivacyCatItem) : sprintf('%s(%s)', gettype($privacyCatInfoPrivacyCatItem), var_export($privacyCatInfoPrivacyCatItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The privacyCat property can only contain items of type \RelatieApiV6\StructType\PrivacyCat, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set privacyCat value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV6\StructType\PrivacyCat[] $privacyCat
     * @return \RelatieApiV6\StructType\PrivacyCatInfo
     */
    public function setPrivacyCat(array $privacyCat = array())
    {
        // validation for constraint: array
        if ('' !== ($privacyCatArrayErrorMessage = self::validatePrivacyCatForArrayConstraintsFromSetPrivacyCat($privacyCat))) {
            throw new \InvalidArgumentException($privacyCatArrayErrorMessage, __LINE__);
        }
        $this->privacyCat = $privacyCat;
        return $this;
    }
    /**
     * Add item to privacyCat value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV6\StructType\PrivacyCat $item
     * @return \RelatieApiV6\StructType\PrivacyCatInfo
     */
    public function addToPrivacyCat(\RelatieApiV6\StructType\PrivacyCat $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \RelatieApiV6\StructType\PrivacyCat) {
            throw new \InvalidArgumentException(sprintf('The privacyCat property can only contain items of type \RelatieApiV6\StructType\PrivacyCat, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->privacyCat[] = $item;
        return $this;
    }
}
