<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersoonRec StructType
 * Meta information extracted from the WSDL
 * - documentation: Persoongegevens
 * @subpackage Structs
 * @date 20240419 package
 */
class PersoonRec extends AbstractStructBase
{
    /**
     * The relatienummer
     * Meta information extracted from the WSDL
     * - documentation: Het unieke nummer voor het persoon.<BR>Verplicht in geval van een update.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relatienummer;
    /**
     * The achternaam
     * Meta information extracted from the WSDL
     * - documentation: Not null De achternaam van de persoon
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $achternaam;
    /**
     * The voornaam
     * Meta information extracted from the WSDL
     * - documentation: De voornaam van de persoon
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $voornaam;
    /**
     * The voorletters
     * Meta information extracted from the WSDL
     * - documentation: De voorletters van de persoon
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $voorletters;
    /**
     * The voorvoegsels
     * Meta information extracted from the WSDL
     * - documentation: De voorvoegsels
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $voorvoegsels;
    /**
     * The geslachtsCode
     * Meta information extracted from the WSDL
     * - documentation: De geslachtscode (0=Nvt, 1=Man, 2=Vrouw, 3=Geen)
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $geslachtsCode;
    /**
     * The titulatuurCode
     * Meta information extracted from the WSDL
     * - documentation: Titulatuur code
     * - base: xsd:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $titulatuurCode;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - documentation: E-mail adres 1
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $email;
    /**
     * The email2
     * Meta information extracted from the WSDL
     * - documentation: E-mail adres 2
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $email2;
    /**
     * The email3
     * Meta information extracted from the WSDL
     * - documentation: E-mail adres 3
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $email3;
    /**
     * The email4
     * Meta information extracted from the WSDL
     * - documentation: E-mail adres 4
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $email4;
    /**
     * The telefoonnummer
     * Meta information extracted from the WSDL
     * - documentation: Telefoonnummer van de persoon
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $telefoonnummer;
    /**
     * The telefoonnummerMobiel
     * Meta information extracted from the WSDL
     * - documentation: Telefoonnummer mobiel van de persoon
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $telefoonnummerMobiel;
    /**
     * The geboortedatum
     * Meta information extracted from the WSDL
     * - documentation: date Geboortedatum van de persoon
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $geboortedatum;
    /**
     * The username
     * Meta information extracted from the WSDL
     * - documentation: De username voor de gebruiker
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $username;
    /**
     * The betaling
     * Meta information extracted from the WSDL
     * - documentation: De betaalgegevens
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\BetaalRec
     */
    public $betaling;
    /**
     * The kredietlimiet
     * Meta information extracted from the WSDL
     * - documentation: De kredietlimiet
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 17
     * @var float
     */
    public $kredietlimiet;
    /**
     * The bestedingsruimte
     * Meta information extracted from the WSDL
     * - documentation: De beschikbare bestedingsruimte
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 17
     * @var float
     */
    public $bestedingsruimte;
    /**
     * The kortinggroepCode
     * Meta information extracted from the WSDL
     * - documentation: De kortinggroep code
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $kortinggroepCode;
    /**
     * The adresBezoek
     * Meta information extracted from the WSDL
     * - documentation: Het bezoekadres van de persoon
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\AdresRec
     */
    public $adresBezoek;
    /**
     * The adresCorrespondentie
     * Meta information extracted from the WSDL
     * - documentation: Het correspondentieadres van de persoon
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\AdresRec
     */
    public $adresCorrespondentie;
    /**
     * The adresPrive
     * Meta information extracted from the WSDL
     * - documentation: Het priveadres van de persoon
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\AdresRec
     */
    public $adresPrive;
    /**
     * The landCode
     * Meta information extracted from the WSDL
     * - documentation: (Iso-) landcode van de persoon
     * - base: xsd:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $landCode;
    /**
     * The provincieCode
     * Meta information extracted from the WSDL
     * - documentation: Provinciecode van de provincie
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $provincieCode;
    /**
     * The onvolledig
     * Meta information extracted from the WSDL
     * - documentation: De gegevens van de relatie zijn onvolledig en moeten aangevuld worden
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $onvolledig;
    /**
     * The vrijeVelden
     * Meta information extracted from the WSDL
     * - documentation: De vrije velden van de relatie
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\VrijeVeldenRec
     */
    public $vrijeVelden;
    /**
     * The taalCode
     * Meta information extracted from the WSDL
     * - documentation: De taalcode van de persoon
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $taalCode;
    /**
     * The valutaCode
     * Meta information extracted from the WSDL
     * - documentation: Valuta waarin de relatie betaalt. Indien leeg, wordt de valuta bepaald adhv de inrichting in Zeno obv landen
     * - base: xsd:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $valutaCode;
    /**
     * The uitsluitenVanMailing
     * Meta information extracted from the WSDL
     * - documentation: Deze relatie uitsluiten van mailing(s). Dit is een optioneel veld: indien waarde true of false wordt meegegeven, is dat van toepassing. Indien waarde nil of niets wordt meegegeven is de standaard of bestaande instelling voor relaties
     * bepalend.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $uitsluitenVanMailing;
    /**
     * The rechtVanBeperking
     * Meta information extracted from the WSDL
     * - documentation: Voor deze relatie geldt het recht van beperking op verwerking. Dit is een optioneel veld: indien waarde true of false wordt meegegeven, is dat van toepassing. Indien waarde nil of niets wordt meegegeven is de standaard of bestaande
     * instelling voor relaties bepalend.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $rechtVanBeperking;
    /**
     * Constructor method for PersoonRec
     * @uses PersoonRec::setRelatienummer()
     * @uses PersoonRec::setAchternaam()
     * @uses PersoonRec::setVoornaam()
     * @uses PersoonRec::setVoorletters()
     * @uses PersoonRec::setVoorvoegsels()
     * @uses PersoonRec::setGeslachtsCode()
     * @uses PersoonRec::setTitulatuurCode()
     * @uses PersoonRec::setEmail()
     * @uses PersoonRec::setEmail2()
     * @uses PersoonRec::setEmail3()
     * @uses PersoonRec::setEmail4()
     * @uses PersoonRec::setTelefoonnummer()
     * @uses PersoonRec::setTelefoonnummerMobiel()
     * @uses PersoonRec::setGeboortedatum()
     * @uses PersoonRec::setUsername()
     * @uses PersoonRec::setBetaling()
     * @uses PersoonRec::setKredietlimiet()
     * @uses PersoonRec::setBestedingsruimte()
     * @uses PersoonRec::setKortinggroepCode()
     * @uses PersoonRec::setAdresBezoek()
     * @uses PersoonRec::setAdresCorrespondentie()
     * @uses PersoonRec::setAdresPrive()
     * @uses PersoonRec::setLandCode()
     * @uses PersoonRec::setProvincieCode()
     * @uses PersoonRec::setOnvolledig()
     * @uses PersoonRec::setVrijeVelden()
     * @uses PersoonRec::setTaalCode()
     * @uses PersoonRec::setValutaCode()
     * @uses PersoonRec::setUitsluitenVanMailing()
     * @uses PersoonRec::setRechtVanBeperking()
     * @param int $relatienummer
     * @param string $achternaam
     * @param string $voornaam
     * @param string $voorletters
     * @param string $voorvoegsels
     * @param string $geslachtsCode
     * @param string $titulatuurCode
     * @param string $email
     * @param string $email2
     * @param string $email3
     * @param string $email4
     * @param string $telefoonnummer
     * @param string $telefoonnummerMobiel
     * @param string $geboortedatum
     * @param string $username
     * @param \RelatieApiV6\StructType\BetaalRec $betaling
     * @param float $kredietlimiet
     * @param float $bestedingsruimte
     * @param string $kortinggroepCode
     * @param \RelatieApiV6\StructType\AdresRec $adresBezoek
     * @param \RelatieApiV6\StructType\AdresRec $adresCorrespondentie
     * @param \RelatieApiV6\StructType\AdresRec $adresPrive
     * @param string $landCode
     * @param string $provincieCode
     * @param bool $onvolledig
     * @param \RelatieApiV6\StructType\VrijeVeldenRec $vrijeVelden
     * @param string $taalCode
     * @param string $valutaCode
     * @param bool $uitsluitenVanMailing
     * @param bool $rechtVanBeperking
     */
    public function __construct($relatienummer = null, $achternaam = null, $voornaam = null, $voorletters = null, $voorvoegsels = null, $geslachtsCode = null, $titulatuurCode = null, $email = null, $email2 = null, $email3 = null, $email4 = null, $telefoonnummer = null, $telefoonnummerMobiel = null, $geboortedatum = null, $username = null, \RelatieApiV6\StructType\BetaalRec $betaling = null, $kredietlimiet = null, $bestedingsruimte = null, $kortinggroepCode = null, \RelatieApiV6\StructType\AdresRec $adresBezoek = null, \RelatieApiV6\StructType\AdresRec $adresCorrespondentie = null, \RelatieApiV6\StructType\AdresRec $adresPrive = null, $landCode = null, $provincieCode = null, $onvolledig = null, \RelatieApiV6\StructType\VrijeVeldenRec $vrijeVelden = null, $taalCode = null, $valutaCode = null, $uitsluitenVanMailing = null, $rechtVanBeperking = null)
    {
        $this
            ->setRelatienummer($relatienummer)
            ->setAchternaam($achternaam)
            ->setVoornaam($voornaam)
            ->setVoorletters($voorletters)
            ->setVoorvoegsels($voorvoegsels)
            ->setGeslachtsCode($geslachtsCode)
            ->setTitulatuurCode($titulatuurCode)
            ->setEmail($email)
            ->setEmail2($email2)
            ->setEmail3($email3)
            ->setEmail4($email4)
            ->setTelefoonnummer($telefoonnummer)
            ->setTelefoonnummerMobiel($telefoonnummerMobiel)
            ->setGeboortedatum($geboortedatum)
            ->setUsername($username)
            ->setBetaling($betaling)
            ->setKredietlimiet($kredietlimiet)
            ->setBestedingsruimte($bestedingsruimte)
            ->setKortinggroepCode($kortinggroepCode)
            ->setAdresBezoek($adresBezoek)
            ->setAdresCorrespondentie($adresCorrespondentie)
            ->setAdresPrive($adresPrive)
            ->setLandCode($landCode)
            ->setProvincieCode($provincieCode)
            ->setOnvolledig($onvolledig)
            ->setVrijeVelden($vrijeVelden)
            ->setTaalCode($taalCode)
            ->setValutaCode($valutaCode)
            ->setUitsluitenVanMailing($uitsluitenVanMailing)
            ->setRechtVanBeperking($rechtVanBeperking);
    }
    /**
     * Get relatienummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelatienummer()
    {
        return isset($this->relatienummer) ? $this->relatienummer : null;
    }
    /**
     * Set relatienummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relatienummer
     * @return \RelatieApiV6\StructType\PersoonRec
     */
    public function setRelatienummer($relatienummer = null)
    {
        // validation for constraint: int
        if (!is_null($relatienummer) && !(is_int($relatienummer) || ctype_digit($relatienummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatienummer, true), gettype($relatienummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatienummer) && mb_strlen(preg_replace('/(\D)/', '', $relatienummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatienummer, true), mb_strlen(preg_replace('/(\D)/', '', $relatienummer))), __LINE__);
        }
        if (is_null($relatienummer) || (is_array($relatienummer) && empty($relatienummer))) {
            unset($this->relatienummer);
        } else {
            $this->relatienummer = $relatienummer;
        }
        return $this;
    }
    /**
     * Get achternaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAchternaam()
    {
        return isset($this->achternaam) ? $this->achternaam : null;
    }
    /**
     * Set achternaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $achternaam
     * @return \RelatieApiV6\StructType\PersoonRec
     */
    public function setAchternaam($achternaam = null)
    {
        // validation for constraint: string
        if (!is_null($achternaam) && !is_string($achternaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($achternaam, true), gettype($achternaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($achternaam) && mb_strlen($achternaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($achternaam)), __LINE__);
        }
        if (is_null($achternaam) || (is_array($achternaam) && empty($achternaam))) {
            unset($this->achternaam);
        } else {
            $this->achternaam = $achternaam;
        }
        return $this;
    }
    /**
     * Get voornaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVoornaam()
    {
        return isset($this->voornaam) ? $this->voornaam : null;
    }
    /**
     * Set voornaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $voornaam
     * @return \RelatieApiV6\StructType\PersoonRec
     */
    public function setVoornaam($voornaam = null)
    {
        // validation for constraint: string
        if (!is_null($voornaam) && !is_string($voornaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voornaam, true), gettype($voornaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($voornaam) && mb_strlen($voornaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($voornaam)), __LINE__);
        }
        if (is_null($voornaam) || (is_array($voornaam) && empty($voornaam))) {
            unset($this->voornaam);
        } else {
            $this->voornaam = $voornaam;
        }
        return $this;
    }
    /**
     * Get voorletters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVoorletters()
    {
        return isset($this->voorletters) ? $this->voorletters : null;
    }
    /**
     * Set voorletters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $voorletters
     * @return \RelatieApiV6\StructType\PersoonRec
     */
    public function setVoorletters($voorletters = null)
    {
        // validation for constraint: string
        if (!is_null($voorletters) && !is_string($voorletters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voorletters, true), gettype($voorletters)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($voorletters) && mb_strlen($voorletters) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($voorletters)), __LINE__);
        }
        if (is_null($voorletters) || (is_array($voorletters) && empty($voorletters))) {
            unset($this->voorletters);
        } else {
            $this->voorletters = $voorletters;
        }
        return $this;
    }
    /**
     * Get voorvoegsels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVoorvoegsels()
    {
        return isset($this->voorvoegsels) ? $this->voorvoegsels : null;
    }
    /**
     * Set voorvoegsels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $voorvoegsels
     * @return \RelatieApiV6\StructType\PersoonRec
     */
    public function setVoorvoegsels($voorvoegsels = null)
    {
        // validation for constraint: string
        if (!is_null($voorvoegsels) && !is_string($voorvoegsels)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voorvoegsels, true), gettype($voorvoegsels)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($voorvoegsels) && mb_strlen($voorvoegsels) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($voorvoegsels)), __LINE__);
        }
        if (is_null($voorvoegsels) || (is_array($voorvoegsels) && empty($voorvoegsels))) {
            unset($this->voorvoegsels);
        } else {
            $this->voorvoegsels = $voorvoegsels;
        }
        return $this;
    }
    /**
     * Get geslachtsCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeslachtsCode()
    {
        return isset($this->geslachtsCode) ? $this->geslachtsCode : null;
    }
    /**
     * Set geslachtsCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $geslachtsCode
     * @return \RelatieApiV6\StructType\PersoonRec
     */
    public function setGeslachtsCode($geslachtsCode = null)
    {
        // validation for constraint: string
        if (!is_null($geslachtsCode) && !is_string($geslachtsCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geslachtsCode, true), gettype($geslachtsCode)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($geslachtsCode) && mb_strlen($geslachtsCode) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($geslachtsCode)), __LINE__);
        }
        if (is_null($geslachtsCode) || (is_array($geslachtsCode) && empty($geslachtsCode))) {
            unset($this->geslachtsCode);
        } else {
            $this->geslachtsCode = $geslachtsCode;
        }
        return $this;
    }
    /**
     * Get titulatuurCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitulatuurCode()
    {
        return isset($this->titulatuurCode) ? $this->titulatuurCode : null;
    }
    /**
     * Set titulatuurCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $titulatuurCode
     * @return \RelatieApiV6\StructType\PersoonRec
     */
    public function setTitulatuurCode($titulatuurCode = null)
    {
        // validation for constraint: string
        if (!is_null($titulatuurCode) && !is_string($titulatuurCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($titulatuurCode, true), gettype($titulatuurCode)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($titulatuurCode) && mb_strlen($titulatuurCode) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($titulatuurCode)), __LINE__);
        }
        if (is_null($titulatuurCode) || (is_array($titulatuurCode) && empty($titulatuurCode))) {
            unset($this->titulatuurCode);
        } else {
            $this->titulatuurCode = $titulatuurCode;
        }
        return $this;
    }
    /**
     * Get email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->email) ? $this->email : null;
    }
    /**
     * Set email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \RelatieApiV6\StructType\PersoonRec
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($email) && mb_strlen($email) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->email);
        } else {
            $this->email = $email;
        }
        return $this;
    }
    /**
     * Get email2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail2()
    {
        return isset($this->email2) ? $this->email2 : null;
    }
    /**
     * Set email2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email2
     * @return \RelatieApiV6\StructType\PersoonRec
     */
    public function setEmail2($email2 = null)
    {
        // validation for constraint: string
        if (!is_null($email2) && !is_string($email2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email2, true), gettype($email2)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($email2) && mb_strlen($email2) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($email2)), __LINE__);
        }
        if (is_null($email2) || (is_array($email2) && empty($email2))) {
            unset($this->email2);
        } else {
            $this->email2 = $email2;
        }
        return $this;
    }
    /**
     * Get email3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail3()
    {
        return isset($this->email3) ? $this->email3 : null;
    }
    /**
     * Set email3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email3
     * @return \RelatieApiV6\StructType\PersoonRec
     */
    public function setEmail3($email3 = null)
    {
        // validation for constraint: string
        if (!is_null($email3) && !is_string($email3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email3, true), gettype($email3)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($email3) && mb_strlen($email3) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($email3)), __LINE__);
        }
        if (is_null($email3) || (is_array($email3) && empty($email3))) {
            unset($this->email3);
        } else {
            $this->email3 = $email3;
        }
        return $this;
    }
    /**
     * Get email4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail4()
    {
        return isset($this->email4) ? $this->email4 : null;
    }
    /**
     * Set email4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email4
     * @return \RelatieApiV6\StructType\PersoonRec
     */
    public function setEmail4($email4 = null)
    {
        // validation for constraint: string
        if (!is_null($email4) && !is_string($email4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email4, true), gettype($email4)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($email4) && mb_strlen($email4) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($email4)), __LINE__);
        }
        if (is_null($email4) || (is_array($email4) && empty($email4))) {
            unset($this->email4);
        } else {
            $this->email4 = $email4;
        }
        return $this;
    }
    /**
     * Get telefoonnummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTelefoonnummer()
    {
        return isset($this->telefoonnummer) ? $this->telefoonnummer : null;
    }
    /**
     * Set telefoonnummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $telefoonnummer
     * @return \RelatieApiV6\StructType\PersoonRec
     */
    public function setTelefoonnummer($telefoonnummer = null)
    {
        // validation for constraint: string
        if (!is_null($telefoonnummer) && !is_string($telefoonnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefoonnummer, true), gettype($telefoonnummer)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($telefoonnummer) && mb_strlen($telefoonnummer) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($telefoonnummer)), __LINE__);
        }
        if (is_null($telefoonnummer) || (is_array($telefoonnummer) && empty($telefoonnummer))) {
            unset($this->telefoonnummer);
        } else {
            $this->telefoonnummer = $telefoonnummer;
        }
        return $this;
    }
    /**
     * Get telefoonnummerMobiel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTelefoonnummerMobiel()
    {
        return isset($this->telefoonnummerMobiel) ? $this->telefoonnummerMobiel : null;
    }
    /**
     * Set telefoonnummerMobiel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $telefoonnummerMobiel
     * @return \RelatieApiV6\StructType\PersoonRec
     */
    public function setTelefoonnummerMobiel($telefoonnummerMobiel = null)
    {
        // validation for constraint: string
        if (!is_null($telefoonnummerMobiel) && !is_string($telefoonnummerMobiel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefoonnummerMobiel, true), gettype($telefoonnummerMobiel)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($telefoonnummerMobiel) && mb_strlen($telefoonnummerMobiel) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($telefoonnummerMobiel)), __LINE__);
        }
        if (is_null($telefoonnummerMobiel) || (is_array($telefoonnummerMobiel) && empty($telefoonnummerMobiel))) {
            unset($this->telefoonnummerMobiel);
        } else {
            $this->telefoonnummerMobiel = $telefoonnummerMobiel;
        }
        return $this;
    }
    /**
     * Get geboortedatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeboortedatum()
    {
        return isset($this->geboortedatum) ? $this->geboortedatum : null;
    }
    /**
     * Set geboortedatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $geboortedatum
     * @return \RelatieApiV6\StructType\PersoonRec
     */
    public function setGeboortedatum($geboortedatum = null)
    {
        // validation for constraint: string
        if (!is_null($geboortedatum) && !is_string($geboortedatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geboortedatum, true), gettype($geboortedatum)), __LINE__);
        }
        if (is_null($geboortedatum) || (is_array($geboortedatum) && empty($geboortedatum))) {
            unset($this->geboortedatum);
        } else {
            $this->geboortedatum = $geboortedatum;
        }
        return $this;
    }
    /**
     * Get username value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsername()
    {
        return isset($this->username) ? $this->username : null;
    }
    /**
     * Set username value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $username
     * @return \RelatieApiV6\StructType\PersoonRec
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($username) && mb_strlen($username) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($username)), __LINE__);
        }
        if (is_null($username) || (is_array($username) && empty($username))) {
            unset($this->username);
        } else {
            $this->username = $username;
        }
        return $this;
    }
    /**
     * Get betaling value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\BetaalRec|null
     */
    public function getBetaling()
    {
        return isset($this->betaling) ? $this->betaling : null;
    }
    /**
     * Set betaling value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\BetaalRec $betaling
     * @return \RelatieApiV6\StructType\PersoonRec
     */
    public function setBetaling(\RelatieApiV6\StructType\BetaalRec $betaling = null)
    {
        if (is_null($betaling) || (is_array($betaling) && empty($betaling))) {
            unset($this->betaling);
        } else {
            $this->betaling = $betaling;
        }
        return $this;
    }
    /**
     * Get kredietlimiet value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKredietlimiet()
    {
        return isset($this->kredietlimiet) ? $this->kredietlimiet : null;
    }
    /**
     * Set kredietlimiet value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kredietlimiet
     * @return \RelatieApiV6\StructType\PersoonRec
     */
    public function setKredietlimiet($kredietlimiet = null)
    {
        // validation for constraint: float
        if (!is_null($kredietlimiet) && !(is_float($kredietlimiet) || is_numeric($kredietlimiet))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kredietlimiet, true), gettype($kredietlimiet)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($kredietlimiet) && mb_strlen(mb_substr($kredietlimiet, false !== mb_strpos($kredietlimiet, '.') ? mb_strpos($kredietlimiet, '.') + 1 : mb_strlen($kredietlimiet))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($kredietlimiet, true), mb_strlen(mb_substr($kredietlimiet, mb_strpos($kredietlimiet, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($kredietlimiet) && mb_strlen(preg_replace('/(\D)/', '', $kredietlimiet)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($kredietlimiet, true), mb_strlen(preg_replace('/(\D)/', '', $kredietlimiet))), __LINE__);
        }
        if (is_null($kredietlimiet) || (is_array($kredietlimiet) && empty($kredietlimiet))) {
            unset($this->kredietlimiet);
        } else {
            $this->kredietlimiet = $kredietlimiet;
        }
        return $this;
    }
    /**
     * Get bestedingsruimte value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBestedingsruimte()
    {
        return isset($this->bestedingsruimte) ? $this->bestedingsruimte : null;
    }
    /**
     * Set bestedingsruimte value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $bestedingsruimte
     * @return \RelatieApiV6\StructType\PersoonRec
     */
    public function setBestedingsruimte($bestedingsruimte = null)
    {
        // validation for constraint: float
        if (!is_null($bestedingsruimte) && !(is_float($bestedingsruimte) || is_numeric($bestedingsruimte))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bestedingsruimte, true), gettype($bestedingsruimte)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($bestedingsruimte) && mb_strlen(mb_substr($bestedingsruimte, false !== mb_strpos($bestedingsruimte, '.') ? mb_strpos($bestedingsruimte, '.') + 1 : mb_strlen($bestedingsruimte))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($bestedingsruimte, true), mb_strlen(mb_substr($bestedingsruimte, mb_strpos($bestedingsruimte, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($bestedingsruimte) && mb_strlen(preg_replace('/(\D)/', '', $bestedingsruimte)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($bestedingsruimte, true), mb_strlen(preg_replace('/(\D)/', '', $bestedingsruimte))), __LINE__);
        }
        if (is_null($bestedingsruimte) || (is_array($bestedingsruimte) && empty($bestedingsruimte))) {
            unset($this->bestedingsruimte);
        } else {
            $this->bestedingsruimte = $bestedingsruimte;
        }
        return $this;
    }
    /**
     * Get kortinggroepCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKortinggroepCode()
    {
        return isset($this->kortinggroepCode) ? $this->kortinggroepCode : null;
    }
    /**
     * Set kortinggroepCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kortinggroepCode
     * @return \RelatieApiV6\StructType\PersoonRec
     */
    public function setKortinggroepCode($kortinggroepCode = null)
    {
        // validation for constraint: string
        if (!is_null($kortinggroepCode) && !is_string($kortinggroepCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kortinggroepCode, true), gettype($kortinggroepCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($kortinggroepCode) && mb_strlen($kortinggroepCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($kortinggroepCode)), __LINE__);
        }
        if (is_null($kortinggroepCode) || (is_array($kortinggroepCode) && empty($kortinggroepCode))) {
            unset($this->kortinggroepCode);
        } else {
            $this->kortinggroepCode = $kortinggroepCode;
        }
        return $this;
    }
    /**
     * Get adresBezoek value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\AdresRec|null
     */
    public function getAdresBezoek()
    {
        return isset($this->adresBezoek) ? $this->adresBezoek : null;
    }
    /**
     * Set adresBezoek value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\AdresRec $adresBezoek
     * @return \RelatieApiV6\StructType\PersoonRec
     */
    public function setAdresBezoek(\RelatieApiV6\StructType\AdresRec $adresBezoek = null)
    {
        if (is_null($adresBezoek) || (is_array($adresBezoek) && empty($adresBezoek))) {
            unset($this->adresBezoek);
        } else {
            $this->adresBezoek = $adresBezoek;
        }
        return $this;
    }
    /**
     * Get adresCorrespondentie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\AdresRec|null
     */
    public function getAdresCorrespondentie()
    {
        return isset($this->adresCorrespondentie) ? $this->adresCorrespondentie : null;
    }
    /**
     * Set adresCorrespondentie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\AdresRec $adresCorrespondentie
     * @return \RelatieApiV6\StructType\PersoonRec
     */
    public function setAdresCorrespondentie(\RelatieApiV6\StructType\AdresRec $adresCorrespondentie = null)
    {
        if (is_null($adresCorrespondentie) || (is_array($adresCorrespondentie) && empty($adresCorrespondentie))) {
            unset($this->adresCorrespondentie);
        } else {
            $this->adresCorrespondentie = $adresCorrespondentie;
        }
        return $this;
    }
    /**
     * Get adresPrive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\AdresRec|null
     */
    public function getAdresPrive()
    {
        return isset($this->adresPrive) ? $this->adresPrive : null;
    }
    /**
     * Set adresPrive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\AdresRec $adresPrive
     * @return \RelatieApiV6\StructType\PersoonRec
     */
    public function setAdresPrive(\RelatieApiV6\StructType\AdresRec $adresPrive = null)
    {
        if (is_null($adresPrive) || (is_array($adresPrive) && empty($adresPrive))) {
            unset($this->adresPrive);
        } else {
            $this->adresPrive = $adresPrive;
        }
        return $this;
    }
    /**
     * Get landCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLandCode()
    {
        return isset($this->landCode) ? $this->landCode : null;
    }
    /**
     * Set landCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $landCode
     * @return \RelatieApiV6\StructType\PersoonRec
     */
    public function setLandCode($landCode = null)
    {
        // validation for constraint: string
        if (!is_null($landCode) && !is_string($landCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($landCode, true), gettype($landCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($landCode) && mb_strlen($landCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($landCode)), __LINE__);
        }
        if (is_null($landCode) || (is_array($landCode) && empty($landCode))) {
            unset($this->landCode);
        } else {
            $this->landCode = $landCode;
        }
        return $this;
    }
    /**
     * Get provincieCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProvincieCode()
    {
        return isset($this->provincieCode) ? $this->provincieCode : null;
    }
    /**
     * Set provincieCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $provincieCode
     * @return \RelatieApiV6\StructType\PersoonRec
     */
    public function setProvincieCode($provincieCode = null)
    {
        // validation for constraint: string
        if (!is_null($provincieCode) && !is_string($provincieCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provincieCode, true), gettype($provincieCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($provincieCode) && mb_strlen($provincieCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($provincieCode)), __LINE__);
        }
        if (is_null($provincieCode) || (is_array($provincieCode) && empty($provincieCode))) {
            unset($this->provincieCode);
        } else {
            $this->provincieCode = $provincieCode;
        }
        return $this;
    }
    /**
     * Get onvolledig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOnvolledig()
    {
        return isset($this->onvolledig) ? $this->onvolledig : null;
    }
    /**
     * Set onvolledig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $onvolledig
     * @return \RelatieApiV6\StructType\PersoonRec
     */
    public function setOnvolledig($onvolledig = null)
    {
        // validation for constraint: boolean
        if (!is_null($onvolledig) && !is_bool($onvolledig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onvolledig, true), gettype($onvolledig)), __LINE__);
        }
        if (is_null($onvolledig) || (is_array($onvolledig) && empty($onvolledig))) {
            unset($this->onvolledig);
        } else {
            $this->onvolledig = $onvolledig;
        }
        return $this;
    }
    /**
     * Get vrijeVelden value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\VrijeVeldenRec|null
     */
    public function getVrijeVelden()
    {
        return isset($this->vrijeVelden) ? $this->vrijeVelden : null;
    }
    /**
     * Set vrijeVelden value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\VrijeVeldenRec $vrijeVelden
     * @return \RelatieApiV6\StructType\PersoonRec
     */
    public function setVrijeVelden(\RelatieApiV6\StructType\VrijeVeldenRec $vrijeVelden = null)
    {
        if (is_null($vrijeVelden) || (is_array($vrijeVelden) && empty($vrijeVelden))) {
            unset($this->vrijeVelden);
        } else {
            $this->vrijeVelden = $vrijeVelden;
        }
        return $this;
    }
    /**
     * Get taalCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaalCode()
    {
        return isset($this->taalCode) ? $this->taalCode : null;
    }
    /**
     * Set taalCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taalCode
     * @return \RelatieApiV6\StructType\PersoonRec
     */
    public function setTaalCode($taalCode = null)
    {
        // validation for constraint: string
        if (!is_null($taalCode) && !is_string($taalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taalCode, true), gettype($taalCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($taalCode) && mb_strlen($taalCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($taalCode)), __LINE__);
        }
        if (is_null($taalCode) || (is_array($taalCode) && empty($taalCode))) {
            unset($this->taalCode);
        } else {
            $this->taalCode = $taalCode;
        }
        return $this;
    }
    /**
     * Get valutaCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValutaCode()
    {
        return isset($this->valutaCode) ? $this->valutaCode : null;
    }
    /**
     * Set valutaCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $valutaCode
     * @return \RelatieApiV6\StructType\PersoonRec
     */
    public function setValutaCode($valutaCode = null)
    {
        // validation for constraint: string
        if (!is_null($valutaCode) && !is_string($valutaCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valutaCode, true), gettype($valutaCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($valutaCode) && mb_strlen($valutaCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($valutaCode)), __LINE__);
        }
        if (is_null($valutaCode) || (is_array($valutaCode) && empty($valutaCode))) {
            unset($this->valutaCode);
        } else {
            $this->valutaCode = $valutaCode;
        }
        return $this;
    }
    /**
     * Get uitsluitenVanMailing value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUitsluitenVanMailing()
    {
        return isset($this->uitsluitenVanMailing) ? $this->uitsluitenVanMailing : null;
    }
    /**
     * Set uitsluitenVanMailing value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $uitsluitenVanMailing
     * @return \RelatieApiV6\StructType\PersoonRec
     */
    public function setUitsluitenVanMailing($uitsluitenVanMailing = null)
    {
        // validation for constraint: boolean
        if (!is_null($uitsluitenVanMailing) && !is_bool($uitsluitenVanMailing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($uitsluitenVanMailing, true), gettype($uitsluitenVanMailing)), __LINE__);
        }
        if (is_null($uitsluitenVanMailing) || (is_array($uitsluitenVanMailing) && empty($uitsluitenVanMailing))) {
            unset($this->uitsluitenVanMailing);
        } else {
            $this->uitsluitenVanMailing = $uitsluitenVanMailing;
        }
        return $this;
    }
    /**
     * Get rechtVanBeperking value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getRechtVanBeperking()
    {
        return isset($this->rechtVanBeperking) ? $this->rechtVanBeperking : null;
    }
    /**
     * Set rechtVanBeperking value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $rechtVanBeperking
     * @return \RelatieApiV6\StructType\PersoonRec
     */
    public function setRechtVanBeperking($rechtVanBeperking = null)
    {
        // validation for constraint: boolean
        if (!is_null($rechtVanBeperking) && !is_bool($rechtVanBeperking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($rechtVanBeperking, true), gettype($rechtVanBeperking)), __LINE__);
        }
        if (is_null($rechtVanBeperking) || (is_array($rechtVanBeperking) && empty($rechtVanBeperking))) {
            unset($this->rechtVanBeperking);
        } else {
            $this->rechtVanBeperking = $rechtVanBeperking;
        }
        return $this;
    }
}
