<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NetnummerRec StructType
 * Meta information extracted from the WSDL
 * - documentation: Netnummers
 * @subpackage Structs
 * @date 20240419 package
 */
class NetnummerRec extends AbstractStructBase
{
    /**
     * The nummer
     * Meta information extracted from the WSDL
     * - documentation: Het netnummer
     * - base: xsd:string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $nummer;
    /**
     * The plaats
     * Meta information extracted from the WSDL
     * - documentation: De plaats waar het netnummer voor geldt
     * - base: xsd:string
     * - maxLength: 200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $plaats;
    /**
     * Constructor method for NetnummerRec
     * @uses NetnummerRec::setNummer()
     * @uses NetnummerRec::setPlaats()
     * @param string $nummer
     * @param string $plaats
     */
    public function __construct($nummer = null, $plaats = null)
    {
        $this
            ->setNummer($nummer)
            ->setPlaats($plaats);
    }
    /**
     * Get nummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNummer()
    {
        return isset($this->nummer) ? $this->nummer : null;
    }
    /**
     * Set nummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nummer
     * @return \RelatieApiV6\StructType\NetnummerRec
     */
    public function setNummer($nummer = null)
    {
        // validation for constraint: string
        if (!is_null($nummer) && !is_string($nummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nummer, true), gettype($nummer)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($nummer) && mb_strlen($nummer) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($nummer)), __LINE__);
        }
        if (is_null($nummer) || (is_array($nummer) && empty($nummer))) {
            unset($this->nummer);
        } else {
            $this->nummer = $nummer;
        }
        return $this;
    }
    /**
     * Get plaats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlaats()
    {
        return isset($this->plaats) ? $this->plaats : null;
    }
    /**
     * Set plaats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plaats
     * @return \RelatieApiV6\StructType\NetnummerRec
     */
    public function setPlaats($plaats = null)
    {
        // validation for constraint: string
        if (!is_null($plaats) && !is_string($plaats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plaats, true), gettype($plaats)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($plaats) && mb_strlen($plaats) > 200) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen($plaats)), __LINE__);
        }
        if (is_null($plaats) || (is_array($plaats) && empty($plaats))) {
            unset($this->plaats);
        } else {
            $this->plaats = $plaats;
        }
        return $this;
    }
}
