<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KenmerkRec StructType
 * Meta information extracted from the WSDL
 * - documentation: Kenmerk
 * @subpackage Structs
 * @date 20240419 package
 */
class KenmerkRec extends AbstractStructBase
{
    /**
     * The kenmerkCode
     * Meta information extracted from the WSDL
     * - documentation: Code van het kenmerk
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $kenmerkCode;
    /**
     * The kenmerkOmschrijving
     * Meta information extracted from the WSDL
     * - documentation: Omschrijving van het kenmerk
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $kenmerkOmschrijving;
    /**
     * The actief
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $actief;
    /**
     * Constructor method for KenmerkRec
     * @uses KenmerkRec::setKenmerkCode()
     * @uses KenmerkRec::setKenmerkOmschrijving()
     * @uses KenmerkRec::setActief()
     * @param string $kenmerkCode
     * @param string $kenmerkOmschrijving
     * @param bool $actief
     */
    public function __construct($kenmerkCode = null, $kenmerkOmschrijving = null, $actief = null)
    {
        $this
            ->setKenmerkCode($kenmerkCode)
            ->setKenmerkOmschrijving($kenmerkOmschrijving)
            ->setActief($actief);
    }
    /**
     * Get kenmerkCode value
     * @return string
     */
    public function getKenmerkCode()
    {
        return $this->kenmerkCode;
    }
    /**
     * Set kenmerkCode value
     * @param string $kenmerkCode
     * @return \RelatieApiV6\StructType\KenmerkRec
     */
    public function setKenmerkCode($kenmerkCode = null)
    {
        // validation for constraint: string
        if (!is_null($kenmerkCode) && !is_string($kenmerkCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kenmerkCode, true), gettype($kenmerkCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($kenmerkCode) && mb_strlen($kenmerkCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($kenmerkCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($kenmerkCode) && mb_strlen($kenmerkCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($kenmerkCode)), __LINE__);
        }
        $this->kenmerkCode = $kenmerkCode;
        return $this;
    }
    /**
     * Get kenmerkOmschrijving value
     * @return string
     */
    public function getKenmerkOmschrijving()
    {
        return $this->kenmerkOmschrijving;
    }
    /**
     * Set kenmerkOmschrijving value
     * @param string $kenmerkOmschrijving
     * @return \RelatieApiV6\StructType\KenmerkRec
     */
    public function setKenmerkOmschrijving($kenmerkOmschrijving = null)
    {
        // validation for constraint: string
        if (!is_null($kenmerkOmschrijving) && !is_string($kenmerkOmschrijving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kenmerkOmschrijving, true), gettype($kenmerkOmschrijving)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($kenmerkOmschrijving) && mb_strlen($kenmerkOmschrijving) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($kenmerkOmschrijving)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($kenmerkOmschrijving) && mb_strlen($kenmerkOmschrijving) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($kenmerkOmschrijving)), __LINE__);
        }
        $this->kenmerkOmschrijving = $kenmerkOmschrijving;
        return $this;
    }
    /**
     * Get actief value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getActief()
    {
        return isset($this->actief) ? $this->actief : null;
    }
    /**
     * Set actief value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $actief
     * @return \RelatieApiV6\StructType\KenmerkRec
     */
    public function setActief($actief = null)
    {
        // validation for constraint: boolean
        if (!is_null($actief) && !is_bool($actief)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($actief, true), gettype($actief)), __LINE__);
        }
        if (is_null($actief) || (is_array($actief) && empty($actief))) {
            unset($this->actief);
        } else {
            $this->actief = $actief;
        }
        return $this;
    }
}
