<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createVerbandRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Maakt een relatieverband tussen twee relaties aan. <br/>Een ingelogde gebruiker (het relatienummer is bekend) wil een verband vastleggen tussen zijn/haar gebruiker en een andere bekende gebruiker. <br/> <br/>Voor de meegegeven
 * relatienummers wordt gecontroleerd of deze bij een verwijderde relatie horen. Als dat het geval is (mogelijk door samengevoegde doublures) wordt het relatienummer van de relatie waaraan de verwijderde relatie gekoppeld is gebruikt en geretourneerd.
 * <br/> <br/><u>Let op:</u> Deze operatie was voorheen onderdeel van de WebApiV4 (createVerbandR1noR2no), maar is verplaatst naar de RelatieApiV6 omdat het relatie-gegevens betreft.
 * @subpackage Structs
 * @date 20240419 package
 */
class CreateVerbandRequest extends AbstractStructBase
{
    /**
     * The relNoRel1
     * Meta information extracted from the WSDL
     * - documentation: Relatienummer van Relatie 1.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relNoRel1;
    /**
     * The relNoRel2
     * Meta information extracted from the WSDL
     * - documentation: Relatienummer van Relatie 2.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relNoRel2;
    /**
     * The verbandCode
     * Meta information extracted from the WSDL
     * - documentation: Code van het te leggen verband. Moet een bestaande code zijn.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $verbandCode;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The canCreate
     * Meta information extracted from the WSDL
     * - documentation: Indicatie of operatie in de testmodus wordt aangeroepen (er wordt dus geen verband aangemaakt) false (Default) = aanmaken, true = testmodus niet aanmaken.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $canCreate;
    /**
     * Constructor method for createVerbandRequest
     * @uses CreateVerbandRequest::setRelNoRel1()
     * @uses CreateVerbandRequest::setRelNoRel2()
     * @uses CreateVerbandRequest::setVerbandCode()
     * @uses CreateVerbandRequest::setRequestTag()
     * @uses CreateVerbandRequest::setCanCreate()
     * @param int $relNoRel1
     * @param int $relNoRel2
     * @param string $verbandCode
     * @param string $requestTag
     * @param bool $canCreate
     */
    public function __construct($relNoRel1 = null, $relNoRel2 = null, $verbandCode = null, $requestTag = null, $canCreate = null)
    {
        $this
            ->setRelNoRel1($relNoRel1)
            ->setRelNoRel2($relNoRel2)
            ->setVerbandCode($verbandCode)
            ->setRequestTag($requestTag)
            ->setCanCreate($canCreate);
    }
    /**
     * Get relNoRel1 value
     * @return int
     */
    public function getRelNoRel1()
    {
        return $this->relNoRel1;
    }
    /**
     * Set relNoRel1 value
     * @param int $relNoRel1
     * @return \RelatieApiV6\StructType\CreateVerbandRequest
     */
    public function setRelNoRel1($relNoRel1 = null)
    {
        // validation for constraint: int
        if (!is_null($relNoRel1) && !(is_int($relNoRel1) || ctype_digit($relNoRel1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNoRel1, true), gettype($relNoRel1)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNoRel1) && mb_strlen(preg_replace('/(\D)/', '', $relNoRel1)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNoRel1, true), mb_strlen(preg_replace('/(\D)/', '', $relNoRel1))), __LINE__);
        }
        $this->relNoRel1 = $relNoRel1;
        return $this;
    }
    /**
     * Get relNoRel2 value
     * @return int
     */
    public function getRelNoRel2()
    {
        return $this->relNoRel2;
    }
    /**
     * Set relNoRel2 value
     * @param int $relNoRel2
     * @return \RelatieApiV6\StructType\CreateVerbandRequest
     */
    public function setRelNoRel2($relNoRel2 = null)
    {
        // validation for constraint: int
        if (!is_null($relNoRel2) && !(is_int($relNoRel2) || ctype_digit($relNoRel2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNoRel2, true), gettype($relNoRel2)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNoRel2) && mb_strlen(preg_replace('/(\D)/', '', $relNoRel2)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNoRel2, true), mb_strlen(preg_replace('/(\D)/', '', $relNoRel2))), __LINE__);
        }
        $this->relNoRel2 = $relNoRel2;
        return $this;
    }
    /**
     * Get verbandCode value
     * @return string
     */
    public function getVerbandCode()
    {
        return $this->verbandCode;
    }
    /**
     * Set verbandCode value
     * @param string $verbandCode
     * @return \RelatieApiV6\StructType\CreateVerbandRequest
     */
    public function setVerbandCode($verbandCode = null)
    {
        // validation for constraint: string
        if (!is_null($verbandCode) && !is_string($verbandCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($verbandCode, true), gettype($verbandCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($verbandCode) && mb_strlen($verbandCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($verbandCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($verbandCode) && mb_strlen($verbandCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($verbandCode)), __LINE__);
        }
        $this->verbandCode = $verbandCode;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV6\StructType\CreateVerbandRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get canCreate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanCreate()
    {
        return isset($this->canCreate) ? $this->canCreate : null;
    }
    /**
     * Set canCreate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canCreate
     * @return \RelatieApiV6\StructType\CreateVerbandRequest
     */
    public function setCanCreate($canCreate = null)
    {
        // validation for constraint: boolean
        if (!is_null($canCreate) && !is_bool($canCreate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canCreate, true), gettype($canCreate)), __LINE__);
        }
        if (is_null($canCreate) || (is_array($canCreate) && empty($canCreate))) {
            unset($this->canCreate);
        } else {
            $this->canCreate = $canCreate;
        }
        return $this;
    }
}
