<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createContactpersoonResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: error103: Er zijn ongeldige voorletters opgegeven. | error101: De opgegeven username is niet uniek | error100: Er voldoen meerdere kandidaten | error72: De opgegeven valutacode is niet gevonden | error71: De opgegeven taalcode is
 * niet gevonden | error54: Op basis van de opgegeven waarde voor codeveld 6 is niets gevonden | error53: Op basis van de opgegeven waarde voor codeveld 5 is niets gevonden | error52: Op basis van de opgegeven waarde voor codeveld 4 is niets gevonden |
 * error51: Op basis van de opgegeven waarde voor codeveld 3 is niets gevonden | error50: Op basis van de opgegeven waarde voor codeveld 2 is niets gevonden | error49: Op basis van de opgegeven waarde voor codeveld 1 is niets gevonden | error48: De
 * opgegeven relatie kortinggroepcode is niet gevonden | error46: De opgegeven plaatsnaam komt niet overeen met de plaatsnaam behorende bij de postcode/huisnummer combinatie | error45: De opgegeven straatnaam komt niet overeen met de straatnaam
 * behorende bij de postcode/huisnummer combinatie | error41: Het opgegeven (NL-) IBAN nummer en de BIC code horen niet bij elkaar | error40: De opgegeven bic code is niet geldig | error39: Het opgegeven IBAN nummer voldoet niet aan de eisen | error38:
 * Bij automatische incasso is een iban nummer verplicht | error37: Het opgegeven bankrekeningnummer voldoet niet aan de 11-proef | error36: Bij automatische incasso is een bankrekeningnummer verplicht | error35: De opgegeven betaalwijze is niet geldig
 * | error22: Er is geen relatienummer voor het bedrijf opgegeven | error20: Het e-mail adres (2) is niet valide | error18: De op basis van het relatienummer bedrijf gevonden relatie is geen bedrijf | error17: Op basis van het relatienummer bedrijf is
 * geen relatie gevonden | error13: Het opgegeven geslacht is niet geldig | error12: De opgegeven geboortedatum is niet geldig | error11: De opgegeven titulatuurcode is niet gevonden | error10: Het opgegeven mobiele telefoonnummer is niet geldig |
 * error9: Het opgegeven telefoonnummer is niet valide | error8: Het e-mail adres (1) is niet valide | error7: Er is geen achternaam opgegeven | error6: Provincie komt niet voor in het opgegeven land | error5: Indien een provincie opgegeven wordt, is
 * een land verplicht | error4: Provincie is niet gevonden | error3: Adres is niet gevonden in de postcodetabel | error2: Adresgegevens zijn niet compleet | error0: De opgegeven landcode is niet gevonden
 * @subpackage Structs
 * @date 20240419 package
 */
class CreateContactpersoonResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The relatienummerContactpersoon
     * Meta information extracted from the WSDL
     * - documentation: Het relatienummer van het aangemaakte contactpersoon
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relatienummerContactpersoon;
    /**
     * The relatienummerBedrijfGebruikt
     * Meta information extracted from the WSDL
     * - documentation: Daadwerkelijk gebruikte relatienummer van het bedrijf
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relatienummerBedrijfGebruikt;
    /**
     * The isNieuweRelatie
     * Meta information extracted from the WSDL
     * - documentation: Is dit een nieuwe (true) of een bestaande (false) relatie?
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $isNieuweRelatie;
    /**
     * Constructor method for createContactpersoonResponse
     * @uses CreateContactpersoonResponse::setRequestTag()
     * @uses CreateContactpersoonResponse::setRelatienummerContactpersoon()
     * @uses CreateContactpersoonResponse::setRelatienummerBedrijfGebruikt()
     * @uses CreateContactpersoonResponse::setIsNieuweRelatie()
     * @param string $requestTag
     * @param int $relatienummerContactpersoon
     * @param int $relatienummerBedrijfGebruikt
     * @param bool $isNieuweRelatie
     */
    public function __construct($requestTag = null, $relatienummerContactpersoon = null, $relatienummerBedrijfGebruikt = null, $isNieuweRelatie = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setRelatienummerContactpersoon($relatienummerContactpersoon)
            ->setRelatienummerBedrijfGebruikt($relatienummerBedrijfGebruikt)
            ->setIsNieuweRelatie($isNieuweRelatie);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV6\StructType\CreateContactpersoonResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get relatienummerContactpersoon value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelatienummerContactpersoon()
    {
        return isset($this->relatienummerContactpersoon) ? $this->relatienummerContactpersoon : null;
    }
    /**
     * Set relatienummerContactpersoon value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relatienummerContactpersoon
     * @return \RelatieApiV6\StructType\CreateContactpersoonResponse
     */
    public function setRelatienummerContactpersoon($relatienummerContactpersoon = null)
    {
        // validation for constraint: int
        if (!is_null($relatienummerContactpersoon) && !(is_int($relatienummerContactpersoon) || ctype_digit($relatienummerContactpersoon))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatienummerContactpersoon, true), gettype($relatienummerContactpersoon)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatienummerContactpersoon) && mb_strlen(preg_replace('/(\D)/', '', $relatienummerContactpersoon)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatienummerContactpersoon, true), mb_strlen(preg_replace('/(\D)/', '', $relatienummerContactpersoon))), __LINE__);
        }
        if (is_null($relatienummerContactpersoon) || (is_array($relatienummerContactpersoon) && empty($relatienummerContactpersoon))) {
            unset($this->relatienummerContactpersoon);
        } else {
            $this->relatienummerContactpersoon = $relatienummerContactpersoon;
        }
        return $this;
    }
    /**
     * Get relatienummerBedrijfGebruikt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelatienummerBedrijfGebruikt()
    {
        return isset($this->relatienummerBedrijfGebruikt) ? $this->relatienummerBedrijfGebruikt : null;
    }
    /**
     * Set relatienummerBedrijfGebruikt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relatienummerBedrijfGebruikt
     * @return \RelatieApiV6\StructType\CreateContactpersoonResponse
     */
    public function setRelatienummerBedrijfGebruikt($relatienummerBedrijfGebruikt = null)
    {
        // validation for constraint: int
        if (!is_null($relatienummerBedrijfGebruikt) && !(is_int($relatienummerBedrijfGebruikt) || ctype_digit($relatienummerBedrijfGebruikt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatienummerBedrijfGebruikt, true), gettype($relatienummerBedrijfGebruikt)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatienummerBedrijfGebruikt) && mb_strlen(preg_replace('/(\D)/', '', $relatienummerBedrijfGebruikt)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatienummerBedrijfGebruikt, true), mb_strlen(preg_replace('/(\D)/', '', $relatienummerBedrijfGebruikt))), __LINE__);
        }
        if (is_null($relatienummerBedrijfGebruikt) || (is_array($relatienummerBedrijfGebruikt) && empty($relatienummerBedrijfGebruikt))) {
            unset($this->relatienummerBedrijfGebruikt);
        } else {
            $this->relatienummerBedrijfGebruikt = $relatienummerBedrijfGebruikt;
        }
        return $this;
    }
    /**
     * Get isNieuweRelatie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsNieuweRelatie()
    {
        return isset($this->isNieuweRelatie) ? $this->isNieuweRelatie : null;
    }
    /**
     * Set isNieuweRelatie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isNieuweRelatie
     * @return \RelatieApiV6\StructType\CreateContactpersoonResponse
     */
    public function setIsNieuweRelatie($isNieuweRelatie = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNieuweRelatie) && !is_bool($isNieuweRelatie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isNieuweRelatie, true), gettype($isNieuweRelatie)), __LINE__);
        }
        if (is_null($isNieuweRelatie) || (is_array($isNieuweRelatie) && empty($isNieuweRelatie))) {
            unset($this->isNieuweRelatie);
        } else {
            $this->isNieuweRelatie = $isNieuweRelatie;
        }
        return $this;
    }
}
