<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createActiviteitResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: error67: Bij het aanmaken van een todo is het opgeven van een gebruiker verplicht | error66: De opgegeven gebruiker is niet actief | error65: De gebruiker is niet gevonden | error59: Het opgegeven activiteittype is niet actief |
 * error58: Het activiteittype is niet gevonden | error16: Op basis van het relatienummer is geen relatie gevonden
 * @subpackage Structs
 * @date 20240419 package
 */
class CreateActiviteitResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The activiteitnummer
     * Meta information extracted from the WSDL
     * - documentation: Nummer van de aangemaakte activiteit
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $activiteitnummer;
    /**
     * Constructor method for createActiviteitResponse
     * @uses CreateActiviteitResponse::setRequestTag()
     * @uses CreateActiviteitResponse::setActiviteitnummer()
     * @param string $requestTag
     * @param int $activiteitnummer
     */
    public function __construct($requestTag = null, $activiteitnummer = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setActiviteitnummer($activiteitnummer);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV6\StructType\CreateActiviteitResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get activiteitnummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getActiviteitnummer()
    {
        return isset($this->activiteitnummer) ? $this->activiteitnummer : null;
    }
    /**
     * Set activiteitnummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $activiteitnummer
     * @return \RelatieApiV6\StructType\CreateActiviteitResponse
     */
    public function setActiviteitnummer($activiteitnummer = null)
    {
        // validation for constraint: int
        if (!is_null($activiteitnummer) && !(is_int($activiteitnummer) || ctype_digit($activiteitnummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($activiteitnummer, true), gettype($activiteitnummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($activiteitnummer) && mb_strlen(preg_replace('/(\D)/', '', $activiteitnummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($activiteitnummer, true), mb_strlen(preg_replace('/(\D)/', '', $activiteitnummer))), __LINE__);
        }
        if (is_null($activiteitnummer) || (is_array($activiteitnummer) && empty($activiteitnummer))) {
            unset($this->activiteitnummer);
        } else {
            $this->activiteitnummer = $activiteitnummer;
        }
        return $this;
    }
}
