<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BedrijfInclContRec StructType
 * Meta information extracted from the WSDL
 * - documentation: Gegevens relatiekaart met gecombineerde bedrijf en contactpersoon gegevens
 * @subpackage Structs
 * @date 20240419 package
 */
class BedrijfInclContRec extends AbstractStructBase
{
    /**
     * The achternaam
     * Meta information extracted from the WSDL
     * - documentation: De achternaam van de persoon
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $achternaam;
    /**
     * The relatienummer
     * Meta information extracted from the WSDL
     * - documentation: Het unieke nummer voor het persoon.<BR>Verplicht in geval van een update.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relatienummer;
    /**
     * The voornaam
     * Meta information extracted from the WSDL
     * - documentation: De voornaam van de persoon
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $voornaam;
    /**
     * The voorletters
     * Meta information extracted from the WSDL
     * - documentation: De voorletters van de persoon
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $voorletters;
    /**
     * The voorvoegsels
     * Meta information extracted from the WSDL
     * - documentation: De voorvoegsels
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $voorvoegsels;
    /**
     * The geslachtsCode
     * Meta information extracted from the WSDL
     * - documentation: De geslachtscode (0=Nvt, 1=Man, 2=Vrouw, 3=Geen)
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $geslachtsCode;
    /**
     * The bedrijfsnaam
     * Meta information extracted from the WSDL
     * - documentation: De bedrijfsnaam
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $bedrijfsnaam;
    /**
     * The afdelingnaam
     * Meta information extracted from the WSDL
     * - documentation: De naam van de afdeling
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $afdelingnaam;
    /**
     * The titulatuurCode
     * Meta information extracted from the WSDL
     * - documentation: Titulatuur code
     * - base: xsd:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $titulatuurCode;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - documentation: E-mail adres 1
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $email;
    /**
     * The email2
     * Meta information extracted from the WSDL
     * - documentation: E-mail adres 2
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $email2;
    /**
     * The email3
     * Meta information extracted from the WSDL
     * - documentation: E-mail adres 3
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $email3;
    /**
     * The email4
     * Meta information extracted from the WSDL
     * - documentation: E-mail adres 4
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $email4;
    /**
     * The telefoonnummer
     * Meta information extracted from the WSDL
     * - documentation: Telefoonnummer van de persoon
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $telefoonnummer;
    /**
     * The telefoonnummerMobiel
     * Meta information extracted from the WSDL
     * - documentation: Telefoonnummer mobiel van de persoon
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $telefoonnummerMobiel;
    /**
     * The faxnummer
     * Meta information extracted from the WSDL
     * - documentation: Het faxnummer van het bedrijf
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $faxnummer;
    /**
     * The website
     * Meta information extracted from the WSDL
     * - documentation: De website van het bedrijf
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $website;
    /**
     * The kvknummer
     * Meta information extracted from the WSDL
     * - documentation: Het Kamer van Koophandel nummer van het bedrijf
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $kvknummer;
    /**
     * The btwnummer
     * Meta information extracted from the WSDL
     * - documentation: Het BTW-nummer van het bedrijf
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $btwnummer;
    /**
     * The btwIndicatie
     * Meta information extracted from the WSDL
     * - documentation: 0=Normaal, 1=Geen BTW/ intra-communaurair, 2=Geen BTW/ buiten EU, 3=BTW verlegd.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 1
     * @var int
     */
    public $btwIndicatie;
    /**
     * The geboortedatum
     * Meta information extracted from the WSDL
     * - documentation: date Geboortedatum van de persoon
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $geboortedatum;
    /**
     * The username
     * Meta information extracted from the WSDL
     * - documentation: De username voor de gebruiker
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $username;
    /**
     * The relatieGroep
     * Meta information extracted from the WSDL
     * - documentation: De relatiegroep van het bedrijf
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\RelatiegroepRec
     */
    public $relatieGroep;
    /**
     * The betaling
     * Meta information extracted from the WSDL
     * - documentation: De betaalgegevens
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\BetaalRec
     */
    public $betaling;
    /**
     * The kredietlimiet
     * Meta information extracted from the WSDL
     * - documentation: De kredietlimiet
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 17
     * @var float
     */
    public $kredietlimiet;
    /**
     * The bestedingsruimte
     * Meta information extracted from the WSDL
     * - documentation: De beschikbare bestedingsruimte
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 17
     * @var float
     */
    public $bestedingsruimte;
    /**
     * The kortinggroepCode
     * Meta information extracted from the WSDL
     * - documentation: De kortinggroep code
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $kortinggroepCode;
    /**
     * The adresBezoek
     * Meta information extracted from the WSDL
     * - documentation: Het bezoekadres van de persoon
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\AdresRec
     */
    public $adresBezoek;
    /**
     * The adresCorrespondentie
     * Meta information extracted from the WSDL
     * - documentation: Het correspondentieadres van de persoon
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\AdresRec
     */
    public $adresCorrespondentie;
    /**
     * The adresPrive
     * Meta information extracted from the WSDL
     * - documentation: Het priveadres van de persoon
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\AdresRec
     */
    public $adresPrive;
    /**
     * The landCode
     * Meta information extracted from the WSDL
     * - documentation: (Iso-) landcode van de persoon
     * - base: xsd:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $landCode;
    /**
     * The provincieCode
     * Meta information extracted from the WSDL
     * - documentation: Provinciecode van de provincie
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $provincieCode;
    /**
     * The onvolledig
     * Meta information extracted from the WSDL
     * - documentation: De gegevens van de relatie zijn onvolledig en moeten aangevuld worden
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $onvolledig;
    /**
     * The vrijeVelden
     * Meta information extracted from the WSDL
     * - documentation: De vrije velden van de relatie
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\VrijeVeldenRec
     */
    public $vrijeVelden;
    /**
     * The taalCode
     * Meta information extracted from the WSDL
     * - documentation: De taalcode van de persoon
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $taalCode;
    /**
     * The valutaCode
     * Meta information extracted from the WSDL
     * - documentation: Valuta waarin de relatie betaalt. Indien leeg, wordt de valuta bepaald adhv de inrichting in Zeno obv landen
     * - base: xsd:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $valutaCode;
    /**
     * Constructor method for BedrijfInclContRec
     * @uses BedrijfInclContRec::setAchternaam()
     * @uses BedrijfInclContRec::setRelatienummer()
     * @uses BedrijfInclContRec::setVoornaam()
     * @uses BedrijfInclContRec::setVoorletters()
     * @uses BedrijfInclContRec::setVoorvoegsels()
     * @uses BedrijfInclContRec::setGeslachtsCode()
     * @uses BedrijfInclContRec::setBedrijfsnaam()
     * @uses BedrijfInclContRec::setAfdelingnaam()
     * @uses BedrijfInclContRec::setTitulatuurCode()
     * @uses BedrijfInclContRec::setEmail()
     * @uses BedrijfInclContRec::setEmail2()
     * @uses BedrijfInclContRec::setEmail3()
     * @uses BedrijfInclContRec::setEmail4()
     * @uses BedrijfInclContRec::setTelefoonnummer()
     * @uses BedrijfInclContRec::setTelefoonnummerMobiel()
     * @uses BedrijfInclContRec::setFaxnummer()
     * @uses BedrijfInclContRec::setWebsite()
     * @uses BedrijfInclContRec::setKvknummer()
     * @uses BedrijfInclContRec::setBtwnummer()
     * @uses BedrijfInclContRec::setBtwIndicatie()
     * @uses BedrijfInclContRec::setGeboortedatum()
     * @uses BedrijfInclContRec::setUsername()
     * @uses BedrijfInclContRec::setRelatieGroep()
     * @uses BedrijfInclContRec::setBetaling()
     * @uses BedrijfInclContRec::setKredietlimiet()
     * @uses BedrijfInclContRec::setBestedingsruimte()
     * @uses BedrijfInclContRec::setKortinggroepCode()
     * @uses BedrijfInclContRec::setAdresBezoek()
     * @uses BedrijfInclContRec::setAdresCorrespondentie()
     * @uses BedrijfInclContRec::setAdresPrive()
     * @uses BedrijfInclContRec::setLandCode()
     * @uses BedrijfInclContRec::setProvincieCode()
     * @uses BedrijfInclContRec::setOnvolledig()
     * @uses BedrijfInclContRec::setVrijeVelden()
     * @uses BedrijfInclContRec::setTaalCode()
     * @uses BedrijfInclContRec::setValutaCode()
     * @param string $achternaam
     * @param int $relatienummer
     * @param string $voornaam
     * @param string $voorletters
     * @param string $voorvoegsels
     * @param string $geslachtsCode
     * @param string $bedrijfsnaam
     * @param string $afdelingnaam
     * @param string $titulatuurCode
     * @param string $email
     * @param string $email2
     * @param string $email3
     * @param string $email4
     * @param string $telefoonnummer
     * @param string $telefoonnummerMobiel
     * @param string $faxnummer
     * @param string $website
     * @param string $kvknummer
     * @param string $btwnummer
     * @param int $btwIndicatie
     * @param string $geboortedatum
     * @param string $username
     * @param \RelatieApiV6\StructType\RelatiegroepRec $relatieGroep
     * @param \RelatieApiV6\StructType\BetaalRec $betaling
     * @param float $kredietlimiet
     * @param float $bestedingsruimte
     * @param string $kortinggroepCode
     * @param \RelatieApiV6\StructType\AdresRec $adresBezoek
     * @param \RelatieApiV6\StructType\AdresRec $adresCorrespondentie
     * @param \RelatieApiV6\StructType\AdresRec $adresPrive
     * @param string $landCode
     * @param string $provincieCode
     * @param bool $onvolledig
     * @param \RelatieApiV6\StructType\VrijeVeldenRec $vrijeVelden
     * @param string $taalCode
     * @param string $valutaCode
     */
    public function __construct($achternaam = null, $relatienummer = null, $voornaam = null, $voorletters = null, $voorvoegsels = null, $geslachtsCode = null, $bedrijfsnaam = null, $afdelingnaam = null, $titulatuurCode = null, $email = null, $email2 = null, $email3 = null, $email4 = null, $telefoonnummer = null, $telefoonnummerMobiel = null, $faxnummer = null, $website = null, $kvknummer = null, $btwnummer = null, $btwIndicatie = null, $geboortedatum = null, $username = null, \RelatieApiV6\StructType\RelatiegroepRec $relatieGroep = null, \RelatieApiV6\StructType\BetaalRec $betaling = null, $kredietlimiet = null, $bestedingsruimte = null, $kortinggroepCode = null, \RelatieApiV6\StructType\AdresRec $adresBezoek = null, \RelatieApiV6\StructType\AdresRec $adresCorrespondentie = null, \RelatieApiV6\StructType\AdresRec $adresPrive = null, $landCode = null, $provincieCode = null, $onvolledig = null, \RelatieApiV6\StructType\VrijeVeldenRec $vrijeVelden = null, $taalCode = null, $valutaCode = null)
    {
        $this
            ->setAchternaam($achternaam)
            ->setRelatienummer($relatienummer)
            ->setVoornaam($voornaam)
            ->setVoorletters($voorletters)
            ->setVoorvoegsels($voorvoegsels)
            ->setGeslachtsCode($geslachtsCode)
            ->setBedrijfsnaam($bedrijfsnaam)
            ->setAfdelingnaam($afdelingnaam)
            ->setTitulatuurCode($titulatuurCode)
            ->setEmail($email)
            ->setEmail2($email2)
            ->setEmail3($email3)
            ->setEmail4($email4)
            ->setTelefoonnummer($telefoonnummer)
            ->setTelefoonnummerMobiel($telefoonnummerMobiel)
            ->setFaxnummer($faxnummer)
            ->setWebsite($website)
            ->setKvknummer($kvknummer)
            ->setBtwnummer($btwnummer)
            ->setBtwIndicatie($btwIndicatie)
            ->setGeboortedatum($geboortedatum)
            ->setUsername($username)
            ->setRelatieGroep($relatieGroep)
            ->setBetaling($betaling)
            ->setKredietlimiet($kredietlimiet)
            ->setBestedingsruimte($bestedingsruimte)
            ->setKortinggroepCode($kortinggroepCode)
            ->setAdresBezoek($adresBezoek)
            ->setAdresCorrespondentie($adresCorrespondentie)
            ->setAdresPrive($adresPrive)
            ->setLandCode($landCode)
            ->setProvincieCode($provincieCode)
            ->setOnvolledig($onvolledig)
            ->setVrijeVelden($vrijeVelden)
            ->setTaalCode($taalCode)
            ->setValutaCode($valutaCode);
    }
    /**
     * Get achternaam value
     * @return string
     */
    public function getAchternaam()
    {
        return $this->achternaam;
    }
    /**
     * Set achternaam value
     * @param string $achternaam
     * @return \RelatieApiV6\StructType\BedrijfInclContRec
     */
    public function setAchternaam($achternaam = null)
    {
        // validation for constraint: string
        if (!is_null($achternaam) && !is_string($achternaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($achternaam, true), gettype($achternaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($achternaam) && mb_strlen($achternaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($achternaam)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($achternaam) && mb_strlen($achternaam) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($achternaam)), __LINE__);
        }
        $this->achternaam = $achternaam;
        return $this;
    }
    /**
     * Get relatienummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelatienummer()
    {
        return isset($this->relatienummer) ? $this->relatienummer : null;
    }
    /**
     * Set relatienummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relatienummer
     * @return \RelatieApiV6\StructType\BedrijfInclContRec
     */
    public function setRelatienummer($relatienummer = null)
    {
        // validation for constraint: int
        if (!is_null($relatienummer) && !(is_int($relatienummer) || ctype_digit($relatienummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatienummer, true), gettype($relatienummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatienummer) && mb_strlen(preg_replace('/(\D)/', '', $relatienummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatienummer, true), mb_strlen(preg_replace('/(\D)/', '', $relatienummer))), __LINE__);
        }
        if (is_null($relatienummer) || (is_array($relatienummer) && empty($relatienummer))) {
            unset($this->relatienummer);
        } else {
            $this->relatienummer = $relatienummer;
        }
        return $this;
    }
    /**
     * Get voornaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVoornaam()
    {
        return isset($this->voornaam) ? $this->voornaam : null;
    }
    /**
     * Set voornaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $voornaam
     * @return \RelatieApiV6\StructType\BedrijfInclContRec
     */
    public function setVoornaam($voornaam = null)
    {
        // validation for constraint: string
        if (!is_null($voornaam) && !is_string($voornaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voornaam, true), gettype($voornaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($voornaam) && mb_strlen($voornaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($voornaam)), __LINE__);
        }
        if (is_null($voornaam) || (is_array($voornaam) && empty($voornaam))) {
            unset($this->voornaam);
        } else {
            $this->voornaam = $voornaam;
        }
        return $this;
    }
    /**
     * Get voorletters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVoorletters()
    {
        return isset($this->voorletters) ? $this->voorletters : null;
    }
    /**
     * Set voorletters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $voorletters
     * @return \RelatieApiV6\StructType\BedrijfInclContRec
     */
    public function setVoorletters($voorletters = null)
    {
        // validation for constraint: string
        if (!is_null($voorletters) && !is_string($voorletters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voorletters, true), gettype($voorletters)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($voorletters) && mb_strlen($voorletters) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($voorletters)), __LINE__);
        }
        if (is_null($voorletters) || (is_array($voorletters) && empty($voorletters))) {
            unset($this->voorletters);
        } else {
            $this->voorletters = $voorletters;
        }
        return $this;
    }
    /**
     * Get voorvoegsels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVoorvoegsels()
    {
        return isset($this->voorvoegsels) ? $this->voorvoegsels : null;
    }
    /**
     * Set voorvoegsels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $voorvoegsels
     * @return \RelatieApiV6\StructType\BedrijfInclContRec
     */
    public function setVoorvoegsels($voorvoegsels = null)
    {
        // validation for constraint: string
        if (!is_null($voorvoegsels) && !is_string($voorvoegsels)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voorvoegsels, true), gettype($voorvoegsels)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($voorvoegsels) && mb_strlen($voorvoegsels) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($voorvoegsels)), __LINE__);
        }
        if (is_null($voorvoegsels) || (is_array($voorvoegsels) && empty($voorvoegsels))) {
            unset($this->voorvoegsels);
        } else {
            $this->voorvoegsels = $voorvoegsels;
        }
        return $this;
    }
    /**
     * Get geslachtsCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeslachtsCode()
    {
        return isset($this->geslachtsCode) ? $this->geslachtsCode : null;
    }
    /**
     * Set geslachtsCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $geslachtsCode
     * @return \RelatieApiV6\StructType\BedrijfInclContRec
     */
    public function setGeslachtsCode($geslachtsCode = null)
    {
        // validation for constraint: string
        if (!is_null($geslachtsCode) && !is_string($geslachtsCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geslachtsCode, true), gettype($geslachtsCode)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($geslachtsCode) && mb_strlen($geslachtsCode) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($geslachtsCode)), __LINE__);
        }
        if (is_null($geslachtsCode) || (is_array($geslachtsCode) && empty($geslachtsCode))) {
            unset($this->geslachtsCode);
        } else {
            $this->geslachtsCode = $geslachtsCode;
        }
        return $this;
    }
    /**
     * Get bedrijfsnaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBedrijfsnaam()
    {
        return isset($this->bedrijfsnaam) ? $this->bedrijfsnaam : null;
    }
    /**
     * Set bedrijfsnaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bedrijfsnaam
     * @return \RelatieApiV6\StructType\BedrijfInclContRec
     */
    public function setBedrijfsnaam($bedrijfsnaam = null)
    {
        // validation for constraint: string
        if (!is_null($bedrijfsnaam) && !is_string($bedrijfsnaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bedrijfsnaam, true), gettype($bedrijfsnaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($bedrijfsnaam) && mb_strlen($bedrijfsnaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($bedrijfsnaam)), __LINE__);
        }
        if (is_null($bedrijfsnaam) || (is_array($bedrijfsnaam) && empty($bedrijfsnaam))) {
            unset($this->bedrijfsnaam);
        } else {
            $this->bedrijfsnaam = $bedrijfsnaam;
        }
        return $this;
    }
    /**
     * Get afdelingnaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAfdelingnaam()
    {
        return isset($this->afdelingnaam) ? $this->afdelingnaam : null;
    }
    /**
     * Set afdelingnaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $afdelingnaam
     * @return \RelatieApiV6\StructType\BedrijfInclContRec
     */
    public function setAfdelingnaam($afdelingnaam = null)
    {
        // validation for constraint: string
        if (!is_null($afdelingnaam) && !is_string($afdelingnaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($afdelingnaam, true), gettype($afdelingnaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($afdelingnaam) && mb_strlen($afdelingnaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($afdelingnaam)), __LINE__);
        }
        if (is_null($afdelingnaam) || (is_array($afdelingnaam) && empty($afdelingnaam))) {
            unset($this->afdelingnaam);
        } else {
            $this->afdelingnaam = $afdelingnaam;
        }
        return $this;
    }
    /**
     * Get titulatuurCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitulatuurCode()
    {
        return isset($this->titulatuurCode) ? $this->titulatuurCode : null;
    }
    /**
     * Set titulatuurCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $titulatuurCode
     * @return \RelatieApiV6\StructType\BedrijfInclContRec
     */
    public function setTitulatuurCode($titulatuurCode = null)
    {
        // validation for constraint: string
        if (!is_null($titulatuurCode) && !is_string($titulatuurCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($titulatuurCode, true), gettype($titulatuurCode)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($titulatuurCode) && mb_strlen($titulatuurCode) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($titulatuurCode)), __LINE__);
        }
        if (is_null($titulatuurCode) || (is_array($titulatuurCode) && empty($titulatuurCode))) {
            unset($this->titulatuurCode);
        } else {
            $this->titulatuurCode = $titulatuurCode;
        }
        return $this;
    }
    /**
     * Get email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->email) ? $this->email : null;
    }
    /**
     * Set email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \RelatieApiV6\StructType\BedrijfInclContRec
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($email) && mb_strlen($email) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->email);
        } else {
            $this->email = $email;
        }
        return $this;
    }
    /**
     * Get email2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail2()
    {
        return isset($this->email2) ? $this->email2 : null;
    }
    /**
     * Set email2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email2
     * @return \RelatieApiV6\StructType\BedrijfInclContRec
     */
    public function setEmail2($email2 = null)
    {
        // validation for constraint: string
        if (!is_null($email2) && !is_string($email2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email2, true), gettype($email2)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($email2) && mb_strlen($email2) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($email2)), __LINE__);
        }
        if (is_null($email2) || (is_array($email2) && empty($email2))) {
            unset($this->email2);
        } else {
            $this->email2 = $email2;
        }
        return $this;
    }
    /**
     * Get email3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail3()
    {
        return isset($this->email3) ? $this->email3 : null;
    }
    /**
     * Set email3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email3
     * @return \RelatieApiV6\StructType\BedrijfInclContRec
     */
    public function setEmail3($email3 = null)
    {
        // validation for constraint: string
        if (!is_null($email3) && !is_string($email3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email3, true), gettype($email3)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($email3) && mb_strlen($email3) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($email3)), __LINE__);
        }
        if (is_null($email3) || (is_array($email3) && empty($email3))) {
            unset($this->email3);
        } else {
            $this->email3 = $email3;
        }
        return $this;
    }
    /**
     * Get email4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail4()
    {
        return isset($this->email4) ? $this->email4 : null;
    }
    /**
     * Set email4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email4
     * @return \RelatieApiV6\StructType\BedrijfInclContRec
     */
    public function setEmail4($email4 = null)
    {
        // validation for constraint: string
        if (!is_null($email4) && !is_string($email4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email4, true), gettype($email4)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($email4) && mb_strlen($email4) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($email4)), __LINE__);
        }
        if (is_null($email4) || (is_array($email4) && empty($email4))) {
            unset($this->email4);
        } else {
            $this->email4 = $email4;
        }
        return $this;
    }
    /**
     * Get telefoonnummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTelefoonnummer()
    {
        return isset($this->telefoonnummer) ? $this->telefoonnummer : null;
    }
    /**
     * Set telefoonnummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $telefoonnummer
     * @return \RelatieApiV6\StructType\BedrijfInclContRec
     */
    public function setTelefoonnummer($telefoonnummer = null)
    {
        // validation for constraint: string
        if (!is_null($telefoonnummer) && !is_string($telefoonnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefoonnummer, true), gettype($telefoonnummer)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($telefoonnummer) && mb_strlen($telefoonnummer) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($telefoonnummer)), __LINE__);
        }
        if (is_null($telefoonnummer) || (is_array($telefoonnummer) && empty($telefoonnummer))) {
            unset($this->telefoonnummer);
        } else {
            $this->telefoonnummer = $telefoonnummer;
        }
        return $this;
    }
    /**
     * Get telefoonnummerMobiel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTelefoonnummerMobiel()
    {
        return isset($this->telefoonnummerMobiel) ? $this->telefoonnummerMobiel : null;
    }
    /**
     * Set telefoonnummerMobiel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $telefoonnummerMobiel
     * @return \RelatieApiV6\StructType\BedrijfInclContRec
     */
    public function setTelefoonnummerMobiel($telefoonnummerMobiel = null)
    {
        // validation for constraint: string
        if (!is_null($telefoonnummerMobiel) && !is_string($telefoonnummerMobiel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefoonnummerMobiel, true), gettype($telefoonnummerMobiel)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($telefoonnummerMobiel) && mb_strlen($telefoonnummerMobiel) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($telefoonnummerMobiel)), __LINE__);
        }
        if (is_null($telefoonnummerMobiel) || (is_array($telefoonnummerMobiel) && empty($telefoonnummerMobiel))) {
            unset($this->telefoonnummerMobiel);
        } else {
            $this->telefoonnummerMobiel = $telefoonnummerMobiel;
        }
        return $this;
    }
    /**
     * Get faxnummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFaxnummer()
    {
        return isset($this->faxnummer) ? $this->faxnummer : null;
    }
    /**
     * Set faxnummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $faxnummer
     * @return \RelatieApiV6\StructType\BedrijfInclContRec
     */
    public function setFaxnummer($faxnummer = null)
    {
        // validation for constraint: string
        if (!is_null($faxnummer) && !is_string($faxnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faxnummer, true), gettype($faxnummer)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($faxnummer) && mb_strlen($faxnummer) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($faxnummer)), __LINE__);
        }
        if (is_null($faxnummer) || (is_array($faxnummer) && empty($faxnummer))) {
            unset($this->faxnummer);
        } else {
            $this->faxnummer = $faxnummer;
        }
        return $this;
    }
    /**
     * Get website value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWebsite()
    {
        return isset($this->website) ? $this->website : null;
    }
    /**
     * Set website value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $website
     * @return \RelatieApiV6\StructType\BedrijfInclContRec
     */
    public function setWebsite($website = null)
    {
        // validation for constraint: string
        if (!is_null($website) && !is_string($website)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($website, true), gettype($website)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($website) && mb_strlen($website) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($website)), __LINE__);
        }
        if (is_null($website) || (is_array($website) && empty($website))) {
            unset($this->website);
        } else {
            $this->website = $website;
        }
        return $this;
    }
    /**
     * Get kvknummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKvknummer()
    {
        return isset($this->kvknummer) ? $this->kvknummer : null;
    }
    /**
     * Set kvknummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kvknummer
     * @return \RelatieApiV6\StructType\BedrijfInclContRec
     */
    public function setKvknummer($kvknummer = null)
    {
        // validation for constraint: string
        if (!is_null($kvknummer) && !is_string($kvknummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kvknummer, true), gettype($kvknummer)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($kvknummer) && mb_strlen($kvknummer) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($kvknummer)), __LINE__);
        }
        if (is_null($kvknummer) || (is_array($kvknummer) && empty($kvknummer))) {
            unset($this->kvknummer);
        } else {
            $this->kvknummer = $kvknummer;
        }
        return $this;
    }
    /**
     * Get btwnummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBtwnummer()
    {
        return isset($this->btwnummer) ? $this->btwnummer : null;
    }
    /**
     * Set btwnummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $btwnummer
     * @return \RelatieApiV6\StructType\BedrijfInclContRec
     */
    public function setBtwnummer($btwnummer = null)
    {
        // validation for constraint: string
        if (!is_null($btwnummer) && !is_string($btwnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($btwnummer, true), gettype($btwnummer)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($btwnummer) && mb_strlen($btwnummer) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($btwnummer)), __LINE__);
        }
        if (is_null($btwnummer) || (is_array($btwnummer) && empty($btwnummer))) {
            unset($this->btwnummer);
        } else {
            $this->btwnummer = $btwnummer;
        }
        return $this;
    }
    /**
     * Get btwIndicatie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBtwIndicatie()
    {
        return isset($this->btwIndicatie) ? $this->btwIndicatie : null;
    }
    /**
     * Set btwIndicatie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $btwIndicatie
     * @return \RelatieApiV6\StructType\BedrijfInclContRec
     */
    public function setBtwIndicatie($btwIndicatie = null)
    {
        // validation for constraint: int
        if (!is_null($btwIndicatie) && !(is_int($btwIndicatie) || ctype_digit($btwIndicatie))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($btwIndicatie, true), gettype($btwIndicatie)), __LINE__);
        }
        // validation for constraint: totalDigits(1)
        if (!is_null($btwIndicatie) && mb_strlen(preg_replace('/(\D)/', '', $btwIndicatie)) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 1 digits, "%d" given', var_export($btwIndicatie, true), mb_strlen(preg_replace('/(\D)/', '', $btwIndicatie))), __LINE__);
        }
        if (is_null($btwIndicatie) || (is_array($btwIndicatie) && empty($btwIndicatie))) {
            unset($this->btwIndicatie);
        } else {
            $this->btwIndicatie = $btwIndicatie;
        }
        return $this;
    }
    /**
     * Get geboortedatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeboortedatum()
    {
        return isset($this->geboortedatum) ? $this->geboortedatum : null;
    }
    /**
     * Set geboortedatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $geboortedatum
     * @return \RelatieApiV6\StructType\BedrijfInclContRec
     */
    public function setGeboortedatum($geboortedatum = null)
    {
        // validation for constraint: string
        if (!is_null($geboortedatum) && !is_string($geboortedatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geboortedatum, true), gettype($geboortedatum)), __LINE__);
        }
        if (is_null($geboortedatum) || (is_array($geboortedatum) && empty($geboortedatum))) {
            unset($this->geboortedatum);
        } else {
            $this->geboortedatum = $geboortedatum;
        }
        return $this;
    }
    /**
     * Get username value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsername()
    {
        return isset($this->username) ? $this->username : null;
    }
    /**
     * Set username value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $username
     * @return \RelatieApiV6\StructType\BedrijfInclContRec
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($username) && mb_strlen($username) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($username)), __LINE__);
        }
        if (is_null($username) || (is_array($username) && empty($username))) {
            unset($this->username);
        } else {
            $this->username = $username;
        }
        return $this;
    }
    /**
     * Get relatieGroep value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\RelatiegroepRec|null
     */
    public function getRelatieGroep()
    {
        return isset($this->relatieGroep) ? $this->relatieGroep : null;
    }
    /**
     * Set relatieGroep value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\RelatiegroepRec $relatieGroep
     * @return \RelatieApiV6\StructType\BedrijfInclContRec
     */
    public function setRelatieGroep(\RelatieApiV6\StructType\RelatiegroepRec $relatieGroep = null)
    {
        if (is_null($relatieGroep) || (is_array($relatieGroep) && empty($relatieGroep))) {
            unset($this->relatieGroep);
        } else {
            $this->relatieGroep = $relatieGroep;
        }
        return $this;
    }
    /**
     * Get betaling value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\BetaalRec|null
     */
    public function getBetaling()
    {
        return isset($this->betaling) ? $this->betaling : null;
    }
    /**
     * Set betaling value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\BetaalRec $betaling
     * @return \RelatieApiV6\StructType\BedrijfInclContRec
     */
    public function setBetaling(\RelatieApiV6\StructType\BetaalRec $betaling = null)
    {
        if (is_null($betaling) || (is_array($betaling) && empty($betaling))) {
            unset($this->betaling);
        } else {
            $this->betaling = $betaling;
        }
        return $this;
    }
    /**
     * Get kredietlimiet value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKredietlimiet()
    {
        return isset($this->kredietlimiet) ? $this->kredietlimiet : null;
    }
    /**
     * Set kredietlimiet value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kredietlimiet
     * @return \RelatieApiV6\StructType\BedrijfInclContRec
     */
    public function setKredietlimiet($kredietlimiet = null)
    {
        // validation for constraint: float
        if (!is_null($kredietlimiet) && !(is_float($kredietlimiet) || is_numeric($kredietlimiet))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kredietlimiet, true), gettype($kredietlimiet)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($kredietlimiet) && mb_strlen(mb_substr($kredietlimiet, false !== mb_strpos($kredietlimiet, '.') ? mb_strpos($kredietlimiet, '.') + 1 : mb_strlen($kredietlimiet))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($kredietlimiet, true), mb_strlen(mb_substr($kredietlimiet, mb_strpos($kredietlimiet, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($kredietlimiet) && mb_strlen(preg_replace('/(\D)/', '', $kredietlimiet)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($kredietlimiet, true), mb_strlen(preg_replace('/(\D)/', '', $kredietlimiet))), __LINE__);
        }
        if (is_null($kredietlimiet) || (is_array($kredietlimiet) && empty($kredietlimiet))) {
            unset($this->kredietlimiet);
        } else {
            $this->kredietlimiet = $kredietlimiet;
        }
        return $this;
    }
    /**
     * Get bestedingsruimte value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBestedingsruimte()
    {
        return isset($this->bestedingsruimte) ? $this->bestedingsruimte : null;
    }
    /**
     * Set bestedingsruimte value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $bestedingsruimte
     * @return \RelatieApiV6\StructType\BedrijfInclContRec
     */
    public function setBestedingsruimte($bestedingsruimte = null)
    {
        // validation for constraint: float
        if (!is_null($bestedingsruimte) && !(is_float($bestedingsruimte) || is_numeric($bestedingsruimte))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bestedingsruimte, true), gettype($bestedingsruimte)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($bestedingsruimte) && mb_strlen(mb_substr($bestedingsruimte, false !== mb_strpos($bestedingsruimte, '.') ? mb_strpos($bestedingsruimte, '.') + 1 : mb_strlen($bestedingsruimte))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($bestedingsruimte, true), mb_strlen(mb_substr($bestedingsruimte, mb_strpos($bestedingsruimte, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($bestedingsruimte) && mb_strlen(preg_replace('/(\D)/', '', $bestedingsruimte)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($bestedingsruimte, true), mb_strlen(preg_replace('/(\D)/', '', $bestedingsruimte))), __LINE__);
        }
        if (is_null($bestedingsruimte) || (is_array($bestedingsruimte) && empty($bestedingsruimte))) {
            unset($this->bestedingsruimte);
        } else {
            $this->bestedingsruimte = $bestedingsruimte;
        }
        return $this;
    }
    /**
     * Get kortinggroepCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKortinggroepCode()
    {
        return isset($this->kortinggroepCode) ? $this->kortinggroepCode : null;
    }
    /**
     * Set kortinggroepCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kortinggroepCode
     * @return \RelatieApiV6\StructType\BedrijfInclContRec
     */
    public function setKortinggroepCode($kortinggroepCode = null)
    {
        // validation for constraint: string
        if (!is_null($kortinggroepCode) && !is_string($kortinggroepCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kortinggroepCode, true), gettype($kortinggroepCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($kortinggroepCode) && mb_strlen($kortinggroepCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($kortinggroepCode)), __LINE__);
        }
        if (is_null($kortinggroepCode) || (is_array($kortinggroepCode) && empty($kortinggroepCode))) {
            unset($this->kortinggroepCode);
        } else {
            $this->kortinggroepCode = $kortinggroepCode;
        }
        return $this;
    }
    /**
     * Get adresBezoek value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\AdresRec|null
     */
    public function getAdresBezoek()
    {
        return isset($this->adresBezoek) ? $this->adresBezoek : null;
    }
    /**
     * Set adresBezoek value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\AdresRec $adresBezoek
     * @return \RelatieApiV6\StructType\BedrijfInclContRec
     */
    public function setAdresBezoek(\RelatieApiV6\StructType\AdresRec $adresBezoek = null)
    {
        if (is_null($adresBezoek) || (is_array($adresBezoek) && empty($adresBezoek))) {
            unset($this->adresBezoek);
        } else {
            $this->adresBezoek = $adresBezoek;
        }
        return $this;
    }
    /**
     * Get adresCorrespondentie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\AdresRec|null
     */
    public function getAdresCorrespondentie()
    {
        return isset($this->adresCorrespondentie) ? $this->adresCorrespondentie : null;
    }
    /**
     * Set adresCorrespondentie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\AdresRec $adresCorrespondentie
     * @return \RelatieApiV6\StructType\BedrijfInclContRec
     */
    public function setAdresCorrespondentie(\RelatieApiV6\StructType\AdresRec $adresCorrespondentie = null)
    {
        if (is_null($adresCorrespondentie) || (is_array($adresCorrespondentie) && empty($adresCorrespondentie))) {
            unset($this->adresCorrespondentie);
        } else {
            $this->adresCorrespondentie = $adresCorrespondentie;
        }
        return $this;
    }
    /**
     * Get adresPrive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\AdresRec|null
     */
    public function getAdresPrive()
    {
        return isset($this->adresPrive) ? $this->adresPrive : null;
    }
    /**
     * Set adresPrive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\AdresRec $adresPrive
     * @return \RelatieApiV6\StructType\BedrijfInclContRec
     */
    public function setAdresPrive(\RelatieApiV6\StructType\AdresRec $adresPrive = null)
    {
        if (is_null($adresPrive) || (is_array($adresPrive) && empty($adresPrive))) {
            unset($this->adresPrive);
        } else {
            $this->adresPrive = $adresPrive;
        }
        return $this;
    }
    /**
     * Get landCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLandCode()
    {
        return isset($this->landCode) ? $this->landCode : null;
    }
    /**
     * Set landCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $landCode
     * @return \RelatieApiV6\StructType\BedrijfInclContRec
     */
    public function setLandCode($landCode = null)
    {
        // validation for constraint: string
        if (!is_null($landCode) && !is_string($landCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($landCode, true), gettype($landCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($landCode) && mb_strlen($landCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($landCode)), __LINE__);
        }
        if (is_null($landCode) || (is_array($landCode) && empty($landCode))) {
            unset($this->landCode);
        } else {
            $this->landCode = $landCode;
        }
        return $this;
    }
    /**
     * Get provincieCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProvincieCode()
    {
        return isset($this->provincieCode) ? $this->provincieCode : null;
    }
    /**
     * Set provincieCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $provincieCode
     * @return \RelatieApiV6\StructType\BedrijfInclContRec
     */
    public function setProvincieCode($provincieCode = null)
    {
        // validation for constraint: string
        if (!is_null($provincieCode) && !is_string($provincieCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provincieCode, true), gettype($provincieCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($provincieCode) && mb_strlen($provincieCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($provincieCode)), __LINE__);
        }
        if (is_null($provincieCode) || (is_array($provincieCode) && empty($provincieCode))) {
            unset($this->provincieCode);
        } else {
            $this->provincieCode = $provincieCode;
        }
        return $this;
    }
    /**
     * Get onvolledig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOnvolledig()
    {
        return isset($this->onvolledig) ? $this->onvolledig : null;
    }
    /**
     * Set onvolledig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $onvolledig
     * @return \RelatieApiV6\StructType\BedrijfInclContRec
     */
    public function setOnvolledig($onvolledig = null)
    {
        // validation for constraint: boolean
        if (!is_null($onvolledig) && !is_bool($onvolledig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onvolledig, true), gettype($onvolledig)), __LINE__);
        }
        if (is_null($onvolledig) || (is_array($onvolledig) && empty($onvolledig))) {
            unset($this->onvolledig);
        } else {
            $this->onvolledig = $onvolledig;
        }
        return $this;
    }
    /**
     * Get vrijeVelden value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\VrijeVeldenRec|null
     */
    public function getVrijeVelden()
    {
        return isset($this->vrijeVelden) ? $this->vrijeVelden : null;
    }
    /**
     * Set vrijeVelden value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\VrijeVeldenRec $vrijeVelden
     * @return \RelatieApiV6\StructType\BedrijfInclContRec
     */
    public function setVrijeVelden(\RelatieApiV6\StructType\VrijeVeldenRec $vrijeVelden = null)
    {
        if (is_null($vrijeVelden) || (is_array($vrijeVelden) && empty($vrijeVelden))) {
            unset($this->vrijeVelden);
        } else {
            $this->vrijeVelden = $vrijeVelden;
        }
        return $this;
    }
    /**
     * Get taalCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaalCode()
    {
        return isset($this->taalCode) ? $this->taalCode : null;
    }
    /**
     * Set taalCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taalCode
     * @return \RelatieApiV6\StructType\BedrijfInclContRec
     */
    public function setTaalCode($taalCode = null)
    {
        // validation for constraint: string
        if (!is_null($taalCode) && !is_string($taalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taalCode, true), gettype($taalCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($taalCode) && mb_strlen($taalCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($taalCode)), __LINE__);
        }
        if (is_null($taalCode) || (is_array($taalCode) && empty($taalCode))) {
            unset($this->taalCode);
        } else {
            $this->taalCode = $taalCode;
        }
        return $this;
    }
    /**
     * Get valutaCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValutaCode()
    {
        return isset($this->valutaCode) ? $this->valutaCode : null;
    }
    /**
     * Set valutaCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $valutaCode
     * @return \RelatieApiV6\StructType\BedrijfInclContRec
     */
    public function setValutaCode($valutaCode = null)
    {
        // validation for constraint: string
        if (!is_null($valutaCode) && !is_string($valutaCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valutaCode, true), gettype($valutaCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($valutaCode) && mb_strlen($valutaCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($valutaCode)), __LINE__);
        }
        if (is_null($valutaCode) || (is_array($valutaCode) && empty($valutaCode))) {
            unset($this->valutaCode);
        } else {
            $this->valutaCode = $valutaCode;
        }
        return $this;
    }
}
