<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Afdelingtable StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met afdelingen bij een bedrijf
 * @subpackage Structs
 * @date 20240419 package
 */
class Afdelingtable extends AbstractStructBase
{
    /**
     * The afdeling
     * Meta information extracted from the WSDL
     * - documentation: afdelingen
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \RelatieApiV6\StructType\AfdelinginfoRec[]
     */
    public $afdeling;
    /**
     * Constructor method for Afdelingtable
     * @uses Afdelingtable::setAfdeling()
     * @param \RelatieApiV6\StructType\AfdelinginfoRec[] $afdeling
     */
    public function __construct(array $afdeling = array())
    {
        $this
            ->setAfdeling($afdeling);
    }
    /**
     * Get afdeling value
     * @return \RelatieApiV6\StructType\AfdelinginfoRec[]|null
     */
    public function getAfdeling()
    {
        return $this->afdeling;
    }
    /**
     * This method is responsible for validating the values passed to the setAfdeling method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAfdeling method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAfdelingForArrayConstraintsFromSetAfdeling(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $afdelingtableAfdelingItem) {
            // validation for constraint: itemType
            if (!$afdelingtableAfdelingItem instanceof \RelatieApiV6\StructType\AfdelinginfoRec) {
                $invalidValues[] = is_object($afdelingtableAfdelingItem) ? get_class($afdelingtableAfdelingItem) : sprintf('%s(%s)', gettype($afdelingtableAfdelingItem), var_export($afdelingtableAfdelingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The afdeling property can only contain items of type \RelatieApiV6\StructType\AfdelinginfoRec, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set afdeling value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV6\StructType\AfdelinginfoRec[] $afdeling
     * @return \RelatieApiV6\StructType\Afdelingtable
     */
    public function setAfdeling(array $afdeling = array())
    {
        // validation for constraint: array
        if ('' !== ($afdelingArrayErrorMessage = self::validateAfdelingForArrayConstraintsFromSetAfdeling($afdeling))) {
            throw new \InvalidArgumentException($afdelingArrayErrorMessage, __LINE__);
        }
        $this->afdeling = $afdeling;
        return $this;
    }
    /**
     * Add item to afdeling value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV6\StructType\AfdelinginfoRec $item
     * @return \RelatieApiV6\StructType\Afdelingtable
     */
    public function addToAfdeling(\RelatieApiV6\StructType\AfdelinginfoRec $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \RelatieApiV6\StructType\AfdelinginfoRec) {
            throw new \InvalidArgumentException(sprintf('The afdeling property can only contain items of type \RelatieApiV6\StructType\AfdelinginfoRec, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->afdeling[] = $item;
        return $this;
    }
}
