<?php

namespace RelatieApiV6\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 * @date 20240419 package
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named deleteContPersoonNrContact
     * Meta information extracted from the WSDL
     * - documentation: Haalt de verwijzing van een contactpersoon naar een bedrijf leeg (en wordt dus een privÃ©persoon)error15: Er is geen relatienummer opgegevenerror16: Op basis van het relatienummer is geen relatie gevondenerror17: Op basis van het
     * relatienummer bedrijf is geen relatie gevondenerror19: Persoon is als contactpersoon aan een ander bedrijf gekoppeld dan relatienummer_bestand_bedrijferror20: De opgegeven persoon is reeds een privÃ© persoon
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\DeleteContPersoonNrContactRequest $request_parameters
     * @return \RelatieApiV6\StructType\DeleteContPersoonNrContactResponse|bool
     */
    public function deleteContPersoonNrContact(\RelatieApiV6\StructType\DeleteContPersoonNrContactRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteContPersoonNrContact($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteBic
     * Meta information extracted from the WSDL
     * - documentation: Verwijderen van een gekoppelde Bic code bij een relatieerror27: Er is geen unieke sleutel voor de koppeling van relatie aan biccode opgegevenerror28: De opgegeven koppeling van relatie aan biccode is niet gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\DeleteBicRequest $request_parameters
     * @return \RelatieApiV6\StructType\DeleteBicResponse|bool
     */
    public function deleteBic(\RelatieApiV6\StructType\DeleteBicRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteBic($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteFunctie
     * Meta information extracted from the WSDL
     * - documentation: Verwijderen van een gekoppelde functie bij een relatieerror33: Er is geen unieke sleutel voor de koppeling van relatie aan functie opgegevenerror34: De opgegeven koppeling van relatie aan functie is niet gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\DeleteFunctieRequest $request_parameters
     * @return \RelatieApiV6\StructType\DeleteFunctieResponse|bool
     */
    public function deleteFunctie(\RelatieApiV6\StructType\DeleteFunctieRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteFunctie($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteVerband
     * Meta information extracted from the WSDL
     * - documentation: Verwijdert een relatieverband tussen twee relaties. <br/> <br/><u>Let op:</u> Deze operatie was voorheen onderdeel van de WebApiV4, maar is verplaatst naar de RelatieApiV6 omdat het relatie-gegevens betreft.error171: Er is geen
     * verbandnummer opgegevenerror172: Het verbandnummer is niet gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\DeleteVerbandRequest $request_parameters
     * @return \RelatieApiV6\StructType\DeleteVerbandResponse|bool
     */
    public function deleteVerband(\RelatieApiV6\StructType\DeleteVerbandRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteVerband($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteKlantKenmerk
     * Meta information extracted from the WSDL
     * - documentation: Verwijdert een kenmerk bij een klant. Op basis van een kenmerknummer kan een kenmerk bij een relatie weer verwijderd worden. Het kenmerknummer komt terug bij het aanmaken van een kenmerk (createKenmerk), kan opgehaald worden via
     * getKlantKenmerk (voor Ã©Ã©n kenmerk) of kan opgevraagd worden via getKenmerkInfo. <br/> <br/><u>Let op:</u> Deze operatie was voorheen onderdeel van de WebApiV4, maar is verplaatst naar de RelatieApiV6 omdat het relatie-gegevens betreft.error176:
     * Er is geen relatie-kenmerk sleutel opgegevenerror177: Het relatie-kenmerk is niet gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\DeleteKlantKenmerkRequest $request_parameters
     * @return \RelatieApiV6\StructType\DeleteKlantKenmerkResponse|bool
     */
    public function deleteKlantKenmerk(\RelatieApiV6\StructType\DeleteKlantKenmerkRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteKlantKenmerk($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \RelatieApiV6\StructType\DeleteBicResponse|\RelatieApiV6\StructType\DeleteContPersoonNrContactResponse|\RelatieApiV6\StructType\DeleteFunctieResponse|\RelatieApiV6\StructType\DeleteKlantKenmerkResponse|\RelatieApiV6\StructType\DeleteVerbandResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
