<?php

namespace InGeKurs\KursStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Unterrichtszeit KursStructType
 * @subpackage Structs
 */
class Unterrichtszeit extends AbstractStructBase
{
    /**
     * The wochentag
     * Meta information extracted from the WSDL
     * - documentation: Codeliste 015.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $wochentag;
    /**
     * The von
     * Meta information extracted from the WSDL
     * - documentation: Uhrzeit im Format HH:MM.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $von;
    /**
     * The bis
     * Meta information extracted from the WSDL
     * - documentation: Uhrzeit im Format HH:MM.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $bis;
    /**
     * The stundenzahl
     * Meta information extracted from the WSDL
     * - documentation: Anzahl der Unterrrichtsstunden an diesem Tag. Die Wochenstunden werden automatisch berechnet.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $stundenzahl;
    /**
     * The pauseVon
     * Meta information extracted from the WSDL
     * - documentation: Uhrzeit im Format HH:MM.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pauseVon;
    /**
     * The pauseBis
     * Meta information extracted from the WSDL
     * - documentation: Uhrzeit im Format HH:MM.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pauseBis;
    /**
     * Constructor method for Unterrichtszeit
     * @uses Unterrichtszeit::setWochentag()
     * @uses Unterrichtszeit::setVon()
     * @uses Unterrichtszeit::setBis()
     * @uses Unterrichtszeit::setStundenzahl()
     * @uses Unterrichtszeit::setPauseVon()
     * @uses Unterrichtszeit::setPauseBis()
     * @param string $wochentag
     * @param string $von
     * @param string $bis
     * @param int $stundenzahl
     * @param string $pauseVon
     * @param string $pauseBis
     */
    public function __construct($wochentag = null, $von = null, $bis = null, $stundenzahl = null, $pauseVon = null, $pauseBis = null)
    {
        $this
            ->setWochentag($wochentag)
            ->setVon($von)
            ->setBis($bis)
            ->setStundenzahl($stundenzahl)
            ->setPauseVon($pauseVon)
            ->setPauseBis($pauseBis);
    }
    /**
     * Get wochentag value
     * @return string
     */
    public function getWochentag()
    {
        return $this->wochentag;
    }
    /**
     * Set wochentag value
     * @param string $wochentag
     * @return \InGeKurs\KursStructType\Unterrichtszeit
     */
    public function setWochentag($wochentag = null)
    {
        // validation for constraint: string
        if (!is_null($wochentag) && !is_string($wochentag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wochentag, true), gettype($wochentag)), __LINE__);
        }
        $this->wochentag = $wochentag;
        return $this;
    }
    /**
     * Get von value
     * @return string
     */
    public function getVon()
    {
        return $this->von;
    }
    /**
     * Set von value
     * @param string $von
     * @return \InGeKurs\KursStructType\Unterrichtszeit
     */
    public function setVon($von = null)
    {
        // validation for constraint: string
        if (!is_null($von) && !is_string($von)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($von, true), gettype($von)), __LINE__);
        }
        $this->von = $von;
        return $this;
    }
    /**
     * Get bis value
     * @return string
     */
    public function getBis()
    {
        return $this->bis;
    }
    /**
     * Set bis value
     * @param string $bis
     * @return \InGeKurs\KursStructType\Unterrichtszeit
     */
    public function setBis($bis = null)
    {
        // validation for constraint: string
        if (!is_null($bis) && !is_string($bis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bis, true), gettype($bis)), __LINE__);
        }
        $this->bis = $bis;
        return $this;
    }
    /**
     * Get stundenzahl value
     * @return int
     */
    public function getStundenzahl()
    {
        return $this->stundenzahl;
    }
    /**
     * Set stundenzahl value
     * @param int $stundenzahl
     * @return \InGeKurs\KursStructType\Unterrichtszeit
     */
    public function setStundenzahl($stundenzahl = null)
    {
        // validation for constraint: int
        if (!is_null($stundenzahl) && !(is_int($stundenzahl) || ctype_digit($stundenzahl))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($stundenzahl, true), gettype($stundenzahl)), __LINE__);
        }
        $this->stundenzahl = $stundenzahl;
        return $this;
    }
    /**
     * Get pauseVon value
     * @return string|null
     */
    public function getPauseVon()
    {
        return $this->pauseVon;
    }
    /**
     * Set pauseVon value
     * @param string $pauseVon
     * @return \InGeKurs\KursStructType\Unterrichtszeit
     */
    public function setPauseVon($pauseVon = null)
    {
        // validation for constraint: string
        if (!is_null($pauseVon) && !is_string($pauseVon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pauseVon, true), gettype($pauseVon)), __LINE__);
        }
        $this->pauseVon = $pauseVon;
        return $this;
    }
    /**
     * Get pauseBis value
     * @return string|null
     */
    public function getPauseBis()
    {
        return $this->pauseBis;
    }
    /**
     * Set pauseBis value
     * @param string $pauseBis
     * @return \InGeKurs\KursStructType\Unterrichtszeit
     */
    public function setPauseBis($pauseBis = null)
    {
        // validation for constraint: string
        if (!is_null($pauseBis) && !is_string($pauseBis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pauseBis, true), gettype($pauseBis)), __LINE__);
        }
        $this->pauseBis = $pauseBis;
        return $this;
    }
}
