<?php

namespace InGeKurs\KursStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Transaktionssteuerung KursStructType
 * @subpackage Structs
 */
class Transaktionssteuerung extends AbstractStructBase
{
    /**
     * The hersteller
     * Meta information extracted from the WSDL
     * - documentation: Bezeichnet den Hersteller des Produkts. Sollte nicht länger als 50 Zeichen sein.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $hersteller;
    /**
     * The produkt
     * Meta information extracted from the WSDL
     * - documentation: Der Name der Software mit der diese Anfrage erzeugt wurde. Sollte nicht länger als 50 Zeichen sein.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $produkt;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - documentation: Die eingesetzte Version des Produkts. Sollte nicht länger als 20 Zeichen sein.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $version;
    /**
     * The benutzer
     * Meta information extracted from the WSDL
     * - documentation: Der Name des Benutzers, in dessen Auftrag der Serviceaufruf erfolgt. Muss konsistent mit den Authentifizierungsdaten sein, also derzeit identisch mit dem per WSSE gesendeten Benutzernamen.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $benutzer;
    /**
     * The mandant
     * Meta information extracted from the WSDL
     * - documentation: Die Bezeichnung der Organisation, in dessen Auftrag der Serviceaufruf erfolgt. Muss konsistent zu den Authentifizierungsdaten sein, der authentifizierte Benutzer muss also für diese Organisation registriert sein.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $mandant;
    /**
     * The fortzusetzendeTransaktion
     * Meta information extracted from the WSDL
     * - documentation: Die Kennung der Transaktion, die fortgesetzt werden soll. Wenn nicht gesetzt wird eine neue Transkation gestartet.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $fortzusetzendeTransaktion;
    /**
     * The nurSynchron
     * Meta information extracted from the WSDL
     * - documentation: Wenn ja, wird keine asynchrone Verarbeitung durchgeführt, selbst wenn das Ergebnis nicht sofort bestimmt werden kann. In diesem Fall wird nur eine Fehlermeldung erzeugt. Sinnvoll für interaktive Abfragen. Wenn nicht gesetzt, wird
     * nein angenommen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $nurSynchron;
    /**
     * The nurValidieren
     * Meta information extracted from the WSDL
     * - documentation: Wenn ja werden die Daten nur geprüft und nicht gespeichert. Wenn nicht gesetzt wird nein angenommen. Kann z.B. zur Vorprüfung einer Kursbeginnmeldung eingesetzt werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $nurValidieren;
    /**
     * Constructor method for Transaktionssteuerung
     * @uses Transaktionssteuerung::setHersteller()
     * @uses Transaktionssteuerung::setProdukt()
     * @uses Transaktionssteuerung::setVersion()
     * @uses Transaktionssteuerung::setBenutzer()
     * @uses Transaktionssteuerung::setMandant()
     * @uses Transaktionssteuerung::setFortzusetzendeTransaktion()
     * @uses Transaktionssteuerung::setNurSynchron()
     * @uses Transaktionssteuerung::setNurValidieren()
     * @param string $hersteller
     * @param string $produkt
     * @param string $version
     * @param string $benutzer
     * @param string $mandant
     * @param string $fortzusetzendeTransaktion
     * @param bool $nurSynchron
     * @param bool $nurValidieren
     */
    public function __construct($hersteller = null, $produkt = null, $version = null, $benutzer = null, $mandant = null, $fortzusetzendeTransaktion = null, $nurSynchron = null, $nurValidieren = null)
    {
        $this
            ->setHersteller($hersteller)
            ->setProdukt($produkt)
            ->setVersion($version)
            ->setBenutzer($benutzer)
            ->setMandant($mandant)
            ->setFortzusetzendeTransaktion($fortzusetzendeTransaktion)
            ->setNurSynchron($nurSynchron)
            ->setNurValidieren($nurValidieren);
    }
    /**
     * Get hersteller value
     * @return string
     */
    public function getHersteller()
    {
        return $this->hersteller;
    }
    /**
     * Set hersteller value
     * @param string $hersteller
     * @return \InGeKurs\KursStructType\Transaktionssteuerung
     */
    public function setHersteller($hersteller = null)
    {
        // validation for constraint: string
        if (!is_null($hersteller) && !is_string($hersteller)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hersteller, true), gettype($hersteller)), __LINE__);
        }
        $this->hersteller = $hersteller;
        return $this;
    }
    /**
     * Get produkt value
     * @return string
     */
    public function getProdukt()
    {
        return $this->produkt;
    }
    /**
     * Set produkt value
     * @param string $produkt
     * @return \InGeKurs\KursStructType\Transaktionssteuerung
     */
    public function setProdukt($produkt = null)
    {
        // validation for constraint: string
        if (!is_null($produkt) && !is_string($produkt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($produkt, true), gettype($produkt)), __LINE__);
        }
        $this->produkt = $produkt;
        return $this;
    }
    /**
     * Get version value
     * @return string
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \InGeKurs\KursStructType\Transaktionssteuerung
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Get benutzer value
     * @return string
     */
    public function getBenutzer()
    {
        return $this->benutzer;
    }
    /**
     * Set benutzer value
     * @param string $benutzer
     * @return \InGeKurs\KursStructType\Transaktionssteuerung
     */
    public function setBenutzer($benutzer = null)
    {
        // validation for constraint: string
        if (!is_null($benutzer) && !is_string($benutzer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($benutzer, true), gettype($benutzer)), __LINE__);
        }
        $this->benutzer = $benutzer;
        return $this;
    }
    /**
     * Get mandant value
     * @return string
     */
    public function getMandant()
    {
        return $this->mandant;
    }
    /**
     * Set mandant value
     * @param string $mandant
     * @return \InGeKurs\KursStructType\Transaktionssteuerung
     */
    public function setMandant($mandant = null)
    {
        // validation for constraint: string
        if (!is_null($mandant) && !is_string($mandant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mandant, true), gettype($mandant)), __LINE__);
        }
        $this->mandant = $mandant;
        return $this;
    }
    /**
     * Get fortzusetzendeTransaktion value
     * @return string|null
     */
    public function getFortzusetzendeTransaktion()
    {
        return $this->fortzusetzendeTransaktion;
    }
    /**
     * Set fortzusetzendeTransaktion value
     * @param string $fortzusetzendeTransaktion
     * @return \InGeKurs\KursStructType\Transaktionssteuerung
     */
    public function setFortzusetzendeTransaktion($fortzusetzendeTransaktion = null)
    {
        // validation for constraint: string
        if (!is_null($fortzusetzendeTransaktion) && !is_string($fortzusetzendeTransaktion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fortzusetzendeTransaktion, true), gettype($fortzusetzendeTransaktion)), __LINE__);
        }
        $this->fortzusetzendeTransaktion = $fortzusetzendeTransaktion;
        return $this;
    }
    /**
     * Get nurSynchron value
     * @return bool|null
     */
    public function getNurSynchron()
    {
        return $this->nurSynchron;
    }
    /**
     * Set nurSynchron value
     * @param bool $nurSynchron
     * @return \InGeKurs\KursStructType\Transaktionssteuerung
     */
    public function setNurSynchron($nurSynchron = null)
    {
        // validation for constraint: boolean
        if (!is_null($nurSynchron) && !is_bool($nurSynchron)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nurSynchron, true), gettype($nurSynchron)), __LINE__);
        }
        $this->nurSynchron = $nurSynchron;
        return $this;
    }
    /**
     * Get nurValidieren value
     * @return bool|null
     */
    public function getNurValidieren()
    {
        return $this->nurValidieren;
    }
    /**
     * Set nurValidieren value
     * @param bool $nurValidieren
     * @return \InGeKurs\KursStructType\Transaktionssteuerung
     */
    public function setNurValidieren($nurValidieren = null)
    {
        // validation for constraint: boolean
        if (!is_null($nurValidieren) && !is_bool($nurValidieren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nurValidieren, true), gettype($nurValidieren)), __LINE__);
        }
        $this->nurValidieren = $nurValidieren;
        return $this;
    }
}
