<?php

namespace InGeKurs\KursStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Kursabschnittsbeginn KursStructType
 * @subpackage Structs
 */
class Kursabschnittsbeginn extends AbstractStructBase
{
    /**
     * The kursdurchfuehrung
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \InGeKurs\KursStructType\KursVerlauf
     */
    public $kursdurchfuehrung;
    /**
     * The aktuellerKursabschnitt
     * Meta information extracted from the WSDL
     * - documentation: Angaben zum aktuell begonnen Kursabschnitt.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \InGeKurs\KursStructType\Abschnitt
     */
    public $aktuellerKursabschnitt;
    /**
     * The kursleiter
     * Meta information extracted from the WSDL
     * - documentation: Liste der Lehrkräfte, die diesen Kurs bzw. Kursabschnitt unterrichten. Eine erfolgreiche Meldung erfordert, dass mindestens eine Lehrkraft mit der notwendigen Zulassung identifizierbar ist.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \InGeKurs\KursStructType\LehrkraftIdentifikation[]
     */
    public $kursleiter;
    /**
     * The gesamteAnzahlTN
     * Meta information extracted from the WSDL
     * - documentation: Gesamtzahl der Teilnehmer des Kurses inklusive der nicht durch das BAMF geförderten Teilnehmer. Muss mindestens so groß wie die Zahl der in der Teilnehmerliste gemeldeten geförderten Teilnehmer sein.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $gesamteAnzahlTN;
    /**
     * The kursortAenderungen
     * Meta information extracted from the WSDL
     * - documentation: Angaben zu bereits erfolgten Änderungen des Kursorts in diesem Kursabschnitt.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \InGeKurs\KursStructType\KursortAenderung[]
     */
    public $kursortAenderungen;
    /**
     * The lehrmittel
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \InGeKurs\KursStructType\LehrmittelIdentifikation[]
     */
    public $lehrmittel;
    /**
     * The vorzeitigesKursende
     * Meta information extracted from the WSDL
     * - documentation: Codeliste 816. Wird genutzt um zu melden, dass deraktuelle Kursabschnitt voraussichtlich der letzte Kursabschnitt sein wird bzw. tatsächlich der letzte war.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vorzeitigesKursende;
    /**
     * The exkursion
     * Meta information extracted from the WSDL
     * - documentation: Alle Exkursionen des Kursabschnitts und alle bereits zukünftig geplanten Exkursionen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \InGeKurs\KursStructType\Exkursion[]
     */
    public $exkursion;
    /**
     * Constructor method for Kursabschnittsbeginn
     * @uses Kursabschnittsbeginn::setKursdurchfuehrung()
     * @uses Kursabschnittsbeginn::setAktuellerKursabschnitt()
     * @uses Kursabschnittsbeginn::setKursleiter()
     * @uses Kursabschnittsbeginn::setGesamteAnzahlTN()
     * @uses Kursabschnittsbeginn::setKursortAenderungen()
     * @uses Kursabschnittsbeginn::setLehrmittel()
     * @uses Kursabschnittsbeginn::setVorzeitigesKursende()
     * @uses Kursabschnittsbeginn::setExkursion()
     * @param \InGeKurs\KursStructType\KursVerlauf $kursdurchfuehrung
     * @param \InGeKurs\KursStructType\Abschnitt $aktuellerKursabschnitt
     * @param \InGeKurs\KursStructType\LehrkraftIdentifikation[] $kursleiter
     * @param int $gesamteAnzahlTN
     * @param \InGeKurs\KursStructType\KursortAenderung[] $kursortAenderungen
     * @param \InGeKurs\KursStructType\LehrmittelIdentifikation[] $lehrmittel
     * @param string $vorzeitigesKursende
     * @param \InGeKurs\KursStructType\Exkursion[] $exkursion
     */
    public function __construct(\InGeKurs\KursStructType\KursVerlauf $kursdurchfuehrung = null, \InGeKurs\KursStructType\Abschnitt $aktuellerKursabschnitt = null, array $kursleiter = array(), $gesamteAnzahlTN = null, array $kursortAenderungen = array(), array $lehrmittel = array(), $vorzeitigesKursende = null, array $exkursion = array())
    {
        $this
            ->setKursdurchfuehrung($kursdurchfuehrung)
            ->setAktuellerKursabschnitt($aktuellerKursabschnitt)
            ->setKursleiter($kursleiter)
            ->setGesamteAnzahlTN($gesamteAnzahlTN)
            ->setKursortAenderungen($kursortAenderungen)
            ->setLehrmittel($lehrmittel)
            ->setVorzeitigesKursende($vorzeitigesKursende)
            ->setExkursion($exkursion);
    }
    /**
     * Get kursdurchfuehrung value
     * @return \InGeKurs\KursStructType\KursVerlauf
     */
    public function getKursdurchfuehrung()
    {
        return $this->kursdurchfuehrung;
    }
    /**
     * Set kursdurchfuehrung value
     * @param \InGeKurs\KursStructType\KursVerlauf $kursdurchfuehrung
     * @return \InGeKurs\KursStructType\Kursabschnittsbeginn
     */
    public function setKursdurchfuehrung(\InGeKurs\KursStructType\KursVerlauf $kursdurchfuehrung = null)
    {
        $this->kursdurchfuehrung = $kursdurchfuehrung;
        return $this;
    }
    /**
     * Get aktuellerKursabschnitt value
     * @return \InGeKurs\KursStructType\Abschnitt
     */
    public function getAktuellerKursabschnitt()
    {
        return $this->aktuellerKursabschnitt;
    }
    /**
     * Set aktuellerKursabschnitt value
     * @param \InGeKurs\KursStructType\Abschnitt $aktuellerKursabschnitt
     * @return \InGeKurs\KursStructType\Kursabschnittsbeginn
     */
    public function setAktuellerKursabschnitt(\InGeKurs\KursStructType\Abschnitt $aktuellerKursabschnitt = null)
    {
        $this->aktuellerKursabschnitt = $aktuellerKursabschnitt;
        return $this;
    }
    /**
     * Get kursleiter value
     * @return \InGeKurs\KursStructType\LehrkraftIdentifikation[]
     */
    public function getKursleiter()
    {
        return $this->kursleiter;
    }
    /**
     * This method is responsible for validating the values passed to the setKursleiter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKursleiter method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKursleiterForArrayConstraintsFromSetKursleiter(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kursabschnittsbeginnKursleiterItem) {
            // validation for constraint: itemType
            if (!$kursabschnittsbeginnKursleiterItem instanceof \InGeKurs\KursStructType\LehrkraftIdentifikation) {
                $invalidValues[] = is_object($kursabschnittsbeginnKursleiterItem) ? get_class($kursabschnittsbeginnKursleiterItem) : sprintf('%s(%s)', gettype($kursabschnittsbeginnKursleiterItem), var_export($kursabschnittsbeginnKursleiterItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kursleiter property can only contain items of type \InGeKurs\KursStructType\LehrkraftIdentifikation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kursleiter value
     * @throws \InvalidArgumentException
     * @param \InGeKurs\KursStructType\LehrkraftIdentifikation[] $kursleiter
     * @return \InGeKurs\KursStructType\Kursabschnittsbeginn
     */
    public function setKursleiter(array $kursleiter = array())
    {
        // validation for constraint: array
        if ('' !== ($kursleiterArrayErrorMessage = self::validateKursleiterForArrayConstraintsFromSetKursleiter($kursleiter))) {
            throw new \InvalidArgumentException($kursleiterArrayErrorMessage, __LINE__);
        }
        $this->kursleiter = $kursleiter;
        return $this;
    }
    /**
     * Add item to kursleiter value
     * @throws \InvalidArgumentException
     * @param \InGeKurs\KursStructType\LehrkraftIdentifikation $item
     * @return \InGeKurs\KursStructType\Kursabschnittsbeginn
     */
    public function addToKursleiter(\InGeKurs\KursStructType\LehrkraftIdentifikation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \InGeKurs\KursStructType\LehrkraftIdentifikation) {
            throw new \InvalidArgumentException(sprintf('The kursleiter property can only contain items of type \InGeKurs\KursStructType\LehrkraftIdentifikation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kursleiter[] = $item;
        return $this;
    }
    /**
     * Get gesamteAnzahlTN value
     * @return int
     */
    public function getGesamteAnzahlTN()
    {
        return $this->gesamteAnzahlTN;
    }
    /**
     * Set gesamteAnzahlTN value
     * @param int $gesamteAnzahlTN
     * @return \InGeKurs\KursStructType\Kursabschnittsbeginn
     */
    public function setGesamteAnzahlTN($gesamteAnzahlTN = null)
    {
        // validation for constraint: int
        if (!is_null($gesamteAnzahlTN) && !(is_int($gesamteAnzahlTN) || ctype_digit($gesamteAnzahlTN))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gesamteAnzahlTN, true), gettype($gesamteAnzahlTN)), __LINE__);
        }
        $this->gesamteAnzahlTN = $gesamteAnzahlTN;
        return $this;
    }
    /**
     * Get kursortAenderungen value
     * @return \InGeKurs\KursStructType\KursortAenderung[]|null
     */
    public function getKursortAenderungen()
    {
        return $this->kursortAenderungen;
    }
    /**
     * This method is responsible for validating the values passed to the setKursortAenderungen method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKursortAenderungen method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKursortAenderungenForArrayConstraintsFromSetKursortAenderungen(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kursabschnittsbeginnKursortAenderungenItem) {
            // validation for constraint: itemType
            if (!$kursabschnittsbeginnKursortAenderungenItem instanceof \InGeKurs\KursStructType\KursortAenderung) {
                $invalidValues[] = is_object($kursabschnittsbeginnKursortAenderungenItem) ? get_class($kursabschnittsbeginnKursortAenderungenItem) : sprintf('%s(%s)', gettype($kursabschnittsbeginnKursortAenderungenItem), var_export($kursabschnittsbeginnKursortAenderungenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kursortAenderungen property can only contain items of type \InGeKurs\KursStructType\KursortAenderung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kursortAenderungen value
     * @throws \InvalidArgumentException
     * @param \InGeKurs\KursStructType\KursortAenderung[] $kursortAenderungen
     * @return \InGeKurs\KursStructType\Kursabschnittsbeginn
     */
    public function setKursortAenderungen(array $kursortAenderungen = array())
    {
        // validation for constraint: array
        if ('' !== ($kursortAenderungenArrayErrorMessage = self::validateKursortAenderungenForArrayConstraintsFromSetKursortAenderungen($kursortAenderungen))) {
            throw new \InvalidArgumentException($kursortAenderungenArrayErrorMessage, __LINE__);
        }
        $this->kursortAenderungen = $kursortAenderungen;
        return $this;
    }
    /**
     * Add item to kursortAenderungen value
     * @throws \InvalidArgumentException
     * @param \InGeKurs\KursStructType\KursortAenderung $item
     * @return \InGeKurs\KursStructType\Kursabschnittsbeginn
     */
    public function addToKursortAenderungen(\InGeKurs\KursStructType\KursortAenderung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \InGeKurs\KursStructType\KursortAenderung) {
            throw new \InvalidArgumentException(sprintf('The kursortAenderungen property can only contain items of type \InGeKurs\KursStructType\KursortAenderung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kursortAenderungen[] = $item;
        return $this;
    }
    /**
     * Get lehrmittel value
     * @return \InGeKurs\KursStructType\LehrmittelIdentifikation[]|null
     */
    public function getLehrmittel()
    {
        return $this->lehrmittel;
    }
    /**
     * This method is responsible for validating the values passed to the setLehrmittel method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLehrmittel method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLehrmittelForArrayConstraintsFromSetLehrmittel(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kursabschnittsbeginnLehrmittelItem) {
            // validation for constraint: itemType
            if (!$kursabschnittsbeginnLehrmittelItem instanceof \InGeKurs\KursStructType\LehrmittelIdentifikation) {
                $invalidValues[] = is_object($kursabschnittsbeginnLehrmittelItem) ? get_class($kursabschnittsbeginnLehrmittelItem) : sprintf('%s(%s)', gettype($kursabschnittsbeginnLehrmittelItem), var_export($kursabschnittsbeginnLehrmittelItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The lehrmittel property can only contain items of type \InGeKurs\KursStructType\LehrmittelIdentifikation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set lehrmittel value
     * @throws \InvalidArgumentException
     * @param \InGeKurs\KursStructType\LehrmittelIdentifikation[] $lehrmittel
     * @return \InGeKurs\KursStructType\Kursabschnittsbeginn
     */
    public function setLehrmittel(array $lehrmittel = array())
    {
        // validation for constraint: array
        if ('' !== ($lehrmittelArrayErrorMessage = self::validateLehrmittelForArrayConstraintsFromSetLehrmittel($lehrmittel))) {
            throw new \InvalidArgumentException($lehrmittelArrayErrorMessage, __LINE__);
        }
        $this->lehrmittel = $lehrmittel;
        return $this;
    }
    /**
     * Add item to lehrmittel value
     * @throws \InvalidArgumentException
     * @param \InGeKurs\KursStructType\LehrmittelIdentifikation $item
     * @return \InGeKurs\KursStructType\Kursabschnittsbeginn
     */
    public function addToLehrmittel(\InGeKurs\KursStructType\LehrmittelIdentifikation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \InGeKurs\KursStructType\LehrmittelIdentifikation) {
            throw new \InvalidArgumentException(sprintf('The lehrmittel property can only contain items of type \InGeKurs\KursStructType\LehrmittelIdentifikation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->lehrmittel[] = $item;
        return $this;
    }
    /**
     * Get vorzeitigesKursende value
     * @return string|null
     */
    public function getVorzeitigesKursende()
    {
        return $this->vorzeitigesKursende;
    }
    /**
     * Set vorzeitigesKursende value
     * @param string $vorzeitigesKursende
     * @return \InGeKurs\KursStructType\Kursabschnittsbeginn
     */
    public function setVorzeitigesKursende($vorzeitigesKursende = null)
    {
        // validation for constraint: string
        if (!is_null($vorzeitigesKursende) && !is_string($vorzeitigesKursende)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vorzeitigesKursende, true), gettype($vorzeitigesKursende)), __LINE__);
        }
        $this->vorzeitigesKursende = $vorzeitigesKursende;
        return $this;
    }
    /**
     * Get exkursion value
     * @return \InGeKurs\KursStructType\Exkursion[]|null
     */
    public function getExkursion()
    {
        return $this->exkursion;
    }
    /**
     * This method is responsible for validating the values passed to the setExkursion method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExkursion method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExkursionForArrayConstraintsFromSetExkursion(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kursabschnittsbeginnExkursionItem) {
            // validation for constraint: itemType
            if (!$kursabschnittsbeginnExkursionItem instanceof \InGeKurs\KursStructType\Exkursion) {
                $invalidValues[] = is_object($kursabschnittsbeginnExkursionItem) ? get_class($kursabschnittsbeginnExkursionItem) : sprintf('%s(%s)', gettype($kursabschnittsbeginnExkursionItem), var_export($kursabschnittsbeginnExkursionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The exkursion property can only contain items of type \InGeKurs\KursStructType\Exkursion, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set exkursion value
     * @throws \InvalidArgumentException
     * @param \InGeKurs\KursStructType\Exkursion[] $exkursion
     * @return \InGeKurs\KursStructType\Kursabschnittsbeginn
     */
    public function setExkursion(array $exkursion = array())
    {
        // validation for constraint: array
        if ('' !== ($exkursionArrayErrorMessage = self::validateExkursionForArrayConstraintsFromSetExkursion($exkursion))) {
            throw new \InvalidArgumentException($exkursionArrayErrorMessage, __LINE__);
        }
        $this->exkursion = $exkursion;
        return $this;
    }
    /**
     * Add item to exkursion value
     * @throws \InvalidArgumentException
     * @param \InGeKurs\KursStructType\Exkursion $item
     * @return \InGeKurs\KursStructType\Kursabschnittsbeginn
     */
    public function addToExkursion(\InGeKurs\KursStructType\Exkursion $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \InGeKurs\KursStructType\Exkursion) {
            throw new \InvalidArgumentException(sprintf('The exkursion property can only contain items of type \InGeKurs\KursStructType\Exkursion, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->exkursion[] = $item;
        return $this;
    }
}
