<?php

namespace InGeKurs\KursServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Kurs KursServiceType
 * @subpackage Services
 */
class Kurs extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named kursAuskunftAnfordern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \InGeKurs\KursStructType\KursAuskunft_kursAuskunftAnfordernElement $parameters
     * @return \InGeKurs\KursStructType\KursAuskunft_kursAuskunftAnfordernResponseElement|bool
     */
    public function kursAuskunftAnfordern(\InGeKurs\KursStructType\KursAuskunft_kursAuskunftAnfordernElement $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->kursAuskunftAnfordern($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \InGeKurs\KursStructType\KursAuskunft_kursAuskunftAnfordernResponseElement
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
