<?php

namespace InGeKurs\KursStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Meldung KursStructType
 * @subpackage Structs
 */
class Meldung extends AbstractStructBase
{
    /**
     * The kennung
     * Meta information extracted from the WSDL
     * - documentation: Die Kennung einer Meldung hat das Format <Kategorie>-<Bereich>-<Meldungscode>-<Instanz-Identifikation>.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $kennung;
    /**
     * The meldung
     * Meta information extracted from the WSDL
     * - documentation: Kurzbezeichnung der Meldungsart.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $meldung;
    /**
     * The beschreibung
     * Meta information extracted from the WSDL
     * - documentation: Benutzerfreundlichere Aufbereitung der Meldung. Diese enthält keine Information, die sich nicht auch aus Kennung der Meldung bzw. den im Serviceaufruf gesendeten Daten ableiten lässt. Die Beschreibung kann von beliebiger Länge
     * sein, ist also insbesondere nicht geeignet für die Speicherung in einfachen (VAR)CHAR-Spalten.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $beschreibung;
    /**
     * The sequenz
     * Meta information extracted from the WSDL
     * - documentation: Die Sequenz gibt die Reihenfolge der Meldungen an, in der diese erzeugt wurden.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $sequenz;
    /**
     * Constructor method for Meldung
     * @uses Meldung::setKennung()
     * @uses Meldung::setMeldung()
     * @uses Meldung::setBeschreibung()
     * @uses Meldung::setSequenz()
     * @param string $kennung
     * @param string $meldung
     * @param string $beschreibung
     * @param int $sequenz
     */
    public function __construct($kennung = null, $meldung = null, $beschreibung = null, $sequenz = null)
    {
        $this
            ->setKennung($kennung)
            ->setMeldung($meldung)
            ->setBeschreibung($beschreibung)
            ->setSequenz($sequenz);
    }
    /**
     * Get kennung value
     * @return string
     */
    public function getKennung()
    {
        return $this->kennung;
    }
    /**
     * Set kennung value
     * @param string $kennung
     * @return \InGeKurs\KursStructType\Meldung
     */
    public function setKennung($kennung = null)
    {
        // validation for constraint: string
        if (!is_null($kennung) && !is_string($kennung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kennung, true), gettype($kennung)), __LINE__);
        }
        $this->kennung = $kennung;
        return $this;
    }
    /**
     * Get meldung value
     * @return string
     */
    public function getMeldung()
    {
        return $this->meldung;
    }
    /**
     * Set meldung value
     * @param string $meldung
     * @return \InGeKurs\KursStructType\Meldung
     */
    public function setMeldung($meldung = null)
    {
        // validation for constraint: string
        if (!is_null($meldung) && !is_string($meldung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($meldung, true), gettype($meldung)), __LINE__);
        }
        $this->meldung = $meldung;
        return $this;
    }
    /**
     * Get beschreibung value
     * @return string
     */
    public function getBeschreibung()
    {
        return $this->beschreibung;
    }
    /**
     * Set beschreibung value
     * @param string $beschreibung
     * @return \InGeKurs\KursStructType\Meldung
     */
    public function setBeschreibung($beschreibung = null)
    {
        // validation for constraint: string
        if (!is_null($beschreibung) && !is_string($beschreibung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beschreibung, true), gettype($beschreibung)), __LINE__);
        }
        $this->beschreibung = $beschreibung;
        return $this;
    }
    /**
     * Get sequenz value
     * @return int
     */
    public function getSequenz()
    {
        return $this->sequenz;
    }
    /**
     * Set sequenz value
     * @param int $sequenz
     * @return \InGeKurs\KursStructType\Meldung
     */
    public function setSequenz($sequenz = null)
    {
        // validation for constraint: int
        if (!is_null($sequenz) && !(is_int($sequenz) || ctype_digit($sequenz))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sequenz, true), gettype($sequenz)), __LINE__);
        }
        $this->sequenz = $sequenz;
        return $this;
    }
}
