<?php

namespace InGeKurs\KursStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KursVerlauf KursStructType
 * @subpackage Structs
 */
class KursVerlauf extends AbstractStructBase
{
    /**
     * The kursort
     * Meta information extracted from the WSDL
     * - documentation: Der Kursort, an dem der jeweilige Abschnitt begonnen hat.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \InGeKurs\KursStructType\KursortIdentifikation
     */
    public $kursort;
    /**
     * The unterrichtszeiten
     * Meta information extracted from the WSDL
     * - documentation: Für jeden Wochentag darf höchstens ein Zeitplan geliefert werden.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \InGeKurs\KursStructType\Unterrichtszeit[]
     */
    public $unterrichtszeiten;
    /**
     * The maximaleAnzahlTN
     * Meta information extracted from the WSDL
     * - documentation: Maximale Anzahl anTeilnehmern, die der Kurs aufnehmen kann.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $maximaleAnzahlTN;
    /**
     * The angabeKursform
     * Meta information extracted from the WSDL
     * - documentation: Codeliste 818. Erst ab Stichtag verpflichtend.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $angabeKursform;
    /**
     * The angabeBarrierefreiheit
     * Meta information extracted from the WSDL
     * - documentation: Ein oder mehrere Merkmale aus der Codeliste 817 (Angaben zur Barrierefreiheit). Das Merkmal 'keine Angabe' darf nur alleine übermittelt werden. Erst ab Stichtag verpflichtend.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $angabeBarrierefreiheit;
    /**
     * The angabeKiBe
     * Meta information extracted from the WSDL
     * - documentation: Angabe ob eine Kinderbeaufsichtigung zum Kurs angeboten wird. Fehlende Angabe wird als 'keine Angabe' interpretiert.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $angabeKiBe;
    /**
     * The abschnittPlanung
     * Meta information extracted from the WSDL
     * - documentation: Angaben zur Planung des auf den aktuell laufenden Abschnitts folgenden Kursverlaufs (also insbesondere der gesamte Kursverlauf, falls der Kurs noch nicht begonnen wurde). Es wird empfohlen, die Angaben in chronologischer Reihenfolge
     * zu senden, um die Nachvollziehbarkeit der Nachrichten zu verbessern.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \InGeKurs\KursStructType\Abschnitt[]
     */
    public $abschnittPlanung;
    /**
     * The unterbrechungen
     * Meta information extracted from the WSDL
     * - documentation: Die Zeiträume der im Kursabschnitt bereits erfolgten Unterbrechungen sowie alle zukünftig geplanten Unterbrechnungen. Falls UnterbrechungInSchulferien gesetzt ist, sind Ferienzeiten nicht in diese Liste aufzunehmen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \InGeKurs\KursStructType\Kursunterbrechung[]
     */
    public $unterbrechungen;
    /**
     * The unterbrechungInSchulferien
     * Meta information extracted from the WSDL
     * - documentation: Hier ist True zu übermitteln, falls während der Schulferien grundsätzlich kein Unterricht statt findet. Dies ist additiv zur Liste der Unterbrechungen. Fehlende Angabe wird wie False verarbeitet (ggf. wird dieses Feld in einer
     * zukünftigen Version ein Pflichtfeld).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $unterbrechungInSchulferien;
    /**
     * The teilnehmer
     * Meta information extracted from the WSDL
     * - documentation: Liste der geförderten Teilnehmer. Alle Teilnehmer müssen identifizierbar sein und über eine aktive Berechtigung mit Anmeldung verfügen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \InGeKurs\KursStructType\TeilnehmerIdentifikation[]
     */
    public $teilnehmer;
    /**
     * Constructor method for KursVerlauf
     * @uses KursVerlauf::setKursort()
     * @uses KursVerlauf::setUnterrichtszeiten()
     * @uses KursVerlauf::setMaximaleAnzahlTN()
     * @uses KursVerlauf::setAngabeKursform()
     * @uses KursVerlauf::setAngabeBarrierefreiheit()
     * @uses KursVerlauf::setAngabeKiBe()
     * @uses KursVerlauf::setAbschnittPlanung()
     * @uses KursVerlauf::setUnterbrechungen()
     * @uses KursVerlauf::setUnterbrechungInSchulferien()
     * @uses KursVerlauf::setTeilnehmer()
     * @param \InGeKurs\KursStructType\KursortIdentifikation $kursort
     * @param \InGeKurs\KursStructType\Unterrichtszeit[] $unterrichtszeiten
     * @param int $maximaleAnzahlTN
     * @param string $angabeKursform
     * @param string[] $angabeBarrierefreiheit
     * @param bool $angabeKiBe
     * @param \InGeKurs\KursStructType\Abschnitt[] $abschnittPlanung
     * @param \InGeKurs\KursStructType\Kursunterbrechung[] $unterbrechungen
     * @param bool $unterbrechungInSchulferien
     * @param \InGeKurs\KursStructType\TeilnehmerIdentifikation[] $teilnehmer
     */
    public function __construct(\InGeKurs\KursStructType\KursortIdentifikation $kursort = null, array $unterrichtszeiten = array(), $maximaleAnzahlTN = null, $angabeKursform = null, array $angabeBarrierefreiheit = array(), $angabeKiBe = null, array $abschnittPlanung = array(), array $unterbrechungen = array(), $unterbrechungInSchulferien = null, array $teilnehmer = array())
    {
        $this
            ->setKursort($kursort)
            ->setUnterrichtszeiten($unterrichtszeiten)
            ->setMaximaleAnzahlTN($maximaleAnzahlTN)
            ->setAngabeKursform($angabeKursform)
            ->setAngabeBarrierefreiheit($angabeBarrierefreiheit)
            ->setAngabeKiBe($angabeKiBe)
            ->setAbschnittPlanung($abschnittPlanung)
            ->setUnterbrechungen($unterbrechungen)
            ->setUnterbrechungInSchulferien($unterbrechungInSchulferien)
            ->setTeilnehmer($teilnehmer);
    }
    /**
     * Get kursort value
     * @return \InGeKurs\KursStructType\KursortIdentifikation
     */
    public function getKursort()
    {
        return $this->kursort;
    }
    /**
     * Set kursort value
     * @param \InGeKurs\KursStructType\KursortIdentifikation $kursort
     * @return \InGeKurs\KursStructType\KursVerlauf
     */
    public function setKursort(\InGeKurs\KursStructType\KursortIdentifikation $kursort = null)
    {
        $this->kursort = $kursort;
        return $this;
    }
    /**
     * Get unterrichtszeiten value
     * @return \InGeKurs\KursStructType\Unterrichtszeit[]
     */
    public function getUnterrichtszeiten()
    {
        return $this->unterrichtszeiten;
    }
    /**
     * This method is responsible for validating the values passed to the setUnterrichtszeiten method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnterrichtszeiten method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnterrichtszeitenForArrayConstraintsFromSetUnterrichtszeiten(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kursVerlaufUnterrichtszeitenItem) {
            // validation for constraint: itemType
            if (!$kursVerlaufUnterrichtszeitenItem instanceof \InGeKurs\KursStructType\Unterrichtszeit) {
                $invalidValues[] = is_object($kursVerlaufUnterrichtszeitenItem) ? get_class($kursVerlaufUnterrichtszeitenItem) : sprintf('%s(%s)', gettype($kursVerlaufUnterrichtszeitenItem), var_export($kursVerlaufUnterrichtszeitenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The unterrichtszeiten property can only contain items of type \InGeKurs\KursStructType\Unterrichtszeit, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set unterrichtszeiten value
     * @throws \InvalidArgumentException
     * @param \InGeKurs\KursStructType\Unterrichtszeit[] $unterrichtszeiten
     * @return \InGeKurs\KursStructType\KursVerlauf
     */
    public function setUnterrichtszeiten(array $unterrichtszeiten = array())
    {
        // validation for constraint: array
        if ('' !== ($unterrichtszeitenArrayErrorMessage = self::validateUnterrichtszeitenForArrayConstraintsFromSetUnterrichtszeiten($unterrichtszeiten))) {
            throw new \InvalidArgumentException($unterrichtszeitenArrayErrorMessage, __LINE__);
        }
        $this->unterrichtszeiten = $unterrichtszeiten;
        return $this;
    }
    /**
     * Add item to unterrichtszeiten value
     * @throws \InvalidArgumentException
     * @param \InGeKurs\KursStructType\Unterrichtszeit $item
     * @return \InGeKurs\KursStructType\KursVerlauf
     */
    public function addToUnterrichtszeiten(\InGeKurs\KursStructType\Unterrichtszeit $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \InGeKurs\KursStructType\Unterrichtszeit) {
            throw new \InvalidArgumentException(sprintf('The unterrichtszeiten property can only contain items of type \InGeKurs\KursStructType\Unterrichtszeit, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->unterrichtszeiten[] = $item;
        return $this;
    }
    /**
     * Get maximaleAnzahlTN value
     * @return int
     */
    public function getMaximaleAnzahlTN()
    {
        return $this->maximaleAnzahlTN;
    }
    /**
     * Set maximaleAnzahlTN value
     * @param int $maximaleAnzahlTN
     * @return \InGeKurs\KursStructType\KursVerlauf
     */
    public function setMaximaleAnzahlTN($maximaleAnzahlTN = null)
    {
        // validation for constraint: int
        if (!is_null($maximaleAnzahlTN) && !(is_int($maximaleAnzahlTN) || ctype_digit($maximaleAnzahlTN))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximaleAnzahlTN, true), gettype($maximaleAnzahlTN)), __LINE__);
        }
        $this->maximaleAnzahlTN = $maximaleAnzahlTN;
        return $this;
    }
    /**
     * Get angabeKursform value
     * @return string|null
     */
    public function getAngabeKursform()
    {
        return $this->angabeKursform;
    }
    /**
     * Set angabeKursform value
     * @param string $angabeKursform
     * @return \InGeKurs\KursStructType\KursVerlauf
     */
    public function setAngabeKursform($angabeKursform = null)
    {
        // validation for constraint: string
        if (!is_null($angabeKursform) && !is_string($angabeKursform)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($angabeKursform, true), gettype($angabeKursform)), __LINE__);
        }
        $this->angabeKursform = $angabeKursform;
        return $this;
    }
    /**
     * Get angabeBarrierefreiheit value
     * @return string[]|null
     */
    public function getAngabeBarrierefreiheit()
    {
        return $this->angabeBarrierefreiheit;
    }
    /**
     * This method is responsible for validating the values passed to the setAngabeBarrierefreiheit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAngabeBarrierefreiheit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAngabeBarrierefreiheitForArrayConstraintsFromSetAngabeBarrierefreiheit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kursVerlaufAngabeBarrierefreiheitItem) {
            // validation for constraint: itemType
            if (!is_string($kursVerlaufAngabeBarrierefreiheitItem)) {
                $invalidValues[] = is_object($kursVerlaufAngabeBarrierefreiheitItem) ? get_class($kursVerlaufAngabeBarrierefreiheitItem) : sprintf('%s(%s)', gettype($kursVerlaufAngabeBarrierefreiheitItem), var_export($kursVerlaufAngabeBarrierefreiheitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The angabeBarrierefreiheit property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set angabeBarrierefreiheit value
     * @throws \InvalidArgumentException
     * @param string[] $angabeBarrierefreiheit
     * @return \InGeKurs\KursStructType\KursVerlauf
     */
    public function setAngabeBarrierefreiheit(array $angabeBarrierefreiheit = array())
    {
        // validation for constraint: array
        if ('' !== ($angabeBarrierefreiheitArrayErrorMessage = self::validateAngabeBarrierefreiheitForArrayConstraintsFromSetAngabeBarrierefreiheit($angabeBarrierefreiheit))) {
            throw new \InvalidArgumentException($angabeBarrierefreiheitArrayErrorMessage, __LINE__);
        }
        $this->angabeBarrierefreiheit = $angabeBarrierefreiheit;
        return $this;
    }
    /**
     * Add item to angabeBarrierefreiheit value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \InGeKurs\KursStructType\KursVerlauf
     */
    public function addToAngabeBarrierefreiheit($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The angabeBarrierefreiheit property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->angabeBarrierefreiheit[] = $item;
        return $this;
    }
    /**
     * Get angabeKiBe value
     * @return bool|null
     */
    public function getAngabeKiBe()
    {
        return $this->angabeKiBe;
    }
    /**
     * Set angabeKiBe value
     * @param bool $angabeKiBe
     * @return \InGeKurs\KursStructType\KursVerlauf
     */
    public function setAngabeKiBe($angabeKiBe = null)
    {
        // validation for constraint: boolean
        if (!is_null($angabeKiBe) && !is_bool($angabeKiBe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($angabeKiBe, true), gettype($angabeKiBe)), __LINE__);
        }
        $this->angabeKiBe = $angabeKiBe;
        return $this;
    }
    /**
     * Get abschnittPlanung value
     * @return \InGeKurs\KursStructType\Abschnitt[]|null
     */
    public function getAbschnittPlanung()
    {
        return $this->abschnittPlanung;
    }
    /**
     * This method is responsible for validating the values passed to the setAbschnittPlanung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAbschnittPlanung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAbschnittPlanungForArrayConstraintsFromSetAbschnittPlanung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kursVerlaufAbschnittPlanungItem) {
            // validation for constraint: itemType
            if (!$kursVerlaufAbschnittPlanungItem instanceof \InGeKurs\KursStructType\Abschnitt) {
                $invalidValues[] = is_object($kursVerlaufAbschnittPlanungItem) ? get_class($kursVerlaufAbschnittPlanungItem) : sprintf('%s(%s)', gettype($kursVerlaufAbschnittPlanungItem), var_export($kursVerlaufAbschnittPlanungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The abschnittPlanung property can only contain items of type \InGeKurs\KursStructType\Abschnitt, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set abschnittPlanung value
     * @throws \InvalidArgumentException
     * @param \InGeKurs\KursStructType\Abschnitt[] $abschnittPlanung
     * @return \InGeKurs\KursStructType\KursVerlauf
     */
    public function setAbschnittPlanung(array $abschnittPlanung = array())
    {
        // validation for constraint: array
        if ('' !== ($abschnittPlanungArrayErrorMessage = self::validateAbschnittPlanungForArrayConstraintsFromSetAbschnittPlanung($abschnittPlanung))) {
            throw new \InvalidArgumentException($abschnittPlanungArrayErrorMessage, __LINE__);
        }
        $this->abschnittPlanung = $abschnittPlanung;
        return $this;
    }
    /**
     * Add item to abschnittPlanung value
     * @throws \InvalidArgumentException
     * @param \InGeKurs\KursStructType\Abschnitt $item
     * @return \InGeKurs\KursStructType\KursVerlauf
     */
    public function addToAbschnittPlanung(\InGeKurs\KursStructType\Abschnitt $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \InGeKurs\KursStructType\Abschnitt) {
            throw new \InvalidArgumentException(sprintf('The abschnittPlanung property can only contain items of type \InGeKurs\KursStructType\Abschnitt, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->abschnittPlanung[] = $item;
        return $this;
    }
    /**
     * Get unterbrechungen value
     * @return \InGeKurs\KursStructType\Kursunterbrechung[]|null
     */
    public function getUnterbrechungen()
    {
        return $this->unterbrechungen;
    }
    /**
     * This method is responsible for validating the values passed to the setUnterbrechungen method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnterbrechungen method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnterbrechungenForArrayConstraintsFromSetUnterbrechungen(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kursVerlaufUnterbrechungenItem) {
            // validation for constraint: itemType
            if (!$kursVerlaufUnterbrechungenItem instanceof \InGeKurs\KursStructType\Kursunterbrechung) {
                $invalidValues[] = is_object($kursVerlaufUnterbrechungenItem) ? get_class($kursVerlaufUnterbrechungenItem) : sprintf('%s(%s)', gettype($kursVerlaufUnterbrechungenItem), var_export($kursVerlaufUnterbrechungenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The unterbrechungen property can only contain items of type \InGeKurs\KursStructType\Kursunterbrechung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set unterbrechungen value
     * @throws \InvalidArgumentException
     * @param \InGeKurs\KursStructType\Kursunterbrechung[] $unterbrechungen
     * @return \InGeKurs\KursStructType\KursVerlauf
     */
    public function setUnterbrechungen(array $unterbrechungen = array())
    {
        // validation for constraint: array
        if ('' !== ($unterbrechungenArrayErrorMessage = self::validateUnterbrechungenForArrayConstraintsFromSetUnterbrechungen($unterbrechungen))) {
            throw new \InvalidArgumentException($unterbrechungenArrayErrorMessage, __LINE__);
        }
        $this->unterbrechungen = $unterbrechungen;
        return $this;
    }
    /**
     * Add item to unterbrechungen value
     * @throws \InvalidArgumentException
     * @param \InGeKurs\KursStructType\Kursunterbrechung $item
     * @return \InGeKurs\KursStructType\KursVerlauf
     */
    public function addToUnterbrechungen(\InGeKurs\KursStructType\Kursunterbrechung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \InGeKurs\KursStructType\Kursunterbrechung) {
            throw new \InvalidArgumentException(sprintf('The unterbrechungen property can only contain items of type \InGeKurs\KursStructType\Kursunterbrechung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->unterbrechungen[] = $item;
        return $this;
    }
    /**
     * Get unterbrechungInSchulferien value
     * @return bool|null
     */
    public function getUnterbrechungInSchulferien()
    {
        return $this->unterbrechungInSchulferien;
    }
    /**
     * Set unterbrechungInSchulferien value
     * @param bool $unterbrechungInSchulferien
     * @return \InGeKurs\KursStructType\KursVerlauf
     */
    public function setUnterbrechungInSchulferien($unterbrechungInSchulferien = null)
    {
        // validation for constraint: boolean
        if (!is_null($unterbrechungInSchulferien) && !is_bool($unterbrechungInSchulferien)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($unterbrechungInSchulferien, true), gettype($unterbrechungInSchulferien)), __LINE__);
        }
        $this->unterbrechungInSchulferien = $unterbrechungInSchulferien;
        return $this;
    }
    /**
     * Get teilnehmer value
     * @return \InGeKurs\KursStructType\TeilnehmerIdentifikation[]|null
     */
    public function getTeilnehmer()
    {
        return $this->teilnehmer;
    }
    /**
     * This method is responsible for validating the values passed to the setTeilnehmer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTeilnehmer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTeilnehmerForArrayConstraintsFromSetTeilnehmer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kursVerlaufTeilnehmerItem) {
            // validation for constraint: itemType
            if (!$kursVerlaufTeilnehmerItem instanceof \InGeKurs\KursStructType\TeilnehmerIdentifikation) {
                $invalidValues[] = is_object($kursVerlaufTeilnehmerItem) ? get_class($kursVerlaufTeilnehmerItem) : sprintf('%s(%s)', gettype($kursVerlaufTeilnehmerItem), var_export($kursVerlaufTeilnehmerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The teilnehmer property can only contain items of type \InGeKurs\KursStructType\TeilnehmerIdentifikation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set teilnehmer value
     * @throws \InvalidArgumentException
     * @param \InGeKurs\KursStructType\TeilnehmerIdentifikation[] $teilnehmer
     * @return \InGeKurs\KursStructType\KursVerlauf
     */
    public function setTeilnehmer(array $teilnehmer = array())
    {
        // validation for constraint: array
        if ('' !== ($teilnehmerArrayErrorMessage = self::validateTeilnehmerForArrayConstraintsFromSetTeilnehmer($teilnehmer))) {
            throw new \InvalidArgumentException($teilnehmerArrayErrorMessage, __LINE__);
        }
        $this->teilnehmer = $teilnehmer;
        return $this;
    }
    /**
     * Add item to teilnehmer value
     * @throws \InvalidArgumentException
     * @param \InGeKurs\KursStructType\TeilnehmerIdentifikation $item
     * @return \InGeKurs\KursStructType\KursVerlauf
     */
    public function addToTeilnehmer(\InGeKurs\KursStructType\TeilnehmerIdentifikation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \InGeKurs\KursStructType\TeilnehmerIdentifikation) {
            throw new \InvalidArgumentException(sprintf('The teilnehmer property can only contain items of type \InGeKurs\KursStructType\TeilnehmerIdentifikation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->teilnehmer[] = $item;
        return $this;
    }
}
