<?php

namespace InGeKurs\KursStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KursGesamtAuskunft KursStructType
 * @subpackage Structs
 */
class KursGesamtAuskunft extends AbstractStructBase
{
    /**
     * The kursart
     * Meta information extracted from the WSDL
     * - documentation: Codeliste 802.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $kursart;
    /**
     * The beginn
     * Meta information extracted from the WSDL
     * - documentation: Das geplante Beginndatum des Kursabschnitts.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $beginn;
    /**
     * The zusatzangabe
     * Meta information extracted from the WSDL
     * - documentation: Falls zutreffend, ein oder mehrere zusätzliche Merkmale aus der Codeliste 812. Die für jedes Merkmal individuell geltenden Regelungen sind einzuhalten.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $zusatzangabe;
    /**
     * The kursortAenderungen
     * Meta information extracted from the WSDL
     * - documentation: Angaben zu für die Zukunft geplanten Änderungen des Kursorts in diesem Kurs.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \InGeKurs\KursStructType\KursortAenderung[]
     */
    public $kursortAenderungen;
    /**
     * Constructor method for KursGesamtAuskunft
     * @uses KursGesamtAuskunft::setKursart()
     * @uses KursGesamtAuskunft::setBeginn()
     * @uses KursGesamtAuskunft::setZusatzangabe()
     * @uses KursGesamtAuskunft::setKursortAenderungen()
     * @param string $kursart
     * @param string $beginn
     * @param string[] $zusatzangabe
     * @param \InGeKurs\KursStructType\KursortAenderung[] $kursortAenderungen
     */
    public function __construct($kursart = null, $beginn = null, array $zusatzangabe = array(), array $kursortAenderungen = array())
    {
        $this
            ->setKursart($kursart)
            ->setBeginn($beginn)
            ->setZusatzangabe($zusatzangabe)
            ->setKursortAenderungen($kursortAenderungen);
    }
    /**
     * Get kursart value
     * @return string
     */
    public function getKursart()
    {
        return $this->kursart;
    }
    /**
     * Set kursart value
     * @param string $kursart
     * @return \InGeKurs\KursStructType\KursGesamtAuskunft
     */
    public function setKursart($kursart = null)
    {
        // validation for constraint: string
        if (!is_null($kursart) && !is_string($kursart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kursart, true), gettype($kursart)), __LINE__);
        }
        $this->kursart = $kursart;
        return $this;
    }
    /**
     * Get beginn value
     * @return string
     */
    public function getBeginn()
    {
        return $this->beginn;
    }
    /**
     * Set beginn value
     * @param string $beginn
     * @return \InGeKurs\KursStructType\KursGesamtAuskunft
     */
    public function setBeginn($beginn = null)
    {
        // validation for constraint: string
        if (!is_null($beginn) && !is_string($beginn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beginn, true), gettype($beginn)), __LINE__);
        }
        $this->beginn = $beginn;
        return $this;
    }
    /**
     * Get zusatzangabe value
     * @return string[]|null
     */
    public function getZusatzangabe()
    {
        return $this->zusatzangabe;
    }
    /**
     * This method is responsible for validating the values passed to the setZusatzangabe method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZusatzangabe method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZusatzangabeForArrayConstraintsFromSetZusatzangabe(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kursGesamtAuskunftZusatzangabeItem) {
            // validation for constraint: itemType
            if (!is_string($kursGesamtAuskunftZusatzangabeItem)) {
                $invalidValues[] = is_object($kursGesamtAuskunftZusatzangabeItem) ? get_class($kursGesamtAuskunftZusatzangabeItem) : sprintf('%s(%s)', gettype($kursGesamtAuskunftZusatzangabeItem), var_export($kursGesamtAuskunftZusatzangabeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The zusatzangabe property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set zusatzangabe value
     * @throws \InvalidArgumentException
     * @param string[] $zusatzangabe
     * @return \InGeKurs\KursStructType\KursGesamtAuskunft
     */
    public function setZusatzangabe(array $zusatzangabe = array())
    {
        // validation for constraint: array
        if ('' !== ($zusatzangabeArrayErrorMessage = self::validateZusatzangabeForArrayConstraintsFromSetZusatzangabe($zusatzangabe))) {
            throw new \InvalidArgumentException($zusatzangabeArrayErrorMessage, __LINE__);
        }
        $this->zusatzangabe = $zusatzangabe;
        return $this;
    }
    /**
     * Add item to zusatzangabe value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \InGeKurs\KursStructType\KursGesamtAuskunft
     */
    public function addToZusatzangabe($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The zusatzangabe property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->zusatzangabe[] = $item;
        return $this;
    }
    /**
     * Get kursortAenderungen value
     * @return \InGeKurs\KursStructType\KursortAenderung[]|null
     */
    public function getKursortAenderungen()
    {
        return $this->kursortAenderungen;
    }
    /**
     * This method is responsible for validating the values passed to the setKursortAenderungen method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKursortAenderungen method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKursortAenderungenForArrayConstraintsFromSetKursortAenderungen(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kursGesamtAuskunftKursortAenderungenItem) {
            // validation for constraint: itemType
            if (!$kursGesamtAuskunftKursortAenderungenItem instanceof \InGeKurs\KursStructType\KursortAenderung) {
                $invalidValues[] = is_object($kursGesamtAuskunftKursortAenderungenItem) ? get_class($kursGesamtAuskunftKursortAenderungenItem) : sprintf('%s(%s)', gettype($kursGesamtAuskunftKursortAenderungenItem), var_export($kursGesamtAuskunftKursortAenderungenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kursortAenderungen property can only contain items of type \InGeKurs\KursStructType\KursortAenderung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kursortAenderungen value
     * @throws \InvalidArgumentException
     * @param \InGeKurs\KursStructType\KursortAenderung[] $kursortAenderungen
     * @return \InGeKurs\KursStructType\KursGesamtAuskunft
     */
    public function setKursortAenderungen(array $kursortAenderungen = array())
    {
        // validation for constraint: array
        if ('' !== ($kursortAenderungenArrayErrorMessage = self::validateKursortAenderungenForArrayConstraintsFromSetKursortAenderungen($kursortAenderungen))) {
            throw new \InvalidArgumentException($kursortAenderungenArrayErrorMessage, __LINE__);
        }
        $this->kursortAenderungen = $kursortAenderungen;
        return $this;
    }
    /**
     * Add item to kursortAenderungen value
     * @throws \InvalidArgumentException
     * @param \InGeKurs\KursStructType\KursortAenderung $item
     * @return \InGeKurs\KursStructType\KursGesamtAuskunft
     */
    public function addToKursortAenderungen(\InGeKurs\KursStructType\KursortAenderung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \InGeKurs\KursStructType\KursortAenderung) {
            throw new \InvalidArgumentException(sprintf('The kursortAenderungen property can only contain items of type \InGeKurs\KursStructType\KursortAenderung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kursortAenderungen[] = $item;
        return $this;
    }
}
