<?php

namespace InGeKurs\KursStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KursAuskunftOutputMessage KursStructType
 * @subpackage Structs
 */
class KursAuskunftOutputMessage extends AbstractStructBase
{
    /**
     * The transaktionsdaten
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \InGeKurs\KursStructType\Transaktionsdaten
     */
    public $transaktionsdaten;
    /**
     * The kursplanung
     * Meta information extracted from the WSDL
     * - documentation: Die aktuellen Daten der Kursplanung, falls zu der gesuchten Kurskennung eine (noch nicht durch Kursbeginn abgelöste) Kursplanung erfasst ist.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \InGeKurs\KursStructType\Kursplanung
     */
    public $kursplanung;
    /**
     * The kursabschnittsbeginn
     * Meta information extracted from the WSDL
     * - documentation: Die Daten des letzten gemeldeten Kursabschnitts, falls zu der gesuchten Kurskennung ein bereits begonnener Kurs erfasst ist.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \InGeKurs\KursStructType\Kursabschnittsbeginn
     */
    public $kursabschnittsbeginn;
    /**
     * The kursDaten
     * Meta information extracted from the WSDL
     * - documentation: Allgemeine nicht änderbare Angaben zu einem bereits begonnenen Kurs.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \InGeKurs\KursStructType\KursGesamtAuskunft
     */
    public $kursDaten;
    /**
     * Constructor method for KursAuskunftOutputMessage
     * @uses KursAuskunftOutputMessage::setTransaktionsdaten()
     * @uses KursAuskunftOutputMessage::setKursplanung()
     * @uses KursAuskunftOutputMessage::setKursabschnittsbeginn()
     * @uses KursAuskunftOutputMessage::setKursDaten()
     * @param \InGeKurs\KursStructType\Transaktionsdaten $transaktionsdaten
     * @param \InGeKurs\KursStructType\Kursplanung $kursplanung
     * @param \InGeKurs\KursStructType\Kursabschnittsbeginn $kursabschnittsbeginn
     * @param \InGeKurs\KursStructType\KursGesamtAuskunft $kursDaten
     */
    public function __construct(\InGeKurs\KursStructType\Transaktionsdaten $transaktionsdaten = null, \InGeKurs\KursStructType\Kursplanung $kursplanung = null, \InGeKurs\KursStructType\Kursabschnittsbeginn $kursabschnittsbeginn = null, \InGeKurs\KursStructType\KursGesamtAuskunft $kursDaten = null)
    {
        $this
            ->setTransaktionsdaten($transaktionsdaten)
            ->setKursplanung($kursplanung)
            ->setKursabschnittsbeginn($kursabschnittsbeginn)
            ->setKursDaten($kursDaten);
    }
    /**
     * Get transaktionsdaten value
     * @return \InGeKurs\KursStructType\Transaktionsdaten
     */
    public function getTransaktionsdaten()
    {
        return $this->transaktionsdaten;
    }
    /**
     * Set transaktionsdaten value
     * @param \InGeKurs\KursStructType\Transaktionsdaten $transaktionsdaten
     * @return \InGeKurs\KursStructType\KursAuskunftOutputMessage
     */
    public function setTransaktionsdaten(\InGeKurs\KursStructType\Transaktionsdaten $transaktionsdaten = null)
    {
        $this->transaktionsdaten = $transaktionsdaten;
        return $this;
    }
    /**
     * Get kursplanung value
     * @return \InGeKurs\KursStructType\Kursplanung|null
     */
    public function getKursplanung()
    {
        return $this->kursplanung;
    }
    /**
     * Set kursplanung value
     * @param \InGeKurs\KursStructType\Kursplanung $kursplanung
     * @return \InGeKurs\KursStructType\KursAuskunftOutputMessage
     */
    public function setKursplanung(\InGeKurs\KursStructType\Kursplanung $kursplanung = null)
    {
        $this->kursplanung = $kursplanung;
        return $this;
    }
    /**
     * Get kursabschnittsbeginn value
     * @return \InGeKurs\KursStructType\Kursabschnittsbeginn|null
     */
    public function getKursabschnittsbeginn()
    {
        return $this->kursabschnittsbeginn;
    }
    /**
     * Set kursabschnittsbeginn value
     * @param \InGeKurs\KursStructType\Kursabschnittsbeginn $kursabschnittsbeginn
     * @return \InGeKurs\KursStructType\KursAuskunftOutputMessage
     */
    public function setKursabschnittsbeginn(\InGeKurs\KursStructType\Kursabschnittsbeginn $kursabschnittsbeginn = null)
    {
        $this->kursabschnittsbeginn = $kursabschnittsbeginn;
        return $this;
    }
    /**
     * Get kursDaten value
     * @return \InGeKurs\KursStructType\KursGesamtAuskunft|null
     */
    public function getKursDaten()
    {
        return $this->kursDaten;
    }
    /**
     * Set kursDaten value
     * @param \InGeKurs\KursStructType\KursGesamtAuskunft $kursDaten
     * @return \InGeKurs\KursStructType\KursAuskunftOutputMessage
     */
    public function setKursDaten(\InGeKurs\KursStructType\KursGesamtAuskunft $kursDaten = null)
    {
        $this->kursDaten = $kursDaten;
        return $this;
    }
}
