<?php

namespace InGeKurs\KursStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Abschnitt KursStructType
 * @subpackage Structs
 */
class Abschnitt extends AbstractStructBase
{
    /**
     * The beginn
     * Meta information extracted from the WSDL
     * - documentation: Das geplante Beginndatum des Kursabschnitts.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $beginn;
    /**
     * The ende
     * Meta information extracted from the WSDL
     * - documentation: Das geplante Endedatum des Kursabschnitts.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ende;
    /**
     * The kursabschnitt
     * Meta information extracted from the WSDL
     * - documentation: Codeliste 803. Optional für Wiederholerkurse.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $kursabschnitt;
    /**
     * Constructor method for Abschnitt
     * @uses Abschnitt::setBeginn()
     * @uses Abschnitt::setEnde()
     * @uses Abschnitt::setKursabschnitt()
     * @param string $beginn
     * @param string $ende
     * @param string $kursabschnitt
     */
    public function __construct($beginn = null, $ende = null, $kursabschnitt = null)
    {
        $this
            ->setBeginn($beginn)
            ->setEnde($ende)
            ->setKursabschnitt($kursabschnitt);
    }
    /**
     * Get beginn value
     * @return string
     */
    public function getBeginn()
    {
        return $this->beginn;
    }
    /**
     * Set beginn value
     * @param string $beginn
     * @return \InGeKurs\KursStructType\Abschnitt
     */
    public function setBeginn($beginn = null)
    {
        // validation for constraint: string
        if (!is_null($beginn) && !is_string($beginn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beginn, true), gettype($beginn)), __LINE__);
        }
        $this->beginn = $beginn;
        return $this;
    }
    /**
     * Get ende value
     * @return string
     */
    public function getEnde()
    {
        return $this->ende;
    }
    /**
     * Set ende value
     * @param string $ende
     * @return \InGeKurs\KursStructType\Abschnitt
     */
    public function setEnde($ende = null)
    {
        // validation for constraint: string
        if (!is_null($ende) && !is_string($ende)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ende, true), gettype($ende)), __LINE__);
        }
        $this->ende = $ende;
        return $this;
    }
    /**
     * Get kursabschnitt value
     * @return string|null
     */
    public function getKursabschnitt()
    {
        return $this->kursabschnitt;
    }
    /**
     * Set kursabschnitt value
     * @param string $kursabschnitt
     * @return \InGeKurs\KursStructType\Abschnitt
     */
    public function setKursabschnitt($kursabschnitt = null)
    {
        // validation for constraint: string
        if (!is_null($kursabschnitt) && !is_string($kursabschnitt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kursabschnitt, true), gettype($kursabschnitt)), __LINE__);
        }
        $this->kursabschnitt = $kursabschnitt;
        return $this;
    }
}
