<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TeilnehmerIdentifikation StructType
 * @subpackage Structs
 */
class TeilnehmerIdentifikation extends AbstractStructBase
{
    /**
     * The aktenzeichen
     * Meta information extracted from the WSDL
     * - documentation: Das dem Teilnehmer zugeordnete Aktenzeichen aus der Berechtigung/Verpflichtung von BAMF, ABH, TGS oder BVA. Die Identifizierung ist nur dann erfolgreich, wenn das ebenfalls übermittelte Geburtsdatum zum Aktenzeichen passt und die
     * Kombination aus beidem genau eine Person eindeutig bezeichnen. Das BAMF-Aktenzeichen verbessert die Identifikation, da es eindeutig und garantiert bereits im System bekannt ist.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $aktenzeichen;
    /**
     * The geburtsdatum
     * Meta information extracted from the WSDL
     * - documentation: Das Geburtsdatum wird zur Validierung des Aktenzeichens herangezogen. Format ist TT.MM.JJJJ. Tag und Monat können unbekannt sein, dargestellt als 00. Dieses muss zur Identifikation mit dem in InGe gespeicherten übereinstimmen,
     * wobei 00 und 01 für Tag bzw. Monat als äquivalent betrachtet werden.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $geburtsdatum;
    /**
     * Constructor method for TeilnehmerIdentifikation
     * @uses TeilnehmerIdentifikation::setAktenzeichen()
     * @uses TeilnehmerIdentifikation::setGeburtsdatum()
     * @param string $aktenzeichen
     * @param string $geburtsdatum
     */
    public function __construct($aktenzeichen = null, $geburtsdatum = null)
    {
        $this
            ->setAktenzeichen($aktenzeichen)
            ->setGeburtsdatum($geburtsdatum);
    }
    /**
     * Get aktenzeichen value
     * @return string
     */
    public function getAktenzeichen()
    {
        return $this->aktenzeichen;
    }
    /**
     * Set aktenzeichen value
     * @param string $aktenzeichen
     * @return \StructType\TeilnehmerIdentifikation
     */
    public function setAktenzeichen($aktenzeichen = null)
    {
        // validation for constraint: string
        if (!is_null($aktenzeichen) && !is_string($aktenzeichen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aktenzeichen, true), gettype($aktenzeichen)), __LINE__);
        }
        $this->aktenzeichen = $aktenzeichen;
        return $this;
    }
    /**
     * Get geburtsdatum value
     * @return string
     */
    public function getGeburtsdatum()
    {
        return $this->geburtsdatum;
    }
    /**
     * Set geburtsdatum value
     * @param string $geburtsdatum
     * @return \StructType\TeilnehmerIdentifikation
     */
    public function setGeburtsdatum($geburtsdatum = null)
    {
        // validation for constraint: string
        if (!is_null($geburtsdatum) && !is_string($geburtsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geburtsdatum, true), gettype($geburtsdatum)), __LINE__);
        }
        $this->geburtsdatum = $geburtsdatum;
        return $this;
    }
}
